/**
 * 
 */
package de.laliluna.library;

import java.sql.Types;
import java.util.List;

import org.hibernate.validator.MaxValidator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

/**
 * @author hennebrueder
 *
 */
public class LibraryDaoImp implements LibraryDao {

	private JdbcTemplate jdbcTemplate;
	private DataFieldMaxValueIncrementer bookIncrementer;
	
	public void setJdbcTemplate(JdbcTemplate jdbcTemplate){
		this.jdbcTemplate = jdbcTemplate;
	}
	
	public void setBookIncrementer(DataFieldMaxValueIncrementer bookIncrementer) {
		this.bookIncrementer = bookIncrementer;
	}

	/* (non-Javadoc)
	 * @see de.laliluna.library.LibraryDao#insertBook(de.laliluna.library.Book)
	 */
	public Book insertBook(Book book) {
		//get next autoincrement value
		Integer id = bookIncrementer.nextIntValue();
		book.setId(id);
		//we do not set borrowedby here as it will be set only later  when the book is borrowed
		String sql = "insert into book (id, title, author) values (?,?,?)";
		Object args []= new Object[] { id, book.getTitle(), book.getAuthor() };
		int types[] = new int[] { Types.INTEGER, Types.VARCHAR, Types.VARCHAR };
		jdbcTemplate.update(sql, args, types);
		
		return book;
	}

	/* (non-Javadoc)
	 * @see de.laliluna.library.LibraryDao#updateBook(de.laliluna.library.Book)
	 */
	public void updateBook(Book book) {
		String sql = "update book set title=?, author=?, borrowedby=? where id = ?";
		Object args []= new Object[] { book.getTitle(), book.getAuthor(), book.getBorrowedBy(), book.getId() };
		int types[] = new int[] { Types.VARCHAR, Types.VARCHAR, Types.INTEGER, Types.INTEGER };
		jdbcTemplate.update(sql, args, types);
	}

	/* (non-Javadoc)
	 * @see de.laliluna.library.LibraryDao#deleteBook(de.laliluna.library.Book)
	 */
	public void deleteBook(Book book) {
		String sql = "delete from book where id = ?";
		Object params[] = new Object[] {book.getId()};
		int types[] = new int [] {Types.INTEGER};		
		jdbcTemplate.update(sql, params, types);
	}

	/* (non-Javadoc)
	 * @see de.laliluna.library.LibraryDao#getBooks()
	 */
	public List getBooks() {
		String sql = "select * from book";
		return jdbcTemplate.query(sql, new BookRowMapper());
	}

}
