/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class DutchAnalyzer
extends Analyzer {
    public static final String[] DUTCH_STOP_WORDS = new String[]{"de", "en", "van", "ik", "te", "dat", "die", "in", "een", "hij", "het", "niet", "zijn", "is", "was", "op", "aan", "met", "als", "voor", "had", "er", "maar", "om", "hem", "dan", "zou", "of", "wat", "mijn", "men", "dit", "zo", "door", "over", "ze", "zich", "bij", "ook", "tot", "je", "mij", "uit", "der", "daar", "haar", "naar", "heb", "hoe", "heeft", "hebben", "deze", "u", "want", "nog", "zal", "me", "zij", "nu", "ge", "geen", "omdat", "iets", "worden", "toch", "al", "waren", "veel", "meer", "doen", "toen", "moet", "ben", "zonder", "kan", "hun", "dus", "alles", "onder", "ja", "eens", "hier", "wie", "werd", "altijd", "doch", "wordt", "wezen", "kunnen", "ons", "zelf", "tegen", "na", "reeds", "wil", "kon", "niets", "uw", "iemand", "geweest", "andere"};
    private Set stoptable = new HashSet();
    private Set excltable = new HashSet();
    private Map stemdict = new HashMap();

    public DutchAnalyzer() {
        this.stoptable = StopFilter.makeStopSet(DUTCH_STOP_WORDS);
        this.stemdict.put("fiets", "fiets");
        this.stemdict.put("bromfiets", "bromfiets");
        this.stemdict.put("ei", "eier");
        this.stemdict.put("kind", "kinder");
    }

    public DutchAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet(stopwords);
    }

    public DutchAnalyzer(HashSet stopwords) {
        this.stoptable = stopwords;
    }

    public DutchAnalyzer(File stopwords) {
        try {
            this.stoptable = WordlistLoader.getWordSet(stopwords);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.excltable = StopFilter.makeStopSet(exclusionlist);
    }

    public void setStemExclusionTable(HashSet exclusionlist) {
        this.excltable = exclusionlist;
    }

    public void setStemExclusionTable(File exclusionlist) {
        try {
            this.excltable = WordlistLoader.getWordSet(exclusionlist);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStemDictionary(File stemdictFile) {
        try {
            this.stemdict = WordlistLoader.getStemDict(stemdictFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new StopFilter(result, this.stoptable);
        result = new DutchStemFilter(result, this.excltable, this.stemdict);
        return result;
    }
}

