/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.query;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

public class QueryAutoStopWordAnalyzer
extends Analyzer {
    Analyzer delegate;
    HashMap stopWordsPerField = new HashMap();
    public static final float defaultMaxDocFreqPercent = 0.4f;

    public QueryAutoStopWordAnalyzer(Analyzer delegate) {
        this.delegate = delegate;
    }

    public int addStopWords(IndexReader reader) throws IOException {
        return this.addStopWords(reader, 0.4f);
    }

    public int addStopWords(IndexReader reader, int maxDocFreq) throws IOException {
        int numStopWords = 0;
        Collection fieldNames = reader.getFieldNames(IndexReader.FieldOption.INDEXED);
        Iterator iter = fieldNames.iterator();
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            numStopWords += this.addStopWords(reader, fieldName, maxDocFreq);
        }
        return numStopWords;
    }

    public int addStopWords(IndexReader reader, float maxPercentDocs) throws IOException {
        int numStopWords = 0;
        Collection fieldNames = reader.getFieldNames(IndexReader.FieldOption.INDEXED);
        Iterator iter = fieldNames.iterator();
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            numStopWords += this.addStopWords(reader, fieldName, maxPercentDocs);
        }
        return numStopWords;
    }

    public int addStopWords(IndexReader reader, String fieldName, float maxPercentDocs) throws IOException {
        return this.addStopWords(reader, fieldName, (int)((float)reader.numDocs() * maxPercentDocs));
    }

    public int addStopWords(IndexReader reader, String fieldName, int maxDocFreq) throws IOException {
        HashSet<String> stopWords = new HashSet<String>();
        String internedFieldName = fieldName.intern();
        TermEnum te = reader.terms(new Term(fieldName));
        Term term = te.term();
        while (term != null && term.field() == internedFieldName) {
            if (te.docFreq() > maxDocFreq) {
                stopWords.add(term.text());
            }
            if (!te.next()) break;
            term = te.term();
        }
        this.stopWordsPerField.put(fieldName, stopWords);
        return stopWords.size();
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = this.delegate.tokenStream(fieldName, reader);
        HashSet stopWords = (HashSet)this.stopWordsPerField.get(fieldName);
        if (stopWords != null) {
            result = new StopFilter(result, stopWords);
        }
        return result;
    }

    public String[] getStopWords(String fieldName) {
        HashSet stopWords = (HashSet)this.stopWordsPerField.get(fieldName);
        String[] result = stopWords != null ? stopWords.toArray(new String[stopWords.size()]) : new String[]{};
        return result;
    }

    public Term[] getStopWords() {
        ArrayList<Term> allStopWords = new ArrayList<Term>();
        Iterator iter = this.stopWordsPerField.keySet().iterator();
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            HashSet stopWords = (HashSet)this.stopWordsPerField.get(fieldName);
            Iterator iterator = stopWords.iterator();
            while (iterator.hasNext()) {
                String text = (String)iterator.next();
                allStopWords.add(new Term(fieldName, text));
            }
        }
        return allStopWords.toArray(new Term[allStopWords.size()]);
    }
}

