/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.getopt.luke.KeepAllIndexDeletionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexGate {
    static Field deletable = null;
    static Field hasChanges = null;
    static PrintStream infoStream = IndexWriter.getDefaultInfoStream();
    static HashMap<String, String> knownExtensions = new HashMap();

    public static String getFileFunction(String string) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        String string2 = null;
        string = string.trim();
        int n = string.indexOf(46);
        String string3 = null;
        if (n != -1) {
            string3 = string.substring(n + 1);
        }
        if (string3 == null) {
            if (string.startsWith("segments_")) {
                return knownExtensions.get("segments");
            }
        } else {
            string2 = knownExtensions.get(string3);
            if (string2 != null) {
                return string2;
            }
            if (string3.length() == 2) {
                string2 = knownExtensions.get(string3.substring(0, 1));
            }
        }
        return string2;
    }

    public static int getIndexFormat(final Directory directory) throws Exception {
        SegmentInfos.FindSegmentsFile findSegmentsFile = new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String string) throws CorruptIndexException, IOException {
                IndexInput indexInput = directory.openInput(string);
                Integer n = new Integer(indexInput.readInt());
                indexInput.close();
                return n;
            }
        };
        Integer n = (Integer)findSegmentsFile.run();
        return n;
    }

    public static int getCurrentIndexFormat() {
        return -7;
    }

    public static FormatDetails getFormatDetails(int n) {
        FormatDetails formatDetails = new FormatDetails();
        switch (n) {
            case -1: {
                formatDetails.capabilities = "old plain";
                formatDetails.genericName = "Lucene Pre-2.1";
                break;
            }
            case -2: {
                formatDetails.capabilities = "lock-less";
                formatDetails.genericName = "Lucene 2.1";
                break;
            }
            case -3: {
                formatDetails.capabilities = "lock-less, single norms file";
                formatDetails.genericName = "Lucene 2.2";
                break;
            }
            case -4: {
                formatDetails.capabilities = "lock-less, single norms file, shared doc store";
                formatDetails.genericName = "Lucene 2.3";
                break;
            }
            case -5: {
                formatDetails.capabilities = "lock-less, single norms, shared doc store, checksum";
                formatDetails.genericName = "Lucene 2.4";
                break;
            }
            case -6: {
                formatDetails.capabilities = "lock-less, single norms, shared doc store, checksum, del count";
                formatDetails.genericName = "Lucene 2.4";
                break;
            }
            case -7: {
                formatDetails.capabilities = "lock-less, single norms, shared doc store, checksum, del count, omitTf";
                formatDetails.genericName = "Lucene 2.4";
                break;
            }
            default: {
                formatDetails.capabilities = "unknown";
                formatDetails.genericName = "Lucene 1.3 or prior";
            }
        }
        if (-7 > n) {
            formatDetails.capabilities = "(WARNING: newer version of Lucene that this tool)";
            formatDetails.genericName = "UNKNOWN";
        }
        return formatDetails;
    }

    public static boolean preferCompoundFormat(Directory directory) throws Exception {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < segmentInfos.size(); ++i) {
            if (((SegmentInfo)segmentInfos.get(i)).getUseCompoundFile()) {
                ++n;
                continue;
            }
            ++n2;
        }
        return n > n2;
    }

    public static void deletePendingFiles(Directory directory, IndexDeletionPolicy indexDeletionPolicy) throws Exception {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        IndexFileDeleter indexFileDeleter = new IndexFileDeleter(directory, indexDeletionPolicy, segmentInfos, infoStream, null);
        indexFileDeleter.close();
    }

    public static List<String> getDeletableFiles(Directory directory) throws Exception {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        IndexFileDeleter indexFileDeleter = new IndexFileDeleter(directory, new KeepAllIndexDeletionPolicy(), segmentInfos, infoStream, null);
        return (List)deletable.get(indexFileDeleter);
    }

    public static List<String> getIndexFiles(Directory directory) throws Exception {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < segmentInfos.size(); ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            arrayList.addAll(segmentInfo.files());
            arrayList.add(segmentInfo.getDelFileName());
        }
        arrayList.add(segmentInfos.getCurrentSegmentFileName());
        arrayList.add("segments.gen");
        return arrayList;
    }

    public boolean hasChanges(IndexReader indexReader) {
        if (indexReader == null) {
            return false;
        }
        try {
            return hasChanges.getBoolean(indexReader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        knownExtensions.put("cfs", "compound file with various index data");
        knownExtensions.put("cfx", "compound shared doc store file");
        knownExtensions.put("deletable", "list of deletable files (pre-lockless index)");
        knownExtensions.put("del", "list of deleted documents");
        knownExtensions.put("fnm", "field names / infos");
        knownExtensions.put("fdt", "stored fields data");
        knownExtensions.put("fdx", "stored fields index data");
        knownExtensions.put("frq", "term frequency postings data");
        knownExtensions.put("gen", "generation number - global file");
        knownExtensions.put("nrm", "norms data for all fields");
        knownExtensions.put("f", "per-field norms data");
        knownExtensions.put("prx", "term position postings data");
        knownExtensions.put("segments", "per-commit list of segments");
        knownExtensions.put("s", "separate per-field norms data");
        knownExtensions.put("tis", "terms dictionary");
        knownExtensions.put("tii", "terms dictionary index");
        knownExtensions.put("tvd", "term vectors document data");
        knownExtensions.put("tvf", "term vector field data");
        knownExtensions.put("tvx", "term vectors index");
        try {
            deletable = IndexFileDeleter.class.getDeclaredField("deletable");
            deletable.setAccessible(true);
            hasChanges = IndexReader.class.getDeclaredField("hasChanges");
            hasChanges.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class FormatDetails {
        public String genericName;
        public String capabilities;
    }
}

