/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.analyzing;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

public class AnalyzingQueryParser
extends QueryParser {
    public AnalyzingQueryParser(String field, Analyzer analyzer) {
        super(field, analyzer);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        ArrayList<String> tlist = new ArrayList<String>();
        ArrayList<String> wlist = new ArrayList<String>();
        boolean isWithinToken = !termStr.startsWith("?") && !termStr.startsWith("*");
        StringBuffer tmpBuffer = new StringBuffer();
        char[] chars = termStr.toCharArray();
        for (int i = 0; i < termStr.length(); ++i) {
            if (chars[i] == '?' || chars[i] == '*') {
                if (isWithinToken) {
                    tlist.add(tmpBuffer.toString());
                    tmpBuffer.setLength(0);
                }
                isWithinToken = false;
            } else {
                if (!isWithinToken) {
                    wlist.add(tmpBuffer.toString());
                    tmpBuffer.setLength(0);
                }
                isWithinToken = true;
            }
            tmpBuffer.append(chars[i]);
        }
        if (isWithinToken) {
            tlist.add(tmpBuffer.toString());
        } else {
            wlist.add(tmpBuffer.toString());
        }
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(termStr));
        Token reusableToken = new Token();
        int countTokens = 0;
        while (true) {
            Token nextToken;
            try {
                nextToken = source.next(reusableToken);
            }
            catch (IOException e) {
                nextToken = null;
            }
            if (nextToken == null) break;
            String term = nextToken.term();
            if ("".equals(term)) continue;
            try {
                tlist.set(countTokens++, term);
            }
            catch (IndexOutOfBoundsException ioobe) {
                countTokens = -1;
            }
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (countTokens != tlist.size()) {
            throw new ParseException("Cannot build WildcardQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens added or lost");
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1) {
            if (wlist != null && wlist.size() == 1) {
                return super.getWildcardQuery(field, (String)tlist.get(0) + ((String)wlist.get(0)).toString());
            }
            throw new IllegalArgumentException("getWildcardQuery called without wildcard");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tlist.size(); ++i) {
            sb.append((String)tlist.get(i));
            if (wlist == null || wlist.size() <= i) continue;
            sb.append((String)wlist.get(i));
        }
        return super.getWildcardQuery(field, sb.toString());
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(termStr));
        ArrayList<String> tlist = new ArrayList<String>();
        Token reusableToken = new Token();
        while (true) {
            Token nextToken;
            try {
                nextToken = source.next(reusableToken);
            }
            catch (IOException e) {
                nextToken = null;
            }
            if (nextToken == null) break;
            tlist.add(nextToken.term());
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (tlist.size() == 1) {
            return super.getPrefixQuery(field, (String)tlist.get(0));
        }
        throw new ParseException("Cannot build PrefixQuery with analyzer " + this.getAnalyzer().getClass() + (tlist.size() > 1 ? " - token(s) added" : " - token consumed"));
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        Token nextToken;
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(termStr));
        Token reusableToken = new Token();
        boolean multipleTokens = false;
        try {
            nextToken = source.next(reusableToken);
            multipleTokens = source.next(reusableToken) != null;
        }
        catch (IOException e) {
            nextToken = null;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build FuzzyQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added");
        }
        return nextToken == null ? null : super.getFuzzyQuery(field, nextToken.term(), minSimilarity);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        Token nextToken;
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(part1));
        Token reusableToken = new Token();
        boolean multipleTokens = false;
        try {
            nextToken = source.next(reusableToken);
            if (nextToken != null) {
                part1 = nextToken.term();
            }
            multipleTokens = source.next(reusableToken) != null;
        }
        catch (IOException e) {
            nextToken = null;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build RangeQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added to part1");
        }
        source = this.getAnalyzer().tokenStream(field, new StringReader(part2));
        try {
            nextToken = source.next(reusableToken);
            if (nextToken != null) {
                part2 = nextToken.term();
            }
            multipleTokens = source.next(reusableToken) != null;
        }
        catch (IOException e) {
            nextToken = null;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build RangeQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added to part2");
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }
}

