/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.getopt.luke.LimitedException;
import org.getopt.luke.LimitedHitCollector;

public class CountLimitedHitCollector
extends LimitedHitCollector {
    private long maxSize;
    private long count;
    private int lastDoc;
    private TopDocCollector tdc;
    private TopDocs topDocs = null;

    public CountLimitedHitCollector(long l) {
        this.maxSize = l;
        this.count = 0L;
        this.tdc = new TopDocCollector((int)l);
    }

    public long limitSize() {
        return this.maxSize;
    }

    public int limitType() {
        return 1;
    }

    public void collect(int n, float f) {
        ++this.count;
        if (this.count > this.maxSize) {
            --this.count;
            throw new LimitedException(1, this.maxSize, this.count, this.lastDoc);
        }
        this.lastDoc = n;
        this.tdc.collect(n, f);
    }

    public int getDocId(int n) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[n].doc;
    }

    public float getScore(int n) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[n].score;
    }

    public int getTotalHits() {
        return (int)this.count;
    }
}

