/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.getopt.luke.GrowableStringArray;
import org.getopt.luke.ProgressNotification;

public class DocReconstructor
extends Observable {
    private ProgressNotification progress = new ProgressNotification();
    private String[] fieldNames = null;
    private IndexReader reader = null;
    private int numTerms;

    public DocReconstructor(IndexReader indexReader) throws Exception {
        this(indexReader, null, -1);
    }

    public DocReconstructor(IndexReader indexReader, String[] stringArray, int n) throws Exception {
        if (indexReader == null) {
            throw new Exception("IndexReader cannot be null.");
        }
        this.reader = indexReader;
        this.fieldNames = stringArray == null || stringArray.length == 0 ? indexReader.getFieldNames(IndexReader.FieldOption.ALL).toArray(new String[0]) : stringArray;
        if (n == -1) {
            TermEnum termEnum = indexReader.terms();
            n = 0;
            while (termEnum.next()) {
                ++n;
            }
            termEnum.close();
            this.numTerms = n;
        }
    }

    public Reconstructed reconstruct(int n) throws Exception {
        int n2;
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        int n3;
        if (n < 0 || n > this.reader.maxDoc()) {
            throw new Exception("Document number outside of valid range.");
        }
        Reconstructed reconstructed = new Reconstructed();
        if (this.reader.isDeleted(n)) {
            throw new Exception("Document is deleted.");
        }
        Serializable serializable = this.reader.document(n);
        for (n3 = 0; n3 < this.fieldNames.length; ++n3) {
            object3 = ((Document)serializable).getFields(this.fieldNames[n3]);
            if (object3 == null || ((Field[])object3).length <= 0) continue;
            reconstructed.getStoredFields().put(this.fieldNames[n3], (Field[])object3);
        }
        serializable = new HashSet<String>(Arrays.asList(this.fieldNames));
        this.progress.maxValue = this.fieldNames.length;
        this.progress.curValue = 0;
        this.progress.minValue = 0;
        for (n3 = 0; n3 < this.fieldNames.length; ++n3) {
            object3 = this.reader.getTermFreqVector(n, this.fieldNames[n3]);
            if (object3 == null || object3.size() <= 0 || !(object3 instanceof TermPositionVector)) continue;
            object2 = (TermPositionVector)object3;
            this.progress.message = "Reading term vectors ...";
            this.progress.curValue = n3;
            this.setChanged();
            this.notifyObservers(this.progress);
            stringArray = object2.getTerms();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object4;
                object = object2.getTermPositions(i);
                if (object == null) {
                    object4 = object2.getOffsets(i);
                    if (((TermVectorOffsetInfo[])object4).length == 0) continue;
                    object = this.convertOffsets((TermVectorOffsetInfo[])object4);
                }
                if ((object4 = reconstructed.getReconstructedFields().get(this.fieldNames[n3])) == null) {
                    object4 = new GrowableStringArray();
                    reconstructed.getReconstructedFields().put(this.fieldNames[n3], (GrowableStringArray)object4);
                }
                for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                    ((GrowableStringArray)object4).append(object[n2], "|", stringArray[i]);
                }
            }
            ((HashSet)serializable).remove(this.fieldNames[n3]);
        }
        String string = null;
        object3 = this.reader.termPositions();
        this.progress.maxValue = ((HashSet)serializable).size();
        this.progress.curValue = 0;
        this.progress.minValue = 0;
        object2 = ((HashSet)serializable).iterator();
        while (object2.hasNext()) {
            stringArray = (String[])object2.next();
            this.progress.message = "Collecting terms in " + (String)stringArray + " ...";
            ++this.progress.curValue;
            this.setChanged();
            this.notifyObservers(this.progress);
            TermEnum termEnum = this.reader.terms(new Term((String)stringArray, ""));
            if (termEnum == null || !termEnum.term().field().equals(stringArray)) continue;
            while (termEnum.term().field().equals(stringArray)) {
                object3.seek(termEnum.term());
                if (object3.skipTo(n) && object3.doc() == n) {
                    string = termEnum.term().text();
                    object = reconstructed.getReconstructedFields().get(termEnum.term().field());
                    if (object == null) {
                        object = new GrowableStringArray();
                        reconstructed.getReconstructedFields().put(termEnum.term().field(), (GrowableStringArray)object);
                    }
                    for (int i = 0; i < object3.freq(); ++i) {
                        n2 = object3.nextPosition();
                        object.append(n2, "|", string);
                    }
                }
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        object3.close();
        this.progress.message = "Done.";
        this.progress.curValue = 100;
        this.setChanged();
        this.notifyObservers(this.progress);
        return reconstructed;
    }

    private int[] convertOffsets(TermVectorOffsetInfo[] termVectorOffsetInfoArray) {
        int[] nArray = new int[termVectorOffsetInfoArray.length];
        int n = 0;
        int n2 = 3;
        int n3 = 5;
        for (int i = 0; i < termVectorOffsetInfoArray.length; ++i) {
            int n4 = termVectorOffsetInfoArray[i].getStartOffset();
            if (i > 0) {
                int n5 = termVectorOffsetInfoArray[i - 1].getEndOffset();
                int n6 = termVectorOffsetInfoArray[i - 1].getStartOffset();
                if (n4 != n6 && n5 + n2 < n4) {
                    int n7 = (n4 - n5) / (n2 + n3);
                    if (n7 == 0) {
                        ++n7;
                    }
                    n += n7;
                }
            }
            nArray[i] = --n;
            ++n;
        }
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reconstructed {
        private Map<String, Field[]> storedFields;
        private Map<String, GrowableStringArray> reconstructedFields;

        public Reconstructed() {
            this.storedFields = new HashMap<String, Field[]>();
            this.reconstructedFields = new HashMap<String, GrowableStringArray>();
        }

        public Reconstructed(Map<String, Field[]> map, Map<String, GrowableStringArray> map2) {
            this.storedFields = map;
            this.reconstructedFields = map2;
        }

        public List<String> getFieldNames() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.storedFields.keySet());
            hashSet.addAll(this.reconstructedFields.keySet());
            ArrayList<String> arrayList = new ArrayList<String>(hashSet.size());
            arrayList.addAll(hashSet);
            Collections.sort(arrayList);
            return arrayList;
        }

        public boolean hasField(String string) {
            return this.storedFields.containsKey(string) || this.reconstructedFields.containsKey(string);
        }

        public Map<String, Field[]> getStoredFields() {
            return this.storedFields;
        }

        public Map<String, GrowableStringArray> getReconstructedFields() {
            return this.reconstructedFields;
        }
    }
}

