/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.IndexGate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;
import org.getopt.luke.HighFreqTerms;
import org.getopt.luke.TermInfo;
import org.getopt.luke.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfo {
    private IndexReader reader;
    private String indexPath;
    private long totalFileSize;
    private int numTerms;
    private int indexFormat;
    private IndexGate.FormatDetails formatDetails;
    private TermInfo[] topTerms;
    private List<String> fieldNames;
    private String lastModified;

    public IndexInfo(IndexReader indexReader, String string) throws Exception {
        this.reader = indexReader;
        this.indexPath = string;
        this.lastModified = new Date(IndexReader.lastModified(indexReader.directory())).toString();
        this.totalFileSize = Util.calcTotalFileSize(string, indexReader.directory());
        this.numTerms = 0;
        TermEnum termEnum = indexReader.terms();
        while (termEnum.next()) {
            ++this.numTerms;
        }
        termEnum.close();
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.addAll(indexReader.getFieldNames(IndexReader.FieldOption.ALL));
        Collections.sort(this.fieldNames);
        this.indexFormat = IndexGate.getIndexFormat(indexReader.directory());
        this.formatDetails = IndexGate.getFormatDetails(this.indexFormat);
        this.topTerms = HighFreqTerms.getHighFreqTerms(indexReader.directory(), null, 51, this.fieldNames.toArray(new String[this.fieldNames.size()]));
    }

    public IndexReader getReader() {
        return this.reader;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public long getTotalFileSize() {
        return this.totalFileSize;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public int getIndexFormat() {
        return this.indexFormat;
    }

    public IndexGate.FormatDetails getFormatDetails() {
        return this.formatDetails;
    }

    public TermInfo[] getTopTerms() {
        return this.topTerms;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String getLastModified() {
        return this.lastModified;
    }
}

