/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import org.apache.lucene.search.TimeLimitedCollector;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.getopt.luke.LimitedException;
import org.getopt.luke.LimitedHitCollector;

public class IntervalLimitedCollector
extends LimitedHitCollector {
    private long maxTime;
    private long lastDoc = 0L;
    TopDocCollector tdc;
    TopDocs topDocs = null;
    TimeLimitedCollector thc;

    public IntervalLimitedCollector(int n) {
        this.maxTime = n;
        this.tdc = new TopDocCollector(1000);
        this.thc = new TimeLimitedCollector(this.tdc, n);
    }

    public long limitSize() {
        return this.maxTime;
    }

    public int limitType() {
        return 0;
    }

    public int getDocId(int n) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[n].doc;
    }

    public float getScore(int n) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[n].score;
    }

    public int getTotalHits() {
        return this.tdc.getTotalHits();
    }

    public void collect(int n, float f) {
        try {
            this.thc.collect(n, f);
        }
        catch (TimeLimitedCollector.TimeExceededException timeExceededException) {
            throw new LimitedException(0, this.maxTime, timeExceededException.getTimeElapsed(), timeExceededException.getLastDocCollected());
        }
    }
}

