/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.apache.lucene.LucenePackage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumberTools;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexGate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.misc.SweetSpotSimilarity;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.OpenBitSet;
import org.getopt.luke.AccessibleHitCollector;
import org.getopt.luke.AccessibleTopHitCollector;
import org.getopt.luke.AllHitsCollector;
import org.getopt.luke.BrowserLauncher;
import org.getopt.luke.ClassFinder;
import org.getopt.luke.CountLimitedHitCollector;
import org.getopt.luke.DocReconstructor;
import org.getopt.luke.GrowableStringArray;
import org.getopt.luke.HighFreqTerms;
import org.getopt.luke.IntPair;
import org.getopt.luke.IntervalLimitedCollector;
import org.getopt.luke.KeepAllIndexDeletionPolicy;
import org.getopt.luke.KeepLastIndexDeletionPolicy;
import org.getopt.luke.LimitedException;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.PanelPrintWriter;
import org.getopt.luke.Prefs;
import org.getopt.luke.Progress;
import org.getopt.luke.ProgressNotification;
import org.getopt.luke.Ranges;
import org.getopt.luke.TermInfo;
import org.getopt.luke.Util;
import org.getopt.luke.XMLExporter;
import org.getopt.luke.plugins.ScriptingPlugin;
import thinlet.FrameLauncher;
import thinlet.Thinlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Luke
extends Thinlet
implements ClipboardOwner {
    private Directory dir = null;
    String pName = null;
    private IndexReader ir = null;
    private IndexSearcher is = null;
    private Collection fn = null;
    private String[] idxFields = null;
    private List plugins = new ArrayList();
    private Object errorDlg = null;
    private Object infoDlg = null;
    private Object statmsg = null;
    private Analyzer stdAnalyzer = new StandardAnalyzer();
    private Analyzer analyzer = null;
    private QueryParser qp = null;
    private boolean readOnly = false;
    private boolean ram = false;
    private boolean keepCommits = false;
    private int tiiDiv = 1;
    private IndexCommit currentCommit = null;
    private Similarity similarity = null;
    public static final int THEME_DEFAULT = 0;
    public static final int THEME_GRAY = 1;
    public static final int THEME_SANDSTONE = 2;
    public static final int THEME_SKY = 3;
    public static final int THEME_NAVY = 4;
    public int[][] themes = new int[][]{{15526352, 0, 16119024, 9542554, 0xB0B0B0, 0xEDEDED, 0xB9B9B9, 0xFF8080, 0xC5C5DD}, {0xE6E6E6, 0, 0xFFFFFF, 0x909090, 0xB0B0B0, 0xEDEDED, 0xB9B9B9, 0x89899A, 0xC5C5DD}, {0xEEEECC, 0, 0xFFFFFF, 0x999966, 11579542, 15592907, 0xCCCC99, 0xCC6600, 0xFFCC66}, {0xF0F0FF, 160, 0xFFFFFF, 0x8080FF, 0xB0B0B0, 0xEDEDED, 0xB0B0FF, 0xFF0000, 16638176}, {6518230, 0xFFFFFF, 8359901, 14082037, 10267365, 0x666666, 13209, 0xFF3333, 0x666666}};
    private int numTerms = 0;
    private static boolean exitOnDestroy = false;
    private Class[] analyzers = null;
    private String baseDir = null;
    private Class[] defaultAnalyzers = new Class[]{SimpleAnalyzer.class, StandardAnalyzer.class, StopAnalyzer.class, WhitespaceAnalyzer.class};
    private static final String MSG_NOINDEX = "FAILED: No index, or index is closed. Reopen it.";
    private static final String MSG_READONLY = "FAILED: Read-Only index.";
    private static final String MSG_CONV_ERROR = "Some values could not be properly represented in this format. They are marked in grey and presented as a hex dump.";
    Class defaultDirImpl = null;
    XMLExporter exporter = null;
    Font courier = null;
    int resStart = 0;
    int resCount = 20;
    private DecimalFormat df = new DecimalFormat("0.0000");

    public Luke() {
        Prefs.load();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTheme(Prefs.getInteger("luke.theme", 0));
        String string = Prefs.getProperty("luke.fontname", "SansSerif");
        String string2 = Prefs.getProperty("luke.fontsize", "12.0");
        float f = 12.0f;
        try {
            f = Float.parseFloat(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Font font = new Font(string, 0, (int)f);
        this.setFont(font);
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.errorDlg = this.addComponent(null, "/xml/error.xml", null, null);
        this.infoDlg = this.addComponent(null, "/xml/info.xml", null, null);
        this.statmsg = this.find("statmsg");
        try {
            Object object;
            Class[] classArray = ClassFinder.getInstantiableSubclasses(Analyzer.class);
            if (classArray == null || classArray.length == 0) {
                this.analyzers = this.defaultAnalyzers;
            } else {
                object = new HashSet<Class>(Arrays.asList(classArray));
                this.analyzers = ((HashSet)object).toArray(new Class[((HashSet)object).size()]);
            }
            object = this.find("cbType");
            this.populateAnalyzers(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.loadPlugins();
    }

    public void setTheme(int n) {
        if (n < 0 || n >= this.themes.length) {
            n = 0;
        }
        int[] nArray = this.themes[n];
        this.setColors(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7], nArray[8]);
        Prefs.setProperty("luke.theme", n + "");
    }

    public void actionTheme(Object object) {
        String string = (String)this.getProperty(object, "t");
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTheme(n);
    }

    public void populateAnalyzers(Object object) {
        Object object2;
        int n;
        this.removeAll(object);
        Object[] objectArray = new String[this.analyzers.length];
        for (n = 0; n < this.analyzers.length; ++n) {
            objectArray[n] = this.analyzers[n].getName();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            object2 = Luke.create("choice");
            this.setString(object2, "text", (String)objectArray[n]);
            this.add(object, object2);
            if (n != 0) continue;
            this.setString(object, "text", (String)objectArray[n]);
        }
        n = 0;
        object2 = Prefs.getProperty("luke.analyzer");
        if (object2 != null) {
            n = this.getIndex(object, object2);
        }
        if (n < 0) {
            n = 0;
        }
        this.setInteger(object, "selected", n);
    }

    public Class[] getAnalyzers() {
        return this.analyzers;
    }

    private void loadPlugins() {
        Class<?> clazz;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            object = ClassFinder.getInstantiableSubclasses(LukePlugin.class);
            if (object != null && ((Class[])object).length > 0) {
                arrayList.addAll(Arrays.asList(object));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object = this.getClass().getResourceAsStream("/.plugins");
            if (object != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#") || string.trim().equals("")) continue;
                    try {
                        clazz = Class.forName(string.trim());
                        if (!clazz.getSuperclass().equals(LukePlugin.class) || arrayList.contains(clazz)) continue;
                        arrayList.add(clazz);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object = new StringBuffer("Unable to load some plugins:");
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    clazz = (LukePlugin)((Class)arrayList.get(i)).getConstructor(new Class[0]).newInstance(new Object[0]);
                    String string = ((LukePlugin)((Object)clazz)).getXULName();
                    if (string == null) continue;
                    Object object2 = this.parse(string, (Object)clazz);
                    ((LukePlugin)((Object)clazz)).setApplication(this);
                    ((LukePlugin)((Object)clazz)).setMyUi(object2);
                    this.plugins.add(clazz);
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                    exception.printStackTrace();
                    ((StringBuffer)object).append("\n" + arrayList.get(i).toString());
                }
            }
            if (bl) {
                this.errorMsg(((StringBuffer)object).toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.toString());
        }
        if (this.plugins.size() == 0) {
            return;
        }
        this.initPlugins();
    }

    private void addPluginTab(Object object, LukePlugin lukePlugin) {
        Object object2 = Luke.create("tab");
        this.setColor(object2, "foreground", new Color(24576));
        this.setString(object2, "text", lukePlugin.getPluginName());
        this.setFont(object2, this.getFont().deriveFont(1));
        this.add(object, object2);
        Object object3 = Luke.create("panel");
        this.setInteger(object3, "gap", 2);
        this.setInteger(object3, "weightx", 1);
        this.setInteger(object3, "weighty", 1);
        this.setChoice(object3, "halign", "fill");
        this.setChoice(object3, "valign", "fill");
        this.setInteger(object3, "columns", 1);
        this.add(object2, object3);
        Object object4 = Luke.create("panel");
        this.setInteger(object4, "gap", 8);
        this.setInteger(object4, "top", 2);
        this.setInteger(object4, "bottom", 2);
        this.setInteger(object4, "weightx", 1);
        this.setChoice(object4, "halign", "fill");
        this.setColor(object4, "background", new Color(0xC0F0C0));
        this.add(object3, object4);
        Object object5 = Luke.create("label");
        this.setString(object5, "text", lukePlugin.getPluginInfo());
        this.add(object4, object5);
        Object object6 = Luke.create("button");
        this.setChoice(object6, "type", "link");
        this.setString(object6, "text", lukePlugin.getPluginHome());
        this.putProperty(object6, "url", lukePlugin.getPluginHome());
        this.setMethod(object6, "action", "goUrl(this)", object4, this);
        this.add(object4, object6);
        this.add(object3, Luke.create("separator"));
        this.add(object3, lukePlugin.getMyUi());
    }

    public List getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public LukePlugin getPlugin(String string) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Object e = this.plugins.get(i);
            if (!e.getClass().getName().equals(string)) continue;
            return (LukePlugin)e;
        }
        return null;
    }

    public void showStatus(final String string) {
        Thread thread = new Thread(){

            public void run() {
                Luke.this.setString(Luke.this.statmsg, "text", string);
                try {
                    1.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Luke.this.setString(Luke.this.statmsg, "text", "");
            }
        };
        thread.start();
    }

    public Object addComponent(Object object, String string, String string2, Object[] objectArray) {
        Object object2 = null;
        Object var6_6 = null;
        try {
            if (string2 != null) {
                var6_6 = objectArray == null ? Class.forName(string2).getConstructor(Thinlet.class).newInstance(this) : Class.forName(string2).getConstructor(Thinlet.class, Object[].class).newInstance(this, objectArray);
            }
            object2 = var6_6 != null ? this.parse(string, var6_6) : this.parse(string);
            if (object != null) {
                if (object instanceof Thinlet) {
                    this.add(object2);
                } else {
                    this.add(object, object2);
                }
            }
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
            return null;
        }
    }

    public void errorMsg(String string) {
        Object object = this.find(this.errorDlg, "msg");
        this.setString(object, "text", string);
        this.add(this.errorDlg);
    }

    public void infoMsg(String string) {
        Object object = this.find(this.infoDlg, "msg");
        this.setString(object, "text", string);
        this.add(this.infoDlg);
    }

    public void actionOpen() {
        Object object = this.addComponent(this, "/xml/lukeinit.xml", null, null);
        Object object2 = this.find(object, "path");
        if (this.baseDir != null) {
            this.setString(object2, "text", this.baseDir);
        } else {
            this.setString(object2, "text", System.getProperty("user.dir"));
        }
    }

    public void openBrowse(Object object) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle("Select Index directory");
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileHidingEnabled(false);
        String string = this.getString(object, "text");
        if (string != null) {
            string.trim();
        }
        if (string != null && string.length() > 0) {
            jFileChooser.setCurrentDirectory(new File(string));
        } else if (this.baseDir != null) {
            jFileChooser.setCurrentDirectory(new File(this.baseDir));
        } else {
            jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        int n = jFileChooser.showOpenDialog(this);
        File file = null;
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (file != null && file.exists()) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            this.setString(object, "text", file.toString());
        }
    }

    public void saveBrowse(Object object, Object object2) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle("Select Output File");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileHidingEnabled(false);
        String string = this.getString(object, "text");
        if (string != null) {
            string.trim();
        }
        if (string != null && string.length() > 0) {
            jFileChooser.setCurrentDirectory(new File(string));
        } else if (this.baseDir != null) {
            jFileChooser.setCurrentDirectory(new File(this.baseDir));
        } else {
            jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        int n = jFileChooser.showSaveDialog(this);
        this.setBoolean(object2, "enabled", false);
        File file = null;
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (file != null) {
            this.setString(object, "text", file.toString());
            this.setBoolean(object2, "enabled", true);
        }
    }

    public void setupInit(Object object) {
        Object object2 = this.find(object, "path");
        this.syncMRU(object2);
    }

    public void openOk(Object object) {
        Object object2;
        Object object3 = this.find(object, "path");
        this.pName = this.getString(object3, "text").trim();
        boolean bl = this.getBoolean(this.find(object, "force"), "selected");
        boolean bl2 = this.getBoolean(this.find(object, "cbNoReader"), "selected");
        this.tiiDiv = 1;
        try {
            this.tiiDiv = Integer.parseInt(this.getString(this.find(object, "tiiDiv"), "text"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object4 = this.getSelectedItem(this.find(object, "dirImpl"));
        String string = null;
        if (object4 == null) {
            string = FSDirectory.class.getName();
        } else {
            object2 = this.getString(object4, "name");
            if (object2 == null) {
                string = this.getString(object4, "text");
            } else if (((String)object2).equals("fs")) {
                string = FSDirectory.class.getName();
            } else if (((String)object2).equals("mmap")) {
                string = MMapDirectory.class.getName();
            } else if (((String)object2).equals("niofs")) {
                string = NIOFSDirectory.class.getName();
            }
        }
        if (this.pName == null || this.pName.trim().equals("")) {
            this.errorMsg("Invalid path.");
            return;
        }
        this.readOnly = this.getBoolean(this.find(object, "ro"), "selected");
        this.ram = this.getBoolean(this.find(object, "ram"), "selected");
        this.keepCommits = this.getBoolean(this.find(object, "cbKeepCommits"), "selected");
        this.currentCommit = null;
        Prefs.addToMruList(this.pName);
        this.syncMRU(object3);
        this.remove(object);
        if (bl2) {
            this.removeAll();
            this.addComponent(this, "/xml/luke.xml", null, null);
            try {
                object2 = this.openDirectory(string, this.pName, false);
                if (IndexReader.indexExists((Directory)object2)) {
                    throw new Exception("there is no valid Lucene index in this directory.");
                }
                this.dir = object2;
                this.initOverview();
                this.infoMsg("There is no IndexReader - most actions are disabled. You can open IndexReader from current Directory using 'Re-Open'");
            }
            catch (Exception exception) {
                this.errorMsg("ERROR: " + exception.toString());
            }
        } else {
            this.openIndex(this.pName, bl, string, this.readOnly, this.ram, this.keepCommits, null, this.tiiDiv);
        }
    }

    public void actionClose() {
        if (this.ir != null) {
            try {
                this.is.close();
                this.ir.close();
                this.dir.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorMsg("Close failed: " + exception.getMessage());
            }
        }
        this.ir = null;
        this.dir = null;
        this.is = null;
        this.removeAll();
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.initPlugins();
    }

    public void actionCommit() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.ir.flush();
            this.initOverview();
            this.showFiles(this.dir, Collections.EMPTY_LIST);
        }
        catch (Exception exception) {
            this.errorMsg("Error: " + exception.toString());
        }
    }

    public void actionReopen() {
        if (this.dir == null) {
            return;
        }
        this.openIndex(this.pName, false, this.dir.getClass().getName(), this.readOnly, this.ram, this.keepCommits, this.currentCommit, this.tiiDiv);
    }

    public void openIndex(String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, IndexCommit indexCommit, int n) {
        this.pName = string;
        this.readOnly = bl2;
        this.removeAll();
        this.baseDir = new File(string).getParent();
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.statmsg = this.find("statmsg");
        if (this.dir != null) {
            try {
                if (this.ir != null) {
                    this.ir.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Object object;
            this.dir = this.openDirectory(string2, this.pName, false);
            if (IndexWriter.isLocked(this.dir)) {
                if (bl2) {
                    this.errorMsg("Index is locked and Read-Only. Open for read-write and 'Force unlock'.");
                    this.dir.close();
                    this.dir = null;
                    return;
                }
                if (bl) {
                    IndexWriter.unlock(this.dir);
                } else {
                    this.errorMsg("Index is locked. Try 'Force unlock' when opening.");
                    this.dir.close();
                    this.dir = null;
                    return;
                }
            }
            if (bl3) {
                this.showStatus("Loading index into RAMDirectory ...");
                object = new RAMDirectory();
                IndexWriter indexWriter = new IndexWriter((Directory)object, (Analyzer)new SimpleAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                indexWriter.addIndexesNoOptimize(new Directory[]{this.dir});
                indexWriter.close();
                this.showStatus("RAMDirectory loading done!");
                this.dir.close();
                this.dir = object;
            }
            object = bl4 ? new KeepAllIndexDeletionPolicy() : new KeepLastIndexDeletionPolicy();
            if (!IndexReader.indexExists(this.dir)) {
                throw new Exception("There is no valid Lucene index in this directory.");
            }
            this.ir = IndexReader.open(this.dir, (IndexDeletionPolicy)object, bl2);
            if (n > 1) {
                this.ir.setTermInfosIndexDivisor(n);
            }
            this.is = new IndexSearcher(this.dir);
            this.initOverview();
            this.initPlugins();
            this.showStatus("Index successfully open.");
        }
        catch (Exception exception) {
            this.errorMsg(exception.getMessage());
            return;
        }
    }

    public FSDirectory openDirectory(String string, String string2, boolean bl) throws Exception {
        File file = new File(string2);
        if (!file.exists()) {
            throw new Exception("Index directory doesn't exist.");
        }
        FSDirectory fSDirectory = null;
        Field field = FSDirectory.class.getDeclaredField("IMPL");
        field.setAccessible(true);
        if (this.defaultDirImpl == null) {
            this.defaultDirImpl = (Class)field.get(null);
        }
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                field.set(null, clazz);
            }
            catch (Exception exception) {
                this.errorMsg("Invalid directory implementation class: " + string);
                return null;
            }
            fSDirectory = FSDirectory.getDirectory(string2);
            if (fSDirectory != null) {
                return fSDirectory;
            }
        } else {
            field.set(null, this.defaultDirImpl);
        }
        if (fSDirectory == null) {
            return FSDirectory.getDirectory(string2);
        }
        return null;
    }

    public void initPlugins() {
        Object object = this.find("pluginsTabs");
        this.removeAll(object);
        for (int i = 0; i < this.plugins.size(); ++i) {
            LukePlugin lukePlugin = (LukePlugin)this.plugins.get(i);
            this.addPluginTab(object, lukePlugin);
            lukePlugin.setDirectory(this.dir);
            lukePlugin.setIndexReader(this.ir);
            try {
                lukePlugin.init();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.showStatus("PLUGIN ERROR: " + exception.getMessage());
            }
        }
    }

    private void initOverview() {
        try {
            Object object;
            this.courier = new Font("Courier", this.getFont().getStyle(), this.getFont().getSize());
            this.setBoolean(this.find("bReload"), "enabled", true);
            this.setBoolean(this.find("bClose"), "enabled", true);
            this.setBoolean(this.find("bCommit"), "enabled", true);
            Object object2 = this.find("cbType");
            this.populateAnalyzers(object2);
            Object object3 = this.find("pOver");
            Object object4 = this.find("idx");
            String string = this.pName.length() > 40 ? this.pName.substring(0, 10) + "..." + this.pName.substring(this.pName.length() - 27) : this.pName;
            this.setString(object4, "text", string + (this.readOnly ? " (R)" : ""));
            object4 = this.find(object3, "iName");
            this.setString(object4, "text", this.pName + (this.readOnly ? " (Read-Only)" : ""));
            Object object5 = this.find("dirImpl");
            this.setString(object5, "text", this.dir.getClass().getName());
            Object object6 = this.find("iFileSize");
            long l = Util.calcTotalFileSize(this.pName, this.dir);
            this.setString(object6, "text", Util.normalizeSize(l) + Util.normalizeUnit(l));
            if (this.ir == null) {
                return;
            }
            Object object7 = this.find(object3, "iMod");
            this.setString(object7, "text", new Date(IndexReader.lastModified(this.dir)).toString());
            Object object8 = this.find(object3, "iDocs");
            String string2 = String.valueOf(this.ir.numDocs());
            this.setString(object8, "text", string2);
            object8 = this.find("iDocs1");
            this.setString(object8, "text", String.valueOf(this.ir.maxDoc() - 1));
            Object object9 = this.find(object3, "iFields");
            this.fn = this.ir.getFieldNames(IndexReader.FieldOption.ALL);
            if (this.fn.size() == 0) {
                this.showStatus("Empty index.");
            }
            this.showFiles(this.dir, null);
            this.showCommits();
            Object object10 = this.find(object3, "fList");
            Object object11 = this.find("defFld");
            Object object12 = this.find("fCombo");
            this.removeAll(object10);
            this.removeAll(object12);
            TreeSet treeSet = new TreeSet(this.fn);
            this.idxFields = treeSet.toArray(new String[treeSet.size()]);
            this.setString(object9, "text", String.valueOf(this.idxFields.length));
            for (int i = 0; i < this.idxFields.length; ++i) {
                object = Luke.create("item");
                this.add(object10, object);
                this.setString(object, "text", "<" + this.idxFields[i] + ">");
                this.putProperty(object, "fName", this.idxFields[i]);
                object = Luke.create("choice");
                this.add(object11, object);
                this.setString(object, "text", this.idxFields[i]);
                object = Luke.create("choice");
                this.add(object12, object);
                this.setString(object, "text", this.idxFields[i]);
                this.putProperty(object, "fName", this.idxFields[i]);
            }
            this.setString(object11, "text", this.idxFields[0]);
            Object object13 = this.find(object3, "iTerms");
            object = this.ir.terms();
            this.numTerms = 0;
            while (((TermEnum)object).next()) {
                ++this.numTerms;
            }
            ((TermEnum)object).close();
            this.setString(object13, "text", String.valueOf(this.numTerms));
            Object object14 = this.find(object3, "iDelOpt");
            String string3 = this.ir.hasDeletions() ? "Yes (" + this.ir.numDeletedDocs() + ")" : "No";
            String string4 = string3 + " / " + (this.ir.isOptimized() ? "Yes" : "No");
            this.setString(object14, "text", string4);
            Object object15 = this.find(object3, "iVer");
            this.setString(object15, "text", Long.toHexString(IndexReader.getCurrentVersion(this.dir)));
            Object object16 = this.find(object3, "iFormat");
            int n = IndexGate.getIndexFormat(this.dir);
            IndexGate.FormatDetails formatDetails = IndexGate.getFormatDetails(n);
            this.setString(object16, "text", n + " (" + formatDetails.genericName + ")");
            Object object17 = this.find(object3, "iCaps");
            this.setString(object17, "text", formatDetails.capabilities);
            Object object18 = this.find(object3, "iTiiDiv");
            this.setString(object18, "text", String.valueOf(this.ir.getTermInfosIndexDivisor()));
            Object object19 = this.find(object3, "iCommit");
            IndexCommit indexCommit = this.ir.getIndexCommit();
            this.setString(object19, "text", indexCommit.getSegmentsFileName() + " (" + new Date(indexCommit.getTimestamp()).toString() + ")");
            Object object20 = this.find(object3, "iUser");
            String string5 = "(not supported)";
            if (string5 == null) {
                string5 = "";
            }
            this.setString(object20, "text", string5);
            this.setString(this.find("defFld"), "text", this.idxFields[0]);
            Object object21 = Luke.get(this.find("sTable"), "header");
            this.removeAll(object21);
            Object object22 = Luke.create("column");
            this.setString(object22, "text", "#");
            this.setInteger(object22, "width", 40);
            this.add(object21, object22);
            object22 = Luke.create("column");
            this.setString(object22, "text", "Score");
            this.setInteger(object22, "width", 50);
            this.add(object21, object22);
            object22 = Luke.create("column");
            this.setString(object22, "text", "Doc. Id");
            this.setInteger(object22, "width", 60);
            this.add(object21, object22);
            for (int i = 0; i < this.idxFields.length; ++i) {
                object22 = Luke.create("column");
                this.setString(object22, "text", this.idxFields[i]);
                this.add(object21, object22);
            }
            this.actionTopTerms(this.find("nTerms"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    private void showCommits() throws Exception {
        Object object = this.find("commitsTable");
        this.removeAll(object);
        Collection collection = IndexReader.listCommits(this.dir);
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IndexCommit indexCommit = (IndexCommit)iterator.next();
            Collection collection2 = indexCommit.getFileNames();
            Iterator iterator2 = collection2.iterator();
            Object object2 = Luke.create("row");
            boolean bl = n < collection.size() - 1;
            Object var10_10 = null;
            ++n;
            this.add(object, object2);
            this.putProperty(object2, "commit", indexCommit);
            if (bl) {
                this.putProperty(object2, "commitDeletable", Boolean.TRUE);
            }
            Object object3 = Luke.create("cell");
            this.setString(object3, "text", String.valueOf(indexCommit.getGeneration()));
            this.add(object2, object3);
            object3 = Luke.create("cell");
            char[] cArray = new char[]{'-', '-'};
            if (indexCommit.isDeleted()) {
                cArray[0] = 68;
            }
            if (indexCommit.isOptimized()) {
                cArray[1] = 79;
            }
            this.setString(object3, "text", new String(cArray));
            this.setFont(object3, "font", this.courier);
            this.setChoice(object3, "alignment", "center");
            this.add(object2, object3);
            object3 = Luke.create("cell");
            this.setString(object3, "text", Long.toHexString(indexCommit.getVersion()));
            this.add(object2, object3);
            object3 = Luke.create("cell");
            this.setString(object3, "text", new Date(indexCommit.getTimestamp()).toString());
            this.add(object2, object3);
        }
    }

    public void showCommitFiles(Object object) throws Exception {
        ArrayList<IndexCommit> arrayList = new ArrayList<IndexCommit>();
        Object[] objectArray = this.getSelectedItems(object);
        if (objectArray == null || objectArray.length == 0) {
            this.showFiles(this.dir, arrayList);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            IndexCommit indexCommit = (IndexCommit)this.getProperty(objectArray[i], "commit");
            if (indexCommit == null) continue;
            arrayList.add(indexCommit);
        }
        this.showFiles(this.dir, arrayList);
    }

    private void showFiles(Directory directory, List list) throws Exception {
        Object object;
        String[] stringArray = directory.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                object = (IndexCommit)list.get(i);
                arrayList.addAll(((IndexCommit)object).getFileNames());
            }
        } else {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        Collections.sort(arrayList);
        List<String> list2 = this.getIndexFileNames(directory);
        object = this.getIndexDeletableNames(directory);
        Object object2 = this.find("filesTable");
        this.removeAll(object2);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            String string2 = this.pName.endsWith(File.separator) ? this.pName : this.pName + File.separator;
            File file = new File(string2 + string);
            Object object3 = Luke.create("row");
            Object object4 = Luke.create("cell");
            this.setString(object4, "text", string);
            this.add(object3, object4);
            Object object5 = Luke.create("cell");
            this.setString(object5, "text", Util.normalizeSize(file.length()));
            this.setChoice(object5, "alignment", "right");
            this.add(object3, object5);
            Object object6 = Luke.create("cell");
            this.setString(object6, "text", Util.normalizeUnit(file.length()));
            this.add(object3, object6);
            boolean bl = object.contains(string.intern());
            String string3 = this.getFileFunction(string);
            Object object7 = Luke.create("cell");
            this.setString(object7, "text", bl ? "YES" : "-");
            this.add(object3, object7);
            Object object8 = Luke.create("cell");
            this.setString(object8, "text", string3);
            this.add(object3, object8);
            this.add(object2, object3);
        }
    }

    private String getFileFunction(String string) {
        String string2 = IndexGate.getFileFunction(string);
        if (string2 == null) {
            string2 = "YES";
        }
        return string2;
    }

    private void syncMRU(Object object) {
        this.removeAll(object);
        for (String string : Prefs.getMruList()) {
            Object object2 = Luke.create("choice");
            this.setString(object2, "text", string);
            this.add(object, object2);
        }
    }

    public void actionTopTerms(Object object) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String string = this.getString(object, "text");
        int n = 50;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = this.getSelectedItems(this.find("fList"));
        String[] stringArray = null;
        if (objectArray == null || objectArray.length == 0) {
            stringArray = this.idxFields;
        } else {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)this.getProperty(objectArray[i], "fName");
            }
        }
        try {
            TermInfo[] termInfoArray = HighFreqTerms.getHighFreqTerms(this.dir, null, n + 1, stringArray);
            Object object2 = this.find("tTable");
            this.removeAll(object2);
            if (termInfoArray == null || termInfoArray.length == 0) {
                Object object3 = Luke.create("row");
                Object object4 = Luke.create("cell");
                this.add(object3, object4);
                object4 = Luke.create("cell");
                this.add(object3, object4);
                object4 = Luke.create("cell");
                this.add(object3, object4);
                object4 = Luke.create("cell");
                this.setBoolean(object4, "enabled", false);
                this.setString(object4, "text", "No Results");
                this.add(object3, object4);
                this.add(object2, object3);
                return;
            }
            for (int i = 0; i < termInfoArray.length; ++i) {
                Object object5 = Luke.create("row");
                this.add(object2, object5);
                this.putProperty(object5, "term", termInfoArray[i].term);
                this.putProperty(object5, "ti", termInfoArray[i]);
                Object object6 = Luke.create("cell");
                this.setChoice(object6, "alignment", "right");
                this.setString(object6, "text", String.valueOf(i + 1));
                this.add(object5, object6);
                object6 = Luke.create("cell");
                this.setChoice(object6, "alignment", "right");
                this.setString(object6, "text", String.valueOf(termInfoArray[i].docFreq) + "  ");
                this.add(object5, object6);
                object6 = Luke.create("cell");
                this.setString(object6, "text", " <" + termInfoArray[i].term.field() + "> ");
                this.add(object5, object6);
                object6 = Luke.create("cell");
                this.setString(object6, "text", "  " + termInfoArray[i].term.text());
                this.add(object5, object6);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    public void clipTopTerms(Object object) {
        Object[] objectArray = this.getItems(object);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            TermInfo termInfo = (TermInfo)this.getProperty(objectArray[i], "ti");
            if (termInfo == null) continue;
            stringBuffer.append(termInfo.docFreq + "\t" + termInfo.term.field() + "\t" + termInfo.term.text() + "\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void browseTermDocs(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Term term = (Term)this.getProperty(object2, "term");
        if (term == null) {
            return;
        }
        Object object3 = this.find("maintpane");
        this.setInteger(object3, "selected", 1);
        this._showTerm(this.find("fCombo"), this.find("fText"), term);
        this.repaint();
    }

    public void showTermDocs(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Term term = (Term)this.getProperty(object2, "term");
        if (term == null) {
            return;
        }
        Object object3 = this.find("maintpane");
        this.setInteger(object3, "selected", 2);
        Object object4 = this.find("qField");
        this.setString(object4, "text", term.field() + ":" + term.text());
        this.search(object4);
        this.repaint();
    }

    public void actionUndelete() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.ir.undeleteAll();
            this.initOverview();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    public void actionConvert(Object object) {
    }

    public List<String> getIndexDeletableNames(Directory directory) {
        if (directory == null) {
            return null;
        }
        List list = null;
        try {
            list = IndexGate.getDeletableFiles(directory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public List<String> getIndexFileNames(Directory directory) {
        if (directory == null) {
            return null;
        }
        List<String> list = null;
        try {
            list = IndexGate.getIndexFiles(directory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    public void actionCheckIndex() {
        if (this.dir == null) {
            this.errorMsg("No directory - open index directory first (you may use the 'no IndexReader' option).");
            return;
        }
        Object object = this.addComponent(null, "/xml/checkindex.xml", null, null);
        Object object2 = this.find(object, "dirName");
        this.setString(object2, "text", this.pName);
        this.add(object);
    }

    public void checkIndex(final Object object) {
        Thread thread = new Thread(){

            public void run() {
                Object object4 = Luke.this.find(object, "msg");
                Object object2 = Luke.this.find(object, "fixPanel");
                PanelPrintWriter panelPrintWriter = new PanelPrintWriter(Luke.this, object4);
                Object object3 = Luke.this.find(object, "ckRes");
                CheckIndex.Status status = null;
                CheckIndex checkIndex = new CheckIndex(Luke.this.dir);
                checkIndex.setInfoStream(panelPrintWriter);
                Luke.this.putProperty(object, "checkIndex", checkIndex);
                Luke.this.putProperty(object, "ppw", panelPrintWriter);
                try {
                    status = checkIndex.checkIndex();
                }
                catch (Exception exception) {
                    panelPrintWriter.println("ERROR: caught exception, giving up.\n\n");
                    exception.printStackTrace();
                    exception.printStackTrace(panelPrintWriter);
                }
                if (status != null) {
                    String string;
                    Luke.this.putProperty(object, "checkStatus", status);
                    if (status.clean) {
                        string = "OK";
                    } else if (status.toolOutOfDate) {
                        string = "ERROR: Can't check - tool out-of-date";
                    } else {
                        Luke.this.setBoolean(object2, "visible", true);
                        Luke.this.repaint(object);
                        string = "BAD: ";
                        if (status.cantOpenSegments) {
                            string = string + "cantOpenSegments ";
                        }
                        if (status.missingSegments) {
                            string = string + "missingSegments ";
                        }
                        if (status.missingSegmentVersion) {
                            string = string + "missingSegVersion ";
                        }
                        if (status.numBadSegments > 0) {
                            string = string + "numBadSegments=" + status.numBadSegments + " ";
                        }
                        if (status.totLoseDocCount > 0) {
                            string = string + "lostDocCount=" + status.totLoseDocCount + " ";
                        }
                    }
                    Luke.this.setString(object3, "text", string);
                }
            }
        };
        thread.start();
    }

    public void fixIndex(final Object object) {
        Thread thread = new Thread(){

            public void run() {
                CheckIndex checkIndex = (CheckIndex)Luke.this.getProperty(object, "checkIndex");
                if (checkIndex == null) {
                    Luke.this.errorMsg("You need to run 'Check Index' first.");
                    return;
                }
                CheckIndex.Status status = (CheckIndex.Status)Luke.this.getProperty(object, "checkStatus");
                if (status == null) {
                    Luke.this.errorMsg("You need to run 'Check Index' first.");
                    return;
                }
                Object object2 = Luke.this.find(object, "fixRes");
                PanelPrintWriter panelPrintWriter = (PanelPrintWriter)Luke.this.getProperty(object, "ppw");
                try {
                    checkIndex.fixIndex(status);
                    Luke.this.setString(object2, "text", "DONE. Review the output above.");
                }
                catch (Exception exception) {
                    panelPrintWriter.println("\nERROR during Fix Index:");
                    exception.printStackTrace(panelPrintWriter);
                    Luke.this.setString(object2, "text", "FAILED. Review the output above.");
                }
            }
        };
        thread.start();
    }

    public boolean isFSBased(Directory directory) {
        return directory instanceof MMapDirectory || directory instanceof NIOFSDirectory || directory instanceof FSDirectory;
    }

    public void actionCleanup() {
        if (this.dir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            ArrayList<String> arrayList;
            Object object;
            boolean bl = false;
            if (this.isFSBased(this.dir)) {
                object = new File(this.pName);
                bl = true;
                arrayList = new ArrayList<String>(Arrays.asList(((File)object).list()));
            } else {
                arrayList = new ArrayList<String>(Arrays.asList(this.dir.list()));
            }
            object = this.getIndexFileNames(this.dir);
            arrayList.removeAll((Collection<?>)object);
            if (arrayList.size() == 0) {
                this.infoMsg("There are no files to be cleaned - target directory contains only index-related files.");
                return;
            }
            Object object2 = this.addComponent(null, "/xml/cleanup.xml", null, null);
            Object object3 = this.find(object2, "filesTable");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                Object object4 = Luke.create("row");
                this.add(object3, object4);
                this.putProperty(object4, "fileName", string);
                long l = this.dir.fileLength(string);
                Object object5 = Luke.create("cell");
                this.setString(object5, "text", Util.normalizeSize(l));
                this.add(object4, object5);
                object5 = Luke.create("cell");
                this.setString(object5, "text", Util.normalizeUnit(l));
                this.add(object4, object5);
                object5 = Luke.create("cell");
                this.setString(object5, "text", string);
                this.add(object4, object5);
            }
            this.add(object2);
        }
        catch (Exception exception) {
            this.errorMsg("Error: " + exception.toString());
        }
    }

    public void toggleKeep(Object object) {
        Object[] objectArray = this.getSelectedItems(object);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Boolean bl = (Boolean)this.getProperty(objectArray[i], "deletable");
            boolean bl2 = bl != null ? bl : true;
            bl2 = !bl2;
            this.putProperty(objectArray[i], "deletable", bl2);
            Object[] objectArray2 = this.getItems(objectArray[i]);
            for (int j = 0; j < objectArray2.length; ++j) {
                if (!bl2) {
                    this.setBoolean(objectArray2[j], "enabled", false);
                    continue;
                }
                this.setBoolean(objectArray2[j], "enabled", true);
            }
        }
        this.repaint(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void _actionCleanup(Object object) {
        int n;
        String string;
        block18: {
            block17: {
                try {
                    this.ir.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                string = null;
                boolean bl = this.isFSBased(this.dir);
                n = 0;
                Object[] objectArray = this.getItems(object);
                for (int i = 0; i < objectArray.length; ++i) {
                    boolean bl2;
                    String string2 = (String)this.getProperty(objectArray[i], "fileName");
                    Boolean bl3 = (Boolean)this.getProperty(objectArray[i], "deletable");
                    boolean bl4 = bl2 = bl3 != null ? bl3 : true;
                    if (!bl2) continue;
                    if (bl) {
                        File file = new File(this.pName, string2);
                        if (!this.removeFile(file)) {
                            arrayList.add(string2);
                        }
                        ++n;
                        continue;
                    }
                    this.dir.deleteFile(string2);
                    ++n;
                }
                if (arrayList.size() <= 0) break block17;
                StringBuffer stringBuffer = new StringBuffer("Some files could not be deleted:");
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuffer.append("\n" + arrayList.get(i));
                }
                string = stringBuffer.toString();
            }
            Object var13_16 = null;
            try {
                this.actionReopen();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = "FAILED: " + exception.getMessage();
            }
            break block18;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    string = "FAILED: " + exception.getMessage();
                    Object var13_17 = null;
                    try {
                        this.actionReopen();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                        string = "FAILED: " + exception2.getMessage();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                try {
                    this.actionReopen();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string = "FAILED: " + exception.getMessage();
                }
                throw throwable;
            }
        }
        if (string != null) {
            this.errorMsg(string);
        } else if (n == 0) {
            this.infoMsg("No files were deleted.");
        }
    }

    public boolean removeFile(File file) {
        System.out.println("remove " + file);
        if (!file.isDirectory()) {
            return file.delete();
        }
        File[] fileArray = file.listFiles();
        boolean bl = true;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                bl = bl && this.removeFile(fileArray[i]);
            }
        }
        bl = bl && file.delete();
        return bl;
    }

    public void actionExport() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Object object = this.addComponent(this, "/xml/export.xml", null, null);
    }

    public void export(Object object) {
        Object object2;
        File file;
        Object object3 = this.find(object, "ckOver");
        Object object4 = this.find(object, "ckGzip");
        Object object5 = this.find(object, "path");
        Object object6 = this.find(object, "ckRanges");
        Object object7 = this.find(object, "ranges");
        String string = this.getString(object5, "text");
        if ((string = string.trim()).length() == 0) {
            this.errorMsg("No output file set.");
            return;
        }
        boolean bl = this.getBoolean(object3, "selected");
        boolean bl2 = this.getBoolean(object4, "selected");
        if (bl2 && !string.endsWith(".gz")) {
            string = string + ".gz";
            this.setString(object5, "text", string);
        }
        if ((file = new File(string)).exists()) {
            if (file.isDirectory()) {
                this.errorMsg("Output already exists and is a directory.");
                return;
            }
            if (!bl) {
                this.errorMsg("Output already exists.");
                return;
            }
        }
        Ranges ranges = null;
        if (this.getBoolean(object6, "selected") && ((String)(object2 = this.getString(object7, "text"))).trim().length() > 0) {
            try {
                ranges = Ranges.parse((String)object2);
            }
            catch (Exception exception) {
                this.errorMsg(exception.toString());
                return;
            }
        }
        object2 = this.find(object, "bar");
        final Object object8 = this.find(object, "counter");
        final Object object9 = this.find(object, "msg");
        Observer observer = new Observer(){

            public void update(Observable observable, Object object) {
                ProgressNotification progressNotification = (ProgressNotification)object;
                Luke.this.setInteger(object2, "minimum", progressNotification.minValue);
                Luke.this.setInteger(object2, "maximum", progressNotification.maxValue);
                Luke.this.setInteger(object2, "value", progressNotification.curValue);
                Luke.this.setString(object9, "text", progressNotification.message);
                if (!progressNotification.aborted) {
                    Luke.this.setString(object8, "text", progressNotification.curValue + " of " + progressNotification.maxValue + " done.");
                } else {
                    Luke.this.setString(object8, "text", "ABORTED at " + progressNotification.curValue + " of " + progressNotification.maxValue);
                }
            }
        };
        this.setBoolean(this.find(object, "startButton"), "visible", false);
        this.setBoolean(this.find(object, "abortButton"), "visible", true);
        this.setBoolean(this.find(object, "closeButton"), "enabled", false);
        this._runExport(file, bl2, observer, object, ranges);
    }

    public void _runExport(final File file, final boolean bl, Observer observer, final Object object, final Ranges ranges) {
        this.exporter = new XMLExporter(this.ir, this.pName);
        this.exporter.addObserver(observer);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block12: {
                    OutputStream outputStream = null;
                    try {
                        outputStream = new FileOutputStream(file);
                        if (bl) {
                            outputStream = new GZIPOutputStream(outputStream);
                        }
                        Luke.this.exporter.export(outputStream, true, true, "index", ranges);
                        Luke.this.exporter = null;
                        Object var4_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        Luke.this.setBoolean(Luke.this.find(object, "startButton"), "visible", true);
                        Luke.this.setBoolean(Luke.this.find(object, "abortButton"), "visible", false);
                        Luke.this.setBoolean(Luke.this.find(object, "closeButton"), "enabled", true);
                        if (outputStream != null) {
                            try {
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (Exception exception) {
                                Luke.this.errorMsg("ERROR closing output, file may be incomplete: " + exception.toString());
                            }
                        }
                        throw throwable;
                    }
                    Luke.this.setBoolean(Luke.this.find(object, "startButton"), "visible", true);
                    Luke.this.setBoolean(Luke.this.find(object, "abortButton"), "visible", false);
                    Luke.this.setBoolean(Luke.this.find(object, "closeButton"), "enabled", true);
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            Luke.this.errorMsg("ERROR closing output, file may be incomplete: " + exception.toString());
                        }
                    }
                    break block12;
                    {
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Luke.this.errorMsg("ERROR occurred, file may be incomplete: " + exception.toString());
                            Object var4_3 = null;
                            Luke.this.setBoolean(Luke.this.find(object, "startButton"), "visible", true);
                            Luke.this.setBoolean(Luke.this.find(object, "abortButton"), "visible", false);
                            Luke.this.setBoolean(Luke.this.find(object, "closeButton"), "enabled", true);
                            if (outputStream != null) {
                                try {
                                    outputStream.flush();
                                    outputStream.close();
                                }
                                catch (Exception exception2) {
                                    Luke.this.errorMsg("ERROR closing output, file may be incomplete: " + exception2.toString());
                                }
                            }
                        }
                    }
                }
            }
        };
        thread.start();
    }

    public void abortExport(Object object) {
        if (this.exporter != null && this.exporter.isRunning()) {
            this.exporter.abort();
        }
    }

    public void actionOptimize() {
        if (this.dir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        Object object = this.addComponent(null, "/xml/optimize.xml", null, null);
        this.setString(this.find(object, "dirName"), "text", this.pName);
        this.add(object);
    }

    public void optimize(final Object object) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                PanelPrintWriter panelPrintWriter;
                block15: {
                    IndexWriter indexWriter = null;
                    Object object7 = Luke.this.find(object, "optimizeButton");
                    Luke.this.setBoolean(object7, "enabled", false);
                    Object object2 = Luke.this.find(object, "closeButton");
                    Luke.this.setBoolean(object2, "enabled", false);
                    Object object3 = Luke.this.find(object, "msg");
                    Object object4 = Luke.this.find(object, "stat");
                    Luke.this.setString(object4, "text", "Running ...");
                    panelPrintWriter = new PanelPrintWriter(Luke.this, object3);
                    boolean bl = Luke.this.getBoolean(Luke.this.find(object, "optCompound"), "selected");
                    boolean bl2 = Luke.this.getBoolean(Luke.this.find(object, "optExpunge"), "selected");
                    Object object5 = Luke.this.find(object, "tii");
                    Object object6 = Luke.this.find(object, "segnum");
                    int n = Integer.parseInt(Luke.this.getString(object5, "text"));
                    int n2 = Integer.parseInt(Luke.this.getString(object6, "text"));
                    try {
                        try {
                            if (Luke.this.is != null) {
                                Luke.this.is.close();
                            }
                            if (Luke.this.ir != null) {
                                Luke.this.ir.close();
                            }
                            IndexDeletionPolicy indexDeletionPolicy = Luke.this.keepCommits ? new KeepAllIndexDeletionPolicy() : new KeepLastIndexDeletionPolicy();
                            indexWriter = new IndexWriter(Luke.this.dir, new WhitespaceAnalyzer(), false, indexDeletionPolicy, IndexWriter.MaxFieldLength.UNLIMITED);
                            indexWriter.setUseCompoundFile(bl);
                            indexWriter.setTermIndexInterval(n);
                            indexWriter.setInfoStream(panelPrintWriter);
                            long l = Util.calcTotalFileSize(Luke.this.pName, Luke.this.dir);
                            long l2 = System.currentTimeMillis();
                            if (bl2) {
                                indexWriter.expungeDeletes();
                            } else if (n2 > 1) {
                                indexWriter.optimize(n2);
                            } else {
                                indexWriter.optimize();
                            }
                            long l3 = System.currentTimeMillis();
                            long l4 = Util.calcTotalFileSize(Luke.this.pName, Luke.this.dir);
                            long l5 = l - l4;
                            String string = l5 > 0L ? " Increased " : " Reduced ";
                            String string2 = string + Util.normalizeSize(Math.abs(l5)) + Util.normalizeUnit(Math.abs(l5));
                            String string3 = String.valueOf(l3 - l2) + " ms";
                            Luke.this.showStatus(string2 + " in " + string3);
                            indexWriter.close();
                            Luke.this.setString(object4, "text", "Finished OK.");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(panelPrintWriter);
                            Luke.this.setString(object4, "text", "ERROR - aborted.");
                            Luke.this.errorMsg("ERROR optimizing: " + exception.toString());
                            if (indexWriter != null) {
                                try {
                                    indexWriter.close();
                                }
                                catch (Exception exception2) {
                                }
                            }
                            Object var28_26 = null;
                            Luke.this.setBoolean(object2, "enabled", true);
                            break block15;
                        }
                        Object var28_25 = null;
                    }
                    catch (Throwable throwable) {
                        Object var28_27 = null;
                        Luke.this.setBoolean(object2, "enabled", true);
                        throw throwable;
                    }
                    Luke.this.setBoolean(object2, "enabled", true);
                }
                try {
                    Luke.this.actionReopen();
                    Luke.this.is = new IndexSearcher(Luke.this.ir);
                    Luke.this.add(object);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace(panelPrintWriter);
                    Luke.this.errorMsg("ERROR reopening after optimize:\n" + exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void showPrevDoc(Object object) {
        this._showDoc(object, -1);
    }

    public void showNextDoc(Object object) {
        this._showDoc(object, 1);
    }

    public void showDoc(Object object) {
        this._showDoc(object, 0);
    }

    private void _showDoc(Object object, int n) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String string = this.getString(object, "text");
        if (string.trim().equals("")) {
            string = String.valueOf(-n);
        }
        try {
            int n2 = Integer.parseInt(string);
            if ((n2 += n) < 0 || n2 >= this.ir.maxDoc()) {
                this.showStatus("Document number outside valid range.");
                return;
            }
            this.setString(object, "text", String.valueOf(n2));
            Document document = null;
            if (!this.ir.isDeleted(n2)) {
                document = this.ir.document(n2);
                this._showDocFields(n2, document);
            } else {
                this.showStatus("Deleted document - not available.");
                this._showDocFields(n2, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void actionAddDocument(Object object) {
        if (this.ir == null) {
            this.errorMsg(MSG_NOINDEX);
            return;
        }
        Object object2 = this.addComponent(null, "/xml/editdoc.xml", null, null);
        this.remove(this.find(object2, "bDelAdd"));
        Object object3 = this.find(object2, "cbAnalyzers");
        this.populateAnalyzers(object3);
        this.setInteger(object3, "selected", 0);
        this.add(object2);
    }

    public void actionReconstruct(Object object) {
        Object object2;
        final int[] nArray = new int[1];
        try {
            object2 = this.getString(object, "text");
            nArray[0] = Integer.parseInt((String)object2);
        }
        catch (Exception exception) {
            this.showStatus("ERROR: no valid document selected");
            return;
        }
        object2 = new Progress(this);
        ((Progress)object2).setMessage("Reconstructing ...");
        ((Progress)object2).show();
        Thread thread = new Thread((Progress)object2){
            final /* synthetic */ Progress val$progress;
            {
                this.val$progress = progress;
            }

            public void run() {
                try {
                    int n = nArray[0];
                    DocReconstructor docReconstructor = new DocReconstructor(Luke.this.ir, Luke.this.idxFields, Luke.this.numTerms);
                    docReconstructor.addObserver(this.val$progress);
                    DocReconstructor.Reconstructed reconstructed = docReconstructor.reconstruct(n);
                    Object object = Luke.this.addComponent(null, "/xml/editdoc.xml", null, null);
                    Luke.this.putProperty(object, "docNum", new Integer(n));
                    Object object2 = Luke.this.find(object, "cbAnalyzers");
                    Luke.this.populateAnalyzers(object2);
                    Luke.this.setInteger(object2, "selected", 0);
                    Object object3 = Luke.this.find(object, "editTabs");
                    Luke.this.setString(Luke.this.find(object, "docNum"), "text", "Fields of Doc #: " + n);
                    for (int i = 0; i < Luke.this.idxFields.length; ++i) {
                        String string = Luke.this.idxFields[i];
                        if (!reconstructed.hasField(string)) continue;
                        org.apache.lucene.document.Field[] fieldArray = reconstructed.getStoredFields().get(string);
                        GrowableStringArray growableStringArray = reconstructed.getReconstructedFields().get(string);
                        int n2 = 0;
                        if (growableStringArray != null) {
                            n2 = 1;
                        }
                        if (fieldArray != null && fieldArray.length > n2) {
                            n2 = fieldArray.length;
                        }
                        for (int j = 0; j < n2; ++j) {
                            String string2;
                            if (j > 0) {
                                growableStringArray = null;
                            }
                            Object object4 = Thinlet.create("tab");
                            Luke.this.setString(object4, "text", string);
                            Luke.this.setFont(object4, Luke.this.getFont().deriveFont(1));
                            Luke.this.add(object3, object4);
                            Object object5 = Luke.this.addComponent(object4, "/xml/editfield.xml", null, null);
                            Object object6 = Luke.this.find(object5, "fType");
                            Object object7 = Luke.this.find(object5, "sText");
                            Object object8 = Luke.this.find(object5, "rText");
                            Object object9 = Luke.this.find(object5, "fBoost");
                            Object object10 = Luke.this.find(object5, "cbStored");
                            Object object11 = Luke.this.find(object5, "cbCmp");
                            Object object12 = Luke.this.find(object5, "cbBin");
                            Object object13 = Luke.this.find(object5, "cbIndexed");
                            Object object14 = Luke.this.find(object5, "cbTokenized");
                            Object object15 = Luke.this.find(object5, "cbTVF");
                            Object object16 = Luke.this.find(object5, "cbTVFp");
                            Object object17 = Luke.this.find(object5, "cbTVFo");
                            Object object18 = Luke.this.find(object5, "cbONorms");
                            Object object19 = Luke.this.find(object5, "cbOTF");
                            Object object20 = Luke.this.find(object5, "stored");
                            Object object21 = Luke.this.find(object5, "restored");
                            Luke.this.setBoolean(object18, "selected", !Luke.this.ir.hasNorms(string));
                            org.apache.lucene.document.Field field = null;
                            if (fieldArray != null && fieldArray.length > j) {
                                field = fieldArray[j];
                                Luke.this.setString(object6, "text", "Original stored field content");
                                if (field.isBinary()) {
                                    string2 = Util.bytesToHex(field.getBinaryValue(), field.getBinaryOffset(), field.getBinaryLength(), true);
                                    Luke.this.setBoolean(object12, "selected", true);
                                } else {
                                    string2 = field.stringValue();
                                }
                                Luke.this.setString(object7, "text", string2);
                                Luke.this.setString(object9, "text", String.valueOf(field.getBoost()));
                                Luke.this.setBoolean(object10, "selected", field.isStored());
                                Luke.this.setBoolean(object11, "selected", field.isCompressed());
                                Luke.this.setBoolean(object13, "selected", field.isIndexed());
                                Luke.this.setBoolean(object14, "selected", field.isTokenized());
                                Luke.this.setBoolean(object15, "selected", field.isTermVectorStored());
                                Luke.this.setBoolean(object16, "selected", field.isStorePositionWithTermVector());
                                Luke.this.setBoolean(object17, "selected", field.isStoreOffsetWithTermVector());
                                Luke.this.setBoolean(object19, "selected", field.getOmitTf());
                            } else {
                                Luke.this.remove(object20);
                            }
                            if (growableStringArray != null) {
                                string2 = " ";
                                if (field == null) {
                                    Luke.this.setString(object6, "text", "RESTORED content ONLY - check for errors!");
                                    Luke.this.setColor(object6, "foreground", Color.red);
                                } else {
                                    Luke.this.setBoolean(object8, "editable", false);
                                    Luke.this.setBoolean(object8, "border", false);
                                    Luke.this.setString(object21, "text", "Tokenized (from all '" + string + "' fields)");
                                    string2 = ", ";
                                }
                                Luke.this.setBoolean(object13, "selected", true);
                                Luke.this.setString(object9, "text", String.valueOf(1.0f));
                                Luke.this.setString(object8, "text", growableStringArray.toString(string2));
                                continue;
                            }
                            Luke.this.remove(object21);
                        }
                    }
                    Luke.this.add(object);
                    Luke.this.getPreferredSize(object3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Luke.this.showStatus(exception.getMessage());
                }
                this.val$progress.hide();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean actionEditAdd(Object object) {
        boolean bl;
        Object object2;
        block30: {
            Object object3;
            Document document = new Document();
            Object object4 = this.find(object, "cbAnalyzers");
            Analyzer analyzer = new StandardAnalyzer();
            String string = null;
            try {
                string = this.getString(object4, "text");
                analyzer = (Analyzer)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorMsg("Could not instantiate Analyzer '" + string + "'. Please select a valid Analyzer.");
                return false;
            }
            Object object5 = this.find(object, "editTabs");
            Object[] objectArray = this.getItems(object5);
            for (int i = 0; i < objectArray.length; ++i) {
                org.apache.lucene.document.Field field;
                Field.Index index;
                Field.Store store;
                String string2 = this.getString(objectArray[i], "text");
                if (string2.trim().equals("")) continue;
                object2 = this.find(objectArray[i], "fBoost");
                object3 = this.find(objectArray[i], "sText");
                if (object3 == null) {
                    object3 = this.find(objectArray[i], "rText");
                }
                Object object6 = this.find(objectArray[i], "cbStored");
                Object object7 = this.find(objectArray[i], "cbIndexed");
                Object object8 = this.find(objectArray[i], "cbTokenized");
                Object object9 = this.find(objectArray[i], "cbTVF");
                Object object10 = this.find(objectArray[i], "cbTVFo");
                Object object11 = this.find(objectArray[i], "cbTVFp");
                Object object12 = this.find(objectArray[i], "cbCmp");
                Object object13 = this.find(objectArray[i], "cbBin");
                Object object14 = this.find(objectArray[i], "cbONorms");
                Object object15 = this.find(objectArray[i], "cbOTF");
                String string3 = this.getString(object3, "text");
                boolean bl2 = this.getBoolean(object13, "selected");
                Field.TermVector termVector = this.getBoolean(object9, "selected") ? (this.getBoolean(object10, "selected") ? (this.getBoolean(object11, "selected") ? Field.TermVector.WITH_POSITIONS_OFFSETS : Field.TermVector.WITH_OFFSETS) : (this.getBoolean(object11, "selected") ? Field.TermVector.WITH_POSITIONS : Field.TermVector.YES)) : Field.TermVector.NO;
                Field.Store store2 = this.getBoolean(object6, "selected") ? (this.getBoolean(object12, "selected") ? Field.Store.COMPRESS : Field.Store.YES) : (store = Field.Store.NO);
                Field.Index index2 = this.getBoolean(object7, "selected") ? (this.getBoolean(object8, "selected") ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED) : (index = Field.Index.NO);
                if (store.equals(Field.Store.NO) && index.equals(Field.Index.NO)) {
                    this.errorMsg("Field '" + string2 + "' is neither stored nor indexed.");
                    return false;
                }
                if (bl2) {
                    byte[] byArray;
                    try {
                        byArray = Util.hexToBytes(string3);
                    }
                    catch (Throwable throwable) {
                        this.errorMsg("Field '" + string2 + "': " + throwable.getMessage());
                        return false;
                    }
                    field = new org.apache.lucene.document.Field(string2, byArray, store);
                } else {
                    field = new org.apache.lucene.document.Field(string2, string3, store, index, termVector);
                }
                field.setOmitNorms(this.getBoolean(object14, "selected"));
                field.setOmitTf(this.getBoolean(object15, "selected"));
                String string4 = this.getString(object2, "text").trim();
                if (!string4.equals("") && !string4.equals("1.0")) {
                    float f = 1.0f;
                    try {
                        f = Float.parseFloat(string4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    field.setBoost(f);
                }
                document.add(field);
            }
            IndexWriter indexWriter = null;
            bl = false;
            object2 = null;
            this.ir.close();
            object3 = this.keepCommits ? new KeepAllIndexDeletionPolicy() : new KeepLastIndexDeletionPolicy();
            indexWriter = new IndexWriter(this.dir, analyzer, false, (IndexDeletionPolicy)object3, IndexWriter.MaxFieldLength.UNLIMITED);
            indexWriter.setUseCompoundFile(IndexGate.preferCompoundFormat(this.dir));
            indexWriter.addDocument(document);
            bl = true;
            Object var33_37 = null;
            try {
                if (indexWriter != null) {
                    indexWriter.close();
                }
            }
            catch (Exception object16) {
                ((Throwable)object16).printStackTrace();
                bl = false;
                object2 = "FAILED: " + ((Throwable)object16).getMessage();
            }
            this.remove(object);
            try {
                this.actionReopen();
                object16 = this.find("maintpane");
                this.setInteger(object16, "selected", 1);
            }
            catch (Exception object16) {
                ((Throwable)object16).printStackTrace();
                bl = false;
                object2 = "FAILED: " + ((Throwable)object16).getMessage();
            }
            break block30;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    object2 = "FAILED: " + exception.getMessage();
                    bl = false;
                    Object var33_38 = null;
                    try {
                        if (indexWriter != null) {
                            indexWriter.close();
                        }
                    }
                    catch (Exception object17) {
                        ((Throwable)object17).printStackTrace();
                        bl = false;
                        object2 = "FAILED: " + ((Throwable)object17).getMessage();
                    }
                    this.remove(object);
                    try {
                        this.actionReopen();
                        object17 = this.find("maintpane");
                        this.setInteger(object17, "selected", 1);
                    }
                    catch (Exception object17) {
                        ((Throwable)object17).printStackTrace();
                        bl = false;
                        object2 = "FAILED: " + ((Throwable)object17).getMessage();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var33_39 = null;
                try {
                    if (indexWriter != null) {
                        indexWriter.close();
                    }
                }
                catch (Exception object18) {
                    ((Throwable)object18).printStackTrace();
                    bl = false;
                    object2 = "FAILED: " + ((Throwable)object18).getMessage();
                }
                this.remove(object);
                try {
                    this.actionReopen();
                    object18 = this.find("maintpane");
                    this.setInteger(object18, "selected", 1);
                }
                catch (Exception object18) {
                    ((Throwable)object18).printStackTrace();
                    bl = false;
                    object2 = "FAILED: " + ((Throwable)object18).getMessage();
                }
                throw throwable;
            }
        }
        if (!bl) {
            this.errorMsg((String)object2);
        }
        return bl;
    }

    public void actionEditReplace(Object object) {
        if (!this.actionEditAdd(object)) {
            return;
        }
        Integer n = (Integer)this.getProperty(object, "docNum");
        if (n == null) {
            return;
        }
        try {
            this.ir.deleteDocument(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg("ERROR deleting: " + exception.getMessage());
            return;
        }
    }

    public void actionEditAddField(Object object) {
        String string = this.getString(this.find(object, "fNewName"), "text");
        if (string.trim().equals("")) {
            this.showStatus("FAILED: Field name is required.");
            return;
        }
        string = string.trim();
        Object object2 = this.find(object, "editTabs");
        Object object3 = Luke.create("tab");
        this.setString(object3, "text", string);
        this.setFont(object3, this.getFont().deriveFont(1));
        this.add(object2, object3);
        this.addComponent(object3, "/xml/editfield.xml", null, null);
        this.repaint(object2);
    }

    public void actionEditDeleteField(Object object) {
        Object object2 = this.getParent(object);
        this.remove(object2);
    }

    private void _showDocFields(int n, Document document) {
        Object object = this.find("docTable");
        this.setString(this.find("docNum"), "text", String.valueOf(n));
        this.removeAll(object);
        this.putProperty(object, "doc", document);
        this.putProperty(object, "docNum", new Integer(n));
        if (document == null) {
            this.setString(this.find("docNum1"), "text", String.valueOf(n) + "  DELETED");
            return;
        }
        this.setString(this.find("docNum1"), "text", String.valueOf(n));
        for (int i = 0; i < this.idxFields.length; ++i) {
            org.apache.lucene.document.Field[] fieldArray = document.getFields(this.idxFields[i]);
            if (fieldArray == null) {
                this.addFieldRow(object, this.idxFields[i], null, n);
                continue;
            }
            for (int j = 0; j < fieldArray.length; ++j) {
                if (fieldArray[j].isBinary()) {
                    System.out.println("f.len=" + fieldArray[j].getBinaryLength() + ", doc.len=" + document.getBinaryValue(this.idxFields[i]).length);
                }
                this.addFieldRow(object, this.idxFields[i], fieldArray[j], n);
            }
        }
        this.doLayout(object);
    }

    private void addFieldRow(Object object, String string, org.apache.lucene.document.Field field, int n) {
        Object object2;
        Object object3;
        block9: {
            object3 = Luke.create("row");
            this.add(object, object3);
            this.putProperty(object3, "field", field);
            this.putProperty(object3, "fName", string);
            object2 = Luke.create("cell");
            this.setString(object2, "text", "<" + string + ">");
            this.add(object3, object2);
            object2 = Luke.create("cell");
            this.setString(object2, "text", Util.fieldFlags(field));
            if (field == null) {
                this.setBoolean(object2, "enabled", false);
            }
            this.setFont(object2, "font", this.courier);
            this.setChoice(object2, "alignment", "center");
            this.add(object3, object2);
            object2 = Luke.create("cell");
            if (field != null) {
                try {
                    if (this.ir.hasNorms(string)) {
                        this.setString(object2, "text", String.valueOf(Similarity.decodeNorm(this.ir.norms(string)[n])));
                        break block9;
                    }
                    this.setString(object2, "text", "---");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.setString(object2, "text", "!?!");
                }
            } else {
                this.setString(object2, "text", "---");
                this.setBoolean(object2, "enabled", false);
            }
        }
        this.add(object3, object2);
        object2 = Luke.create("cell");
        if (field != null) {
            String string2 = field.stringValue();
            if (string2 == null && field.isBinary()) {
                string2 = Util.bytesToHex(field.getBinaryValue(), field.getBinaryOffset(), field.getBinaryLength(), false);
            }
            this.setString(object2, "text", Util.escape(string2));
        } else {
            this.setString(object2, "text", "<not present or not stored>");
            this.setBoolean(object2, "enabled", false);
        }
        this.add(object3, object2);
    }

    public void showTV(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Integer n = (Integer)this.getProperty(object, "docNum");
        if (n == null) {
            this.showStatus("Missing Doc. Id.");
            return;
        }
        try {
            Object object3;
            int n2;
            String string = (String)this.getProperty(object2, "fName");
            TermFreqVector termFreqVector = this.ir.getTermFreqVector((int)n, string);
            if (termFreqVector == null) {
                this.showStatus("Term Vector not available.");
                return;
            }
            Object object4 = this.addComponent(null, "/xml/vector.xml", null, null);
            this.setString(this.find(object4, "fld"), "text", string);
            Object object5 = this.find(object4, "vTable");
            IntPair[] intPairArray = new IntPair[termFreqVector.size()];
            String[] stringArray = termFreqVector.getTerms();
            int[] nArray = termFreqVector.getTermFrequencies();
            TermPositionVector termPositionVector = null;
            if (termFreqVector instanceof TermPositionVector) {
                termPositionVector = (TermPositionVector)termFreqVector;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object3 = new IntPair(nArray[n2], stringArray[n2]);
                if (termPositionVector != null) {
                    ((IntPair)object3).offsets = termPositionVector.getOffsets(n2);
                    ((IntPair)object3).positions = termPositionVector.getTermPositions(n2);
                }
                intPairArray[n2] = object3;
            }
            Arrays.sort(intPairArray, new IntPair.PairComparator(false, true));
            for (n2 = 0; n2 < intPairArray.length; ++n2) {
                int n3;
                StringBuilder stringBuilder;
                object3 = Luke.create("row");
                this.add(object5, object3);
                this.putProperty(object3, "tf", intPairArray[n2]);
                Object object6 = Luke.create("cell");
                this.setString(object6, "text", Util.escape(intPairArray[n2].text));
                this.add(object3, object6);
                object6 = Luke.create("cell");
                this.setString(object6, "text", String.valueOf(intPairArray[n2].cnt));
                this.add(object3, object6);
                object6 = Luke.create("cell");
                if (intPairArray[n2].positions != null) {
                    stringBuilder = new StringBuilder();
                    for (n3 = 0; n3 < intPairArray[n2].positions.length; ++n3) {
                        if (n3 > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(String.valueOf(intPairArray[n2].positions[n3]));
                    }
                    this.setString(object6, "text", stringBuilder.toString());
                }
                this.add(object3, object6);
                object6 = Luke.create("cell");
                if (intPairArray[n2].offsets != null) {
                    stringBuilder = new StringBuilder();
                    for (n3 = 0; n3 < intPairArray[n2].offsets.length; ++n3) {
                        if (n3 > 0) {
                            stringBuilder.append(',');
                        }
                        TermVectorOffsetInfo termVectorOffsetInfo = intPairArray[n2].offsets[n3];
                        stringBuilder.append(termVectorOffsetInfo.getStartOffset() + "-" + termVectorOffsetInfo.getEndOffset());
                    }
                    this.setString(object6, "text", stringBuilder.toString());
                }
                this.add(object3, object6);
            }
            this.add(object4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void clipTV(Object object) {
        Object[] objectArray = this.getItems(object);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            IntPair intPair = (IntPair)this.getProperty(objectArray[i], "tf");
            stringBuilder.append(intPair.cnt + "\t" + intPair.text);
            if (intPair.positions != null) {
                stringBuilder.append("\t");
                for (n = 0; n < intPair.positions.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(String.valueOf(intPair.positions[n]));
                }
            }
            if (intPair.offsets != null) {
                if (intPair.positions == null) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append("\t");
                for (n = 0; n < intPair.offsets.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    TermVectorOffsetInfo termVectorOffsetInfo = intPair.offsets[n];
                    stringBuilder.append(termVectorOffsetInfo.getStartOffset() + "-" + termVectorOffsetInfo.getEndOffset());
                }
            }
            stringBuilder.append("\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void actionSetNorm(Object object) throws Exception {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(object2, "field");
        if (field == null) {
            this.showStatus("No data available for this field");
            return;
        }
        if (!field.isIndexed()) {
            this.showStatus("Cannot set norm value - this field is not indexed.");
            return;
        }
        Object object3 = this.addComponent(null, "/xml/fnorm.xml", null, null);
        Integer n = (Integer)this.getProperty(object, "docNum");
        this.putProperty(object3, "docNum", this.getProperty(object, "docNum"));
        this.putProperty(object3, "field", field);
        Object object4 = this.find(object3, "curNorm");
        Object object5 = this.find(object3, "newNorm");
        Object object6 = this.find(object3, "encNorm");
        Object object7 = this.find(object3, "docNum");
        Object object8 = this.find(object3, "fld");
        this.setString(object7, "text", String.valueOf(n));
        this.setString(object8, "text", field.name());
        try {
            byte by = this.ir.norms(field.name())[n];
            float f = Similarity.decodeNorm(by);
            this.setString(object4, "text", String.valueOf(f));
            this.setString(object5, "text", String.valueOf(f));
            this.setString(object6, "text", String.valueOf(f) + " (0x" + Util.byteToHex(by) + ")");
        }
        catch (Exception exception) {
            this.errorMsg("Error reading norm: " + exception.toString());
            return;
        }
        this.add(object3);
        this.displayNewNorm(object3);
    }

    public void displayNewNorm(Object object) {
        Object object2 = this.find(object, "newNorm");
        Object object3 = this.find(object, "encNorm");
        try {
            float f = Float.parseFloat(this.getString(object2, "text"));
            byte by = Similarity.encodeNorm(f);
            float f2 = Similarity.decodeNorm(by);
            this.setString(object3, "text", String.valueOf(f2) + " (0x" + Util.byteToHex(by) + ")");
            this.putProperty(object, "newNorm", new Float(f));
            this.doLayout(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNorm(Object object) {
        Serializable serializable;
        boolean bl = this.getBoolean(this.find(object, "fDoc"), "selected");
        boolean bl2 = this.getBoolean(this.find(object, "fAll"), "selected");
        boolean bl3 = this.getBoolean(this.find(object, "fList"), "selected");
        Float f = (Float)this.getProperty(object, "newNorm");
        Integer n = (Integer)this.getProperty(object, "docNum");
        org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(object, "field");
        try {
            if (bl) {
                this.ir.setNorm((int)n, field.name(), f.floatValue());
            } else if (bl2) {
                for (int i = 0; i < this.ir.maxDoc(); ++i) {
                    if (this.ir.isDeleted(i)) continue;
                    this.ir.setNorm(i, field.name(), f.floatValue());
                }
            } else if (bl3) {
                String string = this.getString(this.find(object, "frange"), "text");
                serializable = Ranges.parse(string);
                if (((OpenBitSet)serializable).cardinality() == 0L) {
                    this.infoMsg("Empty list - no documents selected, no modifications.");
                } else {
                    DocIdSetIterator docIdSetIterator = ((OpenBitSet)serializable).iterator();
                    while (docIdSetIterator.next()) {
                        if (this.ir.isDeleted(docIdSetIterator.doc())) continue;
                        this.ir.setNorm(docIdSetIterator.doc(), field.name(), f.floatValue());
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg("Set norms failed: " + exception.toString());
        }
        this.remove(object);
        Object object2 = this.find("docTable");
        serializable = (Document)this.getProperty(object2, "doc");
        this._showDocFields(n, (Document)serializable);
    }

    public void showTField(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(object2, "field");
        if (field == null) {
            this.showStatus("No data available for this field");
            return;
        }
        Object object3 = this.addComponent(null, "/xml/field.xml", null, null);
        Object object4 = this.find(object3, "fld");
        this.putProperty(object3, "f", field);
        this.setString(object4, "text", field.name());
        this.add(object3);
        this._showData(object3);
    }

    public void _showData(Object object) {
        Object object2 = this.find(object, "fDataText");
        org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(object, "f");
        String string = null;
        String string2 = "cbUtf";
        Object object3 = this.getSelectedItem(this.find(object, "cbData"));
        String string3 = this.getString(object3, "name");
        boolean bl = false;
        if (string3 != null) {
            string2 = string3;
        }
        int n = 0;
        byte[] byArray = null;
        if (field.isBinary()) {
            byArray = new byte[field.getBinaryLength()];
            System.arraycopy(field.getBinaryValue(), field.getBinaryOffset(), byArray, 0, field.getBinaryLength());
        } else {
            try {
                byArray = field.stringValue().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl = true;
                unsupportedEncodingException.printStackTrace();
                byArray = field.stringValue().getBytes();
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (string2.equals("cbHex")) {
            this.setString(this.find(object, "unit"), "text", " bytes");
            string = Util.bytesToHex(byArray, 0, byArray.length, true);
            n = byArray.length;
        } else if (string2.equals("cbUtf")) {
            this.setString(this.find(object, "unit"), "text", " UTF-8 characters");
            string = field.stringValue();
            if (string != null) {
                n = string.length();
            }
        } else if (string2.equals("cbDef")) {
            this.setString(this.find(object, "unit"), "text", " characters");
            string = new String(byArray);
            n = string.length();
        } else if (string2.equals("cbDate")) {
            try {
                Date date = DateTools.stringToDate(field.stringValue());
                string = date.toString();
                n = 1;
            }
            catch (Exception exception) {
                bl = true;
                string = Util.bytesToHex(byArray, 0, byArray.length, true);
            }
        } else if (string2.equals("cbNum")) {
            try {
                long l = NumberTools.stringToLong(field.stringValue());
                string = String.valueOf(l);
                n = 1;
            }
            catch (Exception exception) {
                bl = true;
                string = Util.bytesToHex(byArray, 0, byArray.length, true);
            }
        } else if (string2.equals("cbInt")) {
            if (byArray.length % 4 == 0) {
                this.setString(this.find(object, "unit"), "text", " int values");
                n = byArray.length / 4;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; i += 4) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(String.valueOf(PayloadHelper.decodeInt(byArray, i)));
                }
                string = stringBuilder.toString();
            } else {
                bl = true;
                string = Util.bytesToHex(byArray, 0, byArray.length, true);
            }
        } else if (string2.equals("cbFloat")) {
            if (byArray.length % 4 == 0) {
                this.setString(this.find(object, "unit"), "text", " float values");
                n = byArray.length / 4;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; i += 4) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(String.valueOf(PayloadHelper.decodeFloat(byArray, i)));
                }
                string = stringBuilder.toString();
            } else {
                bl = true;
                string = Util.bytesToHex(byArray, 0, byArray.length, true);
            }
        }
        this.setString(object2, "text", string);
        this.setString(this.find(object, "len"), "text", String.valueOf(n));
        if (bl) {
            this.setBoolean(object2, "enabled", false);
            this.errorMsg(MSG_CONV_ERROR);
        } else {
            this.setBoolean(object2, "enabled", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveField(Object object) {
        Object object2;
        block23: {
            block22: {
                Object object3 = this.getSelectedItem(object);
                if (object3 == null) {
                    return;
                }
                if (this.ir == null) {
                    this.showStatus(MSG_NOINDEX);
                    return;
                }
                org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(object3, "field");
                if (field == null) {
                    this.showStatus("No data available for this field");
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogType(1);
                jFileChooser.setDialogTitle("Save field content to a file");
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setFileHidingEnabled(false);
                if (this.baseDir != null) {
                    jFileChooser.setCurrentDirectory(new File(this.baseDir));
                } else {
                    jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                }
                int n = jFileChooser.showSaveDialog(this);
                File file = null;
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                }
                if (file == null) {
                    return;
                }
                if (file.exists() && file.isDirectory()) {
                    this.errorMsg("Can't overwrite a directory.");
                    return;
                }
                object2 = null;
                try {
                    try {
                        byte[] byArray = null;
                        if (field.isBinary()) {
                            byArray = field.getBinaryValue();
                        } else {
                            try {
                                byArray = field.stringValue().getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                                this.errorMsg(unsupportedEncodingException.toString());
                                byArray = field.stringValue().getBytes();
                            }
                        }
                        if (byArray == null || byArray.length == 0) {
                            this.showStatus("No data available");
                            Object var14_12 = null;
                            if (object2 == null) return;
                            break block22;
                        }
                        object2 = this.addComponent(null, "/xml/progress.xml", null, null);
                        this.setString(this.find(object2, "msg"), "text", "Saving...");
                        Object object4 = this.find(object2, "bar");
                        this.setInteger(object4, "maximum", 100);
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        int n2 = byArray.length / 100;
                        if (n2 == 0) {
                            n2 = 1;
                        }
                        this.add(object2);
                        for (int i = 0; i < byArray.length; ++i) {
                            ((OutputStream)fileOutputStream).write(byArray[i]);
                            if (i % n2 != 0) continue;
                            this.setInteger(object4, "value", i / n2);
                        }
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                        this.setString(this.find(object2, "msg"), "text", "Done!");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                        }
                        break block23;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.errorMsg("Can't save: " + iOException);
                        Object var14_14 = null;
                        if (object2 == null) return;
                        this.remove(object2);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (object2 == null) throw throwable;
                    this.remove(object2);
                    throw throwable;
                }
            }
            this.remove(object2);
            return;
        }
        Object var14_13 = null;
        if (object2 == null) return;
        this.remove(object2);
    }

    public void clipCopyFields(Object object) {
        Object[] objectArray = this.getSelectedItems(object);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        Document document = (Document)this.getProperty(object, "doc");
        if (document == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(objectArray[i], "field");
            if (field == null) continue;
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(field.toString());
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void clipCopyDoc(Object object) {
        Document document = (Document)this.getProperty(object, "doc");
        if (document == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.getItems(object);
        for (int i = 0; i < objectArray.length; ++i) {
            org.apache.lucene.document.Field field = (org.apache.lucene.document.Field)this.getProperty(objectArray[i], "field");
            if (field == null) continue;
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(field.toString());
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void showFirstTerm(Object object, Object object2) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String string = this.getString(object, "text");
            TermEnum termEnum = this.ir.terms(new Term(string, ""));
            Term term = termEnum.term();
            this._showTerm(object, object2, term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showNextTerm(Object object, Object object2) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String string = this.getString(object2, "text");
            String string2 = this.getString(object, "text");
            TermEnum termEnum = null;
            if (string == null || string.trim().equals("")) {
                string = "";
            }
            termEnum = this.ir.terms(new Term(string2, string));
            termEnum.next();
            Term term = termEnum.term();
            this._showTerm(object, object2, term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showTerm(Object object, Object object2) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String string = this.getString(object2, "text");
            String string2 = this.getString(object, "text");
            if (string == null || string.trim().equals("")) {
                return;
            }
            Term term = new Term(string2, string);
            this._showTerm(object, object2, term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    private void _showTerm(Object object, Object object2, Term term) {
        if (term == null) {
            this.showStatus("No terms?!");
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Object[] objectArray = this.getItems(object);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!term.field().equals(this.getString(objectArray[i], "text"))) continue;
            this.setInteger(object, "selected", i);
            break;
        }
        this.setString(object2, "text", term.text());
        this.putProperty(object2, "term", term);
        this.putProperty(object2, "td", null);
        this.setString(this.find("tdNum"), "text", "?");
        this.setString(this.find("tFreq"), "text", "?");
        Object object3 = this.find("dFreq");
        try {
            int n = this.ir.docFreq(term);
            this.setString(object3, "text", String.valueOf(n));
            object3 = this.find("tdMax");
            this.setString(object3, "text", String.valueOf(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
            this.setString(object3, "text", "?");
        }
    }

    public void showFirstTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermPositions termPositions = this.ir.termPositions(term);
            termPositions.next();
            this.setString(this.find("tdNum"), "text", "1");
            this.putProperty(object, "td", termPositions);
            this._showTermDoc(object, termPositions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showNextTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermPositions termPositions = (TermPositions)this.getProperty(object, "td");
            if (termPositions == null) {
                this.showFirstTermDoc(object);
                return;
            }
            if (!termPositions.next()) {
                return;
            }
            Object object2 = this.find("tdNum");
            String string = this.getString(object2, "text");
            int n = 1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setString(object2, "text", String.valueOf(n + 1));
            this._showTermDoc(object, termPositions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void showPositions(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermPositions termPositions = (TermPositions)this.getProperty(object, "td");
            if (termPositions == null) {
                return;
            }
            Object object2 = this.addComponent(null, "/xml/positions.xml", null, null);
            this.setString(this.find(object2, "term"), "text", term.toString());
            String string = this.getString(this.find("docNum"), "text");
            this.setString(this.find(object2, "docNum"), "text", string);
            this.setString(this.find(object2, "freq"), "text", String.valueOf(termPositions.freq()));
            this.putProperty(object2, "td", termPositions);
            Object object3 = this.find(object2, "pTable");
            this.removeAll(object3);
            int n = termPositions.freq();
            for (int i = 0; i < n; ++i) {
                try {
                    int n2 = termPositions.nextPosition();
                    Object object4 = Luke.create("row");
                    Object object5 = Luke.create("cell");
                    this.setString(object5, "text", String.valueOf(n2));
                    this.add(object4, object5);
                    object5 = Luke.create("cell");
                    this.add(object4, object5);
                    if (termPositions.isPayloadAvailable()) {
                        byte[] byArray = new byte[termPositions.getPayloadLength()];
                        termPositions.getPayload(byArray, 0);
                        this.putProperty(object4, "payload", byArray);
                    }
                    this.add(object3, object4);
                    continue;
                }
                catch (IOException iOException) {
                    this.errorMsg("Error: " + iOException.toString());
                    return;
                }
            }
            this._showPayloads(object2);
            this.add(object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void _showPayloads(Object object) {
        Object object2 = this.find(object, "cbPay");
        Object object3 = this.getSelectedItem(object2);
        String string = "cbUtf";
        if (object3 != null) {
            string = this.getString(object3, "name");
        }
        Object object4 = this.find(object, "pTable");
        Object[] objectArray = this.getItems(object4);
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            StringBuilder stringBuilder;
            byte[] byArray = (byte[])this.getProperty(objectArray[i], "payload");
            if (byArray == null) continue;
            Object object5 = this.getItem(objectArray[i], 1);
            String string2 = string;
            if ((string.equals("cbInt") || string.equals("cbFloat")) && byArray.length % 4 != 0) {
                string2 = "cbHex";
            }
            String string3 = "?";
            if (string2.equals("cbUtf")) {
                try {
                    string3 = new String(byArray, "UTF-8");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string3 = new String(byArray);
                    string2 = "cbDef";
                }
            } else if (string2.equals("cbHex")) {
                string3 = Util.bytesToHex(byArray, 0, byArray.length, false);
            } else if (string2.equals("cbDef")) {
                string3 = new String(byArray);
            } else if (string2.equals("cbInt")) {
                stringBuilder = new StringBuilder();
                for (n = 0; n < byArray.length; n += 4) {
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(String.valueOf(PayloadHelper.decodeInt(byArray, n)));
                }
                string3 = stringBuilder.toString();
            } else if (string2.equals("cbFloat")) {
                stringBuilder = new StringBuilder();
                for (n = 0; n < byArray.length; n += 4) {
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(String.valueOf(PayloadHelper.decodeFloat(byArray, n)));
                }
                string3 = stringBuilder.toString();
            }
            this.setString(object5, "text", string3);
            if (!string2.equals(string)) {
                this.setBoolean(object5, "enabled", false);
                bl = true;
                continue;
            }
            this.setBoolean(object5, "enabled", true);
        }
        if (bl) {
            this.errorMsg(MSG_CONV_ERROR);
        }
    }

    public void clipPositions(Object object) {
        Object[] objectArray = this.getItems(object);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append('\n');
            }
            Object[] objectArray2 = this.getItems(objectArray[i]);
            for (int j = 0; j < objectArray2.length; ++j) {
                if (j > 0) {
                    stringBuilder.append('\t');
                }
                stringBuilder.append(this.getString(objectArray2[j], "text"));
            }
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showAllTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus("MSG_NOINDEX");
            return;
        }
        Object object2 = this.find("maintpane");
        this.setInteger(object2, "selected", 2);
        Object object3 = this.find("qField");
        this.setString(object3, "text", term.field() + ":" + term.text());
        Object object4 = this.find("qFieldParsed");
        TermQuery termQuery = new TermQuery(term);
        this.setString(object4, "text", termQuery.toString());
        IndexSearcher indexSearcher = null;
        indexSearcher = new IndexSearcher(this.dir);
        Object object5 = this.find("sTable");
        this.removeAll(object5);
        AllHitsCollector allHitsCollector = new AllHitsCollector();
        this._search(termQuery, indexSearcher, allHitsCollector, object5);
        Object var11_11 = null;
        if (indexSearcher == null) return;
        try {
            indexSearcher.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorMsg(exception.getMessage());
                Object var11_12 = null;
                if (indexSearcher == null) return;
                try {
                    indexSearcher.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (indexSearcher == null) throw throwable;
            try {
                indexSearcher.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public QueryParser createQueryParser() {
        Object object;
        Object object2;
        Object object3;
        block18: {
            String string;
            object3 = this.find("srchOptTabs");
            String string2 = this.getString(this.find(object3, "cbType"), "text");
            if (string2.trim().equals("")) {
                string2 = "org.apache.lucene.analysis.standard.StandardAnalyzer";
                this.setString(this.find("cbType"), "text", string2);
            }
            if ((string = this.getString(this.find(object3, "snoName"), "text")) == null) {
                string = "";
            }
            try {
                try {
                    object2 = Class.forName(string2).getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object2 = null;
                }
                try {
                    object = Class.forName(string2).getConstructor(String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object = null;
                }
                if (string.length() == 0) {
                    if (object2 != null) {
                        this.analyzer = (Analyzer)((Constructor)object2).newInstance(new Object[0]);
                        break block18;
                    }
                    if (object != null) {
                        this.analyzer = (Analyzer)((Constructor)object).newInstance(string);
                        break block18;
                    }
                    throw new Exception("Must have a zero-arg or (String) constructor");
                }
                if (object != null) {
                    this.analyzer = (Analyzer)((Constructor)object).newInstance(string);
                    break block18;
                }
                if (object2 != null) {
                    this.analyzer = (Analyzer)((Constructor)object2).newInstance(new Object[0]);
                    break block18;
                }
                throw new Exception("Must have a zero-arg or (String) constructor");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorMsg("Analyzer '" + string2 + "' error: " + exception.getMessage() + ". Using StandardAnalyzer.");
                this.analyzer = this.stdAnalyzer;
            }
        }
        Prefs.setProperty("luke.analyzer", this.analyzer.getClass().getName());
        object2 = this.getString(this.find(object3, "defFld"), "text");
        if (object2 == null || ((String)object2).trim().equals("")) {
            if (this.ir != null) {
                object2 = this.idxFields[0];
                this.setString(this.find(object3, "defFld"), "text", (String)object2);
            } else {
                object2 = "DEFAULT";
            }
        }
        object = new QueryParser((String)object2, this.analyzer);
        Object object4 = this.find(object3, "ckWild");
        Object object5 = this.find(object3, "ckPosIncr");
        Object object6 = this.find(object3, "ckLoExp");
        Object object7 = this.find(object3, "cbDateRes");
        DateTools.Resolution resolution = Util.getResolution(this.getString(object7, "text"));
        Object object8 = this.find(object3, "cbOp");
        Object object9 = this.find(object3, "bqMaxCount");
        int n = 1024;
        try {
            n = Integer.parseInt(this.getString(object9, "text"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus("Invalid BooleanQuery max clause count, using default 1024");
        }
        BooleanQuery.setMaxClauseCount(n);
        String string = this.getString(object8, "text");
        QueryParser.Operator operator = string.equalsIgnoreCase("OR") ? QueryParser.OR_OPERATOR : QueryParser.AND_OPERATOR;
        ((QueryParser)object).setAllowLeadingWildcard(this.getBoolean(object4, "selected"));
        ((QueryParser)object).setEnablePositionIncrements(this.getBoolean(object5, "selected"));
        ((QueryParser)object).setLowercaseExpandedTerms(this.getBoolean(object6, "selected"));
        ((QueryParser)object).setDateResolution(resolution);
        ((QueryParser)object).setDefaultOperator(operator);
        return object;
    }

    public Similarity createSimilarity(Object object) {
        Object object2 = this.find(object, "ckSimDef");
        Object object3 = this.find(object, "ckSimSweet");
        Object object4 = this.find(object, "ckSimOther");
        Object object5 = this.find(object, "simClass");
        Object object6 = this.find(object, "ckSimCust");
        if (this.getBoolean(object2, "selected")) {
            return new DefaultSimilarity();
        }
        if (this.getBoolean(object3, "selected")) {
            return new SweetSpotSimilarity();
        }
        if (this.getBoolean(object4, "selected")) {
            try {
                Class<?> clazz = Class.forName(this.getString(object5, "text"));
                if (Similarity.class.isAssignableFrom(clazz)) {
                    Similarity similarity = (Similarity)clazz.newInstance();
                    return similarity;
                }
                throw new Exception("Not a subclass of Similarity: " + clazz.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.showStatus("ERROR: invalid Similarity, using default");
                this.setBoolean(object2, "selected", true);
                this.setBoolean(object4, "selected", false);
                return new DefaultSimilarity();
            }
        }
        if (this.getBoolean(object6, "selected")) {
            return this.similarity;
        }
        return new DefaultSimilarity();
    }

    public AccessibleHitCollector createHitCollector(Object object) throws Exception {
        Object object2 = this.find(object, "ckNormRes");
        Object object3 = this.find(object, "ckAllRes");
        Object object4 = this.find(object, "ckLimRes");
        Object object5 = this.find(object, "ckLimTime");
        Object object6 = this.find(object, "limTime");
        Object object7 = this.find(object, "ckLimCount");
        Object object8 = this.find(object, "limCount");
        Object var9_9 = null;
        if (this.getBoolean(object2, "selected")) {
            return new AccessibleTopHitCollector(1000);
        }
        if (this.getBoolean(object3, "selected")) {
            return new AllHitsCollector();
        }
        if (this.getBoolean(object4, "selected")) {
            if (this.getBoolean(object7, "selected")) {
                int n = Integer.parseInt(this.getString(object8, "text"));
                return new CountLimitedHitCollector(n);
            }
            if (this.getBoolean(object5, "selected")) {
                int n = Integer.parseInt(this.getString(object6, "text"));
                return new IntervalLimitedCollector(n);
            }
            throw new Exception("Unknown LimitedHitCollector type");
        }
        throw new Exception("Unknown HitCollector type");
    }

    public void explainStructure(Object object) {
        Object object2 = this.find("qField");
        String string = this.getString(object2, "text");
        if (string.trim().equals("")) {
            this.showStatus("Empty query");
            return;
        }
        this.showParsed();
        int n = this.getSelectedIndex(object);
        Query query = null;
        query = n == 0 ? (Query)this.getProperty(object2, "qParsed") : (Query)this.getProperty(object2, "qRewritten");
        Object object3 = this.addComponent(this, "/xml/qexplain.xml", null, null);
        Object object4 = this.find(object3, "qTree");
        this._explainStructure(object4, query);
    }

    private void _explainStructure(Object object, Query query) {
        String string = query.getClass().getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        float f = query.getBoost();
        Object object2 = Luke.create("node");
        this.add(object, object2);
        String string2 = string + ": boost=" + this.df.format(f);
        this.setFont(object2, this.getFont().deriveFont(1));
        this.setString(object2, "text", string2);
        if (string.equals("TermQuery")) {
            Object object3 = Luke.create("node");
            Term term = ((TermQuery)query).getTerm();
            this.setString(object3, "text", "Term: field='" + term.field() + "' text='" + term.text() + "'");
            this.add(object2, object3);
        } else if (string.equals("BooleanQuery")) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
            int n2 = booleanQuery.getMaxClauseCount();
            boolean bl = booleanQuery.getAllowDocsOutOfOrder();
            Object object4 = Luke.create("node");
            String string3 = "clauses=" + booleanClauseArray.length + ", maxClauses=" + n2 + ", outOfOrder=" + bl;
            if (booleanQuery.isCoordDisabled()) {
                string3 = string3 + ", coord=false";
            }
            if (booleanQuery.getMinimumNumberShouldMatch() > 0) {
                string3 = string3 + ", minShouldMatch=" + booleanQuery.getMinimumNumberShouldMatch();
            }
            this.setString(object4, "text", string3);
            this.add(object2, object4);
            for (int i = 0; i < booleanClauseArray.length; ++i) {
                object4 = Luke.create("node");
                BooleanClause.Occur occur = booleanClauseArray[i].getOccur();
                String string4 = occur.equals(BooleanClause.Occur.MUST) ? "MUST" : (occur.equals(BooleanClause.Occur.MUST_NOT) ? "MUST_NOT" : (occur.equals(BooleanClause.Occur.SHOULD) ? "SHOULD" : occur.toString()));
                this.setString(object4, "text", "Clause " + i + ": " + string4);
                this.add(object2, object4);
                this._explainStructure(object4, booleanClauseArray[i].getQuery());
            }
        } else if (string.equals("PrefixQuery")) {
            Object object5 = Luke.create("node");
            Term term = ((PrefixQuery)query).getPrefix();
            this.setString(object5, "text", "Prefix: field='" + term.field() + "' text='" + term.text() + "'");
            this.add(object2, object5);
        } else if (string.equals("PhraseQuery")) {
            int n3;
            PhraseQuery phraseQuery = (PhraseQuery)query;
            this.setString(object2, "text", this.getString(object2, "text") + ", slop=" + phraseQuery.getSlop());
            int[] nArray = phraseQuery.getPositions();
            Term[] termArray = phraseQuery.getTerms();
            Object object6 = Luke.create("node");
            StringBuffer stringBuffer = new StringBuffer("pos: [");
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (n3 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("" + nArray[n3]);
            }
            stringBuffer.append("]");
            this.setString(object6, "text", stringBuffer.toString());
            this.add(object2, object6);
            for (n3 = 0; n3 < termArray.length; ++n3) {
                object6 = Luke.create("node");
                this.setString(object6, "text", "Term " + n3 + ": field='" + termArray[n3].field() + "' text='" + termArray[n3].text() + "'");
                this.add(object2, object6);
            }
        } else if (string.equals("MultiPhraseQuery")) {
            MultiPhraseQuery multiPhraseQuery = (MultiPhraseQuery)query;
            this.setString(object2, "text", this.getString(object2, "text") + ", slop=" + multiPhraseQuery.getSlop());
            int[] nArray = multiPhraseQuery.getPositions();
            Object object7 = Luke.create("node");
            StringBuffer stringBuffer = new StringBuffer("pos: [");
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("" + nArray[i]);
            }
            stringBuffer.append("]");
            this.setString(object7, "text", stringBuffer.toString());
            this.add(object2, object7);
            object7 = Luke.create("node");
            System.err.println("MultiPhraseQuery is missing the public getTermArrays() :-(");
            this.setString(object7, "text", "toString: " + multiPhraseQuery.toString());
            this.add(object2, object7);
        } else if (string.equals("FuzzyQuery")) {
            FuzzyQuery fuzzyQuery = (FuzzyQuery)query;
            Object object8 = Luke.create("node");
            this.setString(object8, "text", "prefixLen=" + fuzzyQuery.getPrefixLength() + ", minSimilarity=" + this.df.format(fuzzyQuery.getMinSimilarity()));
            this.add(object2, object8);
            try {
                Method method = FuzzyQuery.class.getDeclaredMethod("getEnum", IndexReader.class);
                method.setAccessible(true);
                FilteredTermEnum filteredTermEnum = (FilteredTermEnum)method.invoke((Object)fuzzyQuery, this.ir);
                object8 = Luke.create("node");
                String string5 = filteredTermEnum.getClass().getName();
                this.setString(object8, "text", string5 + ": diff=" + this.df.format(filteredTermEnum.difference()));
                this.add(object2, object8);
                do {
                    object8 = Luke.create("node");
                    Term term = filteredTermEnum.term();
                    this.setString(object8, "text", "Term: field='" + term.field() + "' text='" + term.text() + "', docFreq=" + filteredTermEnum.docFreq());
                    this.add(object2, object8);
                } while (filteredTermEnum.next());
            }
            catch (Exception exception) {
                object8 = Luke.create("node");
                this.setString(object8, "text", "FilteredTermEnum: Exception " + exception.getMessage());
                this.add(object2, object8);
            }
        } else if (string.equals("WildcardQuery")) {
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            Term term = wildcardQuery.getTerm();
            this.setString(object2, "text", this.getString(object2, "text") + ", term=" + term);
            try {
                Method method = WildcardQuery.class.getDeclaredMethod("getEnum", IndexReader.class);
                method.setAccessible(true);
                FilteredTermEnum filteredTermEnum = (FilteredTermEnum)method.invoke((Object)wildcardQuery, this.ir);
                Object object9 = Luke.create("node");
                String string6 = filteredTermEnum.getClass().getName();
                this.setString(object9, "text", string6 + ": diff=" + this.df.format(filteredTermEnum.difference()));
                this.add(object2, object9);
                do {
                    object9 = Luke.create("node");
                    term = filteredTermEnum.term();
                    if (term == null) continue;
                    this.setString(object9, "text", "Term: field='" + term.field() + "' text='" + term.text() + "', docFreq=" + filteredTermEnum.docFreq());
                    this.add(object2, object9);
                } while (filteredTermEnum.next());
            }
            catch (Exception exception) {
                Object object10 = Luke.create("node");
                this.setString(object10, "text", "FilteredTermEnum: Exception " + exception.getMessage());
                this.add(object2, object10);
            }
        } else if (string.equals("RangeQuery")) {
            RangeQuery rangeQuery = (RangeQuery)query;
            this.setString(object2, "text", this.getString(object2, "text") + ", inclusive=" + rangeQuery.isInclusive());
            Object object11 = Luke.create("node");
            this.setString(object11, "text", "lowerTerm: field='" + rangeQuery.getLowerTerm().field() + "' text='" + rangeQuery.getLowerTerm().text() + "'");
            this.add(object2, object11);
            object11 = Luke.create("node");
            this.setString(object11, "text", "upperTerm: field='" + rangeQuery.getUpperTerm().field() + "' text='" + rangeQuery.getUpperTerm().text() + "'");
            this.add(object2, object11);
        } else if (query instanceof SpanQuery) {
            Object object12;
            Object object13;
            SpanQuery spanQuery = (SpanQuery)query;
            this.setString(object2, "text", this.getString(object2, "text") + ", field=" + spanQuery.getField());
            HashSet hashSet = new HashSet();
            spanQuery.extractTerms(hashSet);
            Object object14 = null;
            if (hashSet != null) {
                object14 = Luke.create("node");
                this.setString(object14, "text", "Matched terms (" + hashSet.size() + "):");
                this.add(object2, object14);
                object13 = hashSet.iterator();
                while (object13.hasNext()) {
                    object12 = Luke.create("node");
                    Term term = (Term)object13.next();
                    this.setString(object12, "text", "field='" + term.field() + "' text='" + term.text() + "'");
                    this.add(object14, object12);
                }
            } else {
                object14 = Luke.create("node");
                this.setString(object14, "text", "<no terms matched>");
                this.add(object2, object14);
            }
            try {
                object13 = spanQuery.getSpans(this.ir);
                object14 = Luke.create("node");
                this.setString(object14, "text", "Spans:");
                this.add(object2, object14);
                do {
                    object12 = Luke.create("node");
                    this.setString(object12, "text", "doc=" + object13.doc() + ", start=" + object13.start() + ", end=" + object13.end());
                    this.add(object14, object12);
                } while (object13.next());
            }
            catch (Exception exception) {
                object14 = Luke.create("node");
                this.setString(object14, "text", "Spans Exception: " + exception.getMessage());
                this.add(object2, object14);
            }
        } else {
            Object object15 = Luke.create("node");
            this.setString(object15, "text", query.getClass().getName() + ": " + query.toString());
            this.add(object2, object15);
        }
    }

    public void showParsed() {
        Object object = this.find("qField");
        Object object2 = this.find("qFieldParsed");
        Object object3 = this.find("qFieldRewritten");
        String string = this.getString(object, "text");
        if (string.trim().equals("")) {
            this.setString(object2, "text", "<empty query>");
            this.setBoolean(object2, "enabled", false);
            return;
        }
        this.setBoolean(object2, "enabled", true);
        QueryParser queryParser = this.createQueryParser();
        try {
            Query query = queryParser.parse(string);
            this.setString(object2, "text", query.toString());
            this.putProperty(object, "qParsed", query);
            query = query.rewrite(this.ir);
            this.setString(object3, "text", query.toString());
            this.putProperty(object, "qRewritten", query);
        }
        catch (Throwable throwable) {
            this.setString(object2, "text", throwable.getMessage());
            this.setString(object3, "text", throwable.getMessage());
        }
    }

    public void search(Object object) {
        AccessibleHitCollector accessibleHitCollector;
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String string = this.getString(object, "text");
        if (string.trim().equals("")) {
            this.showStatus("FAILED: Empty query.");
            return;
        }
        this.qp = this.createQueryParser();
        Object object2 = this.find("srchOptTabs");
        Similarity similarity = this.createSimilarity(object2);
        try {
            accessibleHitCollector = this.createHitCollector(object2);
        }
        catch (Throwable throwable) {
            this.errorMsg("ERROR creating HitCollector: " + throwable.getMessage());
            return;
        }
        Object object3 = this.find("sTable");
        this.removeAll(object3);
        Query query = null;
        try {
            query = this.qp.parse(string);
            this.is.setSimilarity(similarity);
            this.showParsed();
            this._search(query, this.is, accessibleHitCollector, object3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.errorMsg(throwable.getMessage());
        }
    }

    private void _search(Query query, IndexSearcher indexSearcher, AccessibleHitCollector accessibleHitCollector, Object object) throws Exception {
        long l = System.currentTimeMillis();
        if (accessibleHitCollector == null) {
            accessibleHitCollector = new AccessibleTopHitCollector(1000);
        }
        LimitedException limitedException = null;
        try {
            indexSearcher.search(query, accessibleHitCollector);
        }
        catch (LimitedException limitedException2) {
            limitedException = limitedException2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.errorMsg("ERROR searching: " + throwable.toString());
            return;
        }
        long l2 = System.currentTimeMillis();
        this.showStatus(l2 - l + " ms");
        Object object2 = this.find("bsPrev");
        Object object3 = this.find("bsNext");
        this.setBoolean(object3, "enabled", false);
        this.setBoolean(object2, "enabled", false);
        int n = accessibleHitCollector.getTotalHits();
        if (n == 0) {
            Object object4 = Luke.create("row");
            Object object5 = Luke.create("cell");
            this.add(object, object4);
            this.add(object4, object5);
            object5 = Luke.create("cell");
            this.add(object4, object5);
            object5 = Luke.create("cell");
            this.setString(object5, "text", "No Results");
            this.setBoolean(object5, "enabled", false);
            this.add(object4, object5);
            this.setString(this.find("resNum"), "text", "0");
            return;
        }
        if (n > this.resCount) {
            this.setBoolean(object3, "enabled", true);
        }
        this.setString(this.find("resNum"), "text", String.valueOf(n));
        this.putProperty(object, "resNum", new Integer(n));
        this.putProperty(object, "query", query);
        this.putProperty(object, "hc", accessibleHitCollector);
        if (limitedException != null) {
            this.putProperty(object, "le", limitedException);
        }
        this.resStart = 0;
        this._showSearchPage(object);
    }

    public void prevPage(Object object) {
        int n = (Integer)this.getProperty(object, "resNum");
        if (this.resStart == 0) {
            this.setBoolean(this.find("bsPrev"), "enabled", false);
            return;
        }
        this.resStart -= this.resCount;
        if (this.resStart < 0) {
            this.resStart = 0;
        }
        if (this.resStart - this.resCount < 0) {
            this.setBoolean(this.find("bsPrev"), "enabled", false);
        }
        if (this.resStart + this.resCount < n) {
            this.setBoolean(this.find("bsNext"), "enabled", true);
        }
        try {
            this._showSearchPage(object);
        }
        catch (Exception exception) {
            this.errorMsg(exception.getMessage());
        }
    }

    public void nextPage(Object object) {
        int n = (Integer)this.getProperty(object, "resNum");
        this.resStart += this.resCount;
        if (this.resStart >= n) {
            this.resStart -= this.resCount;
            this.setBoolean(this.find("bsNext"), "enabled", false);
            return;
        }
        this.setBoolean(this.find("bsPrev"), "enabled", true);
        if (this.resStart + this.resCount >= n) {
            this.setBoolean(this.find("bsNext"), "enabled", false);
        }
        try {
            this._showSearchPage(object);
        }
        catch (Exception exception) {
            this.errorMsg(exception.getMessage());
        }
    }

    private void _showSearchPage(Object object) throws Exception {
        this.removeAll(object);
        AccessibleHitCollector accessibleHitCollector = (AccessibleHitCollector)this.getProperty(object, "hc");
        int n = accessibleHitCollector.getTotalHits();
        int n2 = Math.min(n, this.resStart + this.resCount);
        Object object2 = this.find("resPos");
        this.setString(object2, "text", this.resStart + "-" + (n2 - 1));
        for (int i = this.resStart; i < n2; ++i) {
            int n3 = accessibleHitCollector.getDocId(i);
            float f = accessibleHitCollector.getScore(i);
            this._createResultRow(i, n3, f, object);
        }
    }

    private void _createResultRow(int n, int n2, float f, Object object) throws IOException {
        Object object2 = Luke.create("row");
        Object object3 = Luke.create("cell");
        this.add(object, object2);
        this.setString(object3, "text", String.valueOf(n));
        this.setChoice(object3, "alignment", "right");
        this.add(object2, object3);
        object3 = Luke.create("cell");
        this.setString(object3, "text", String.valueOf(this.df.format(f)));
        this.setChoice(object3, "alignment", "right");
        this.add(object2, object3);
        object3 = Luke.create("cell");
        this.setString(object3, "text", String.valueOf(n2));
        this.setChoice(object3, "alignment", "right");
        this.add(object2, object3);
        Document document = this.ir.document(n2);
        this.putProperty(object2, "docid", new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.idxFields.length; ++i) {
            object3 = Luke.create("cell");
            String[] stringArray = document.getValues(this.idxFields[i]);
            stringBuffer.setLength(0);
            if (stringArray != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(Util.escape(stringArray[j]));
                }
            }
            this.setString(object3, "text", stringBuffer.toString());
            this.add(object2, object3);
        }
    }

    public void explainResult(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Integer n = (Integer)this.getProperty(object2, "docid");
        if (n == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Query query = (Query)this.getProperty(object, "query");
        if (query == null) {
            return;
        }
        try {
            IndexSearcher indexSearcher = new IndexSearcher(this.dir);
            indexSearcher.setSimilarity(this.createSimilarity(this.find("srchOptTabs")));
            Explanation explanation = indexSearcher.explain(query, (int)n);
            Object object3 = this.addComponent(null, "/xml/explain.xml", null, null);
            Object object4 = this.find(object3, "eTree");
            this.addNode(object4, explanation);
            this.add(object3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg(exception.getMessage());
        }
    }

    private void addNode(Object object, Explanation explanation) {
        Explanation[] explanationArray;
        Object object2 = Luke.create("node");
        this.setString(object2, "text", this.df.format(explanation.getValue()) + "  " + explanation.getDescription());
        this.add(object, object2);
        if (Luke.getClass(object) == "tree") {
            this.setFont(object2, this.getFont().deriveFont(1));
        }
        if ((explanationArray = explanation.getDetails()) != null && explanationArray.length > 0) {
            for (int i = 0; i < explanationArray.length; ++i) {
                this.addNode(object2, explanationArray[i]);
            }
        }
    }

    public void gotoDoc(Object object) {
        Object object2 = this.getSelectedItem(object);
        if (object2 == null) {
            return;
        }
        Integer n = (Integer)this.getProperty(object2, "docid");
        if (n == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Document document = null;
        try {
            document = this.ir.document(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
            return;
        }
        this._showDocFields(n, document);
        Object object3 = this.find("maintpane");
        this.setInteger(object3, "selected", 1);
        this.repaint();
    }

    private void _showTermDoc(Object object, TermPositions termPositions) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            Document document = this.ir.document(termPositions.doc());
            this.setString(this.find("docNum"), "text", String.valueOf(termPositions.doc()));
            this.setString(this.find("tFreq"), "text", String.valueOf(termPositions.freq()));
            this._showDocFields(termPositions.doc(), document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public void deleteTermDoc(Object object) {
        Term term = (Term)this.getProperty(object, "term");
        if (term == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.showNextTerm(this.find("fCombo"), object);
            this.ir.deleteDocuments(term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
        this.initOverview();
    }

    public void deleteDoc(Object object) {
        int n = 0;
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            n = Integer.parseInt(this.getString(object, "text"));
            this.ir.deleteDocument(n);
            this.showDoc(object);
            this.initOverview();
            this.showFiles(this.dir, Collections.EMPTY_LIST);
            this.showStatus("Document #" + n + " deleted OK.");
        }
        catch (Exception exception) {
            this.showStatus(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void actionDeleteDocList(Object object) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            String string = this.getString(object, "text");
            Ranges ranges = Ranges.parse(string);
            if (ranges.cardinality() == 0L) {
                this.infoMsg("Empty list - no documents deleted.");
                return;
            }
            long l = ranges.cardinality();
            DocIdSetIterator docIdSetIterator = ranges.iterator();
            while (docIdSetIterator.next()) {
                this.ir.deleteDocument(docIdSetIterator.doc());
            }
            this.showDoc(this.find("docNum"));
            this.initOverview();
            this.showFiles(this.dir, Collections.EMPTY_LIST);
            this.showStatus(l + " documents marked as deleted.");
        }
        catch (Exception exception) {
            this.errorMsg("Error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void deleteDocList(Object object) {
        Object[] objectArray = this.getSelectedItems(object);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n = (Integer)this.getProperty(objectArray[i], "docid");
            if (n == null) continue;
            try {
                this.ir.deleteDocument(n);
            }
            catch (Exception exception) {
                continue;
            }
            this.remove(objectArray[i]);
        }
        try {
            this.initOverview();
            this.showFiles(this.dir, Collections.EMPTY_LIST);
        }
        catch (Exception exception) {
            this.errorMsg("Error: " + exception.toString());
        }
    }

    public void actionAbout() {
        Object object = this.addComponent(this, "/xml/about.xml", null, null);
        Object object2 = this.find(object, "lver");
        this.setString(object2, "text", "Lucene version: " + LucenePackage.get().getImplementationVersion());
    }

    public void actionShowFonts() {
        this.addComponent(this, "/xml/selfont.xml", null, null);
    }

    public void setupSelFont(Object object) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        Object object2 = this.find(object, "fonts");
        String string = this.getFont().getFontName();
        float f = this.getFont().getSize2D();
        Object object3 = this.find(object, "fsize");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        this.setString(object3, "text", numberFormat.format(f));
        this.removeAll(object2);
        Object object4 = Luke.create("choice");
        this.setFont(object4, "font", this.getFont().deriveFont(15.0f));
        this.setString(object4, "text", string + " (default)");
        this.putProperty(object4, "fnt", this.getFont());
        this.add(object2, object4);
        this.setInteger(object2, "selected", 0);
        for (int i = 0; i < fontArray.length; ++i) {
            Object object5 = Luke.create("choice");
            this.setFont(object5, "font", fontArray[i].deriveFont(15.0f));
            this.setString(object5, "text", fontArray[i].getFontName());
            this.putProperty(object5, "fnt", fontArray[i]);
            this.add(object2, object5);
            if (!string.equalsIgnoreCase(fontArray[i].getFontName())) continue;
            this.setInteger(object2, "selected", i + 1);
        }
    }

    public void selectFont(Object object) {
        Object object2 = this.find(object, "fpreview");
        Object object3 = this.find(object, "fonts");
        Object object4 = this.find(object, "fsize");
        Font font = (Font)this.getProperty(this.getSelectedItem(object3), "fnt");
        float f = this.getFont().getSize2D();
        try {
            f = Float.parseFloat(this.getString(object4, "text"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        font = font.deriveFont(f);
        Object[] objectArray = this.getItems(object2);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setPreviewFont(font, objectArray[i]);
        }
    }

    private void setPreviewFont(Font font, Object object) {
        try {
            this.setFont(object, "font", font);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object[] objectArray = this.getItems(object);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setPreviewFont(font, objectArray[i]);
        }
    }

    public void actionSetFont(Object object) {
        Object object2 = this.find(object, "fonts");
        Object object3 = this.find(object, "fsize");
        Font font = (Font)this.getProperty(this.getSelectedItem(object2), "fnt");
        float f = this.getFont().getSize2D();
        try {
            f = Float.parseFloat(this.getString(object3, "text"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        font = font.deriveFont(f);
        this.remove(object);
        this.setFont(font);
        this.courier = new Font("Courier", this.getFont().getStyle(), this.getFont().getSize());
        this.repaint();
    }

    public Similarity getCustomSimilarity() {
        return this.similarity;
    }

    public void setCustomSimilarity(Similarity similarity) {
        this.similarity = similarity;
        Object object = this.find("ckSimCust");
        Object object2 = this.find("ckSimDef");
        Object object3 = this.find("simName");
        if (this.similarity != null) {
            this.setString(object3, "text", this.similarity.getClass().getName());
            this.setBoolean(object, "enabled", true);
        } else {
            this.setString(object3, "text", "");
            this.setBoolean(object, "enabled", false);
            this.setBoolean(object2, "selected", true);
            this.setBoolean(object, "selected", false);
        }
    }

    public void actionDesignSimilarity() {
        LukePlugin lukePlugin = null;
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!this.plugins.get(i).getClass().getName().equals("org.getopt.luke.plugins.SimilarityDesignerPlugin")) continue;
            lukePlugin = (LukePlugin)this.plugins.get(i);
            break;
        }
        if (lukePlugin == null) {
            this.showStatus("Designer Plugin not available");
            return;
        }
        Object object = this.find("pluginsTab");
        Object object2 = this.getParent(object);
        int n = this.getIndex(object2, object);
        this.setInteger(object2, "selected", n);
        Object object3 = this.find("pluginsTabs");
        Object object4 = this.getParent(this.getParent(lukePlugin.getMyUi()));
        n = this.getIndex(object3, object4);
        this.setInteger(object3, "selected", n);
        this.repaint();
    }

    @Override
    public boolean destroy() {
        if (this.ir != null) {
            try {
                this.ir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dir != null) {
            try {
                this.dir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Prefs.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exitOnDestroy) {
            System.exit(0);
        }
        return super.destroy();
    }

    public void actionExit() {
        this.destroy();
    }

    public void goUrl(Object object) {
        String string = (String)this.getProperty(object, "url");
        if (string == null) {
            return;
        }
        try {
            BrowserLauncher.openURL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(exception.getMessage());
        }
    }

    public static Luke startLuke(String[] stringArray) {
        Luke luke = new Luke();
        FrameLauncher frameLauncher = new FrameLauncher("Luke - Lucene Index Toolbox, v 0.9.1 (2008-11-22)", luke, 800, 600);
        frameLauncher.setIconImage(Toolkit.getDefaultToolkit().createImage(Luke.class.getResource("/img/luke.gif")));
        if (stringArray.length > 0) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string = null;
            String string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-ro")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-force")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-ramdir")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-index")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-script")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.err.println("Unknown argument: " + stringArray[i]);
                Luke.usage();
                luke.actionExit();
                return null;
            }
            if (string != null) {
                luke.openIndex(string, bl, null, bl2, bl3, false, null, 1);
            }
            if (string2 != null) {
                LukePlugin lukePlugin = luke.getPlugin("org.getopt.luke.plugins.ScriptingPlugin");
                if (lukePlugin == null) {
                    String string3 = "ScriptingPlugin not present - cannot execute scripts.";
                    System.err.println(string3);
                    luke.actionExit();
                } else {
                    ((ScriptingPlugin)lukePlugin).execute("load('" + string2 + "');");
                }
            }
        } else {
            luke.actionOpen();
        }
        return luke;
    }

    public static void main(String[] stringArray) {
        exitOnDestroy = true;
        Luke.startLuke(stringArray);
    }

    public static void usage() {
        System.err.println("Command-line usage:\n");
        System.err.println("Luke [-index path_to_index] [-ro] [-force] [-mmap] [-script filename]\n");
        System.err.println("\t-index path_to_index\topen this index");
        System.err.println("\t-ro\topen index read-only");
        System.err.println("\t-force\tforce unlock if the index is locked (use with caution)");
        System.err.println("\t-mmap\tuse MMapDirectory");
        System.err.println("\t-script filename\trun this script using the ScriptingPlugin.");
        System.err.println("\t\tIf an index name is specified, the index is open prior to");
        System.err.println("\t\tstarting the script. Note that you need to escape special");
        System.err.println("\t\tcharacters twice - first for shell and then for JavaScript.");
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

