/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prefs {
    public static final String LUKE_PREFS_FILE = ".luke";
    private static final String HOME_DIR = System.getProperty("user.home");
    public static final String P_LAST_PWD = "luke.last_pwd";
    public static final String P_MRU_ARRAY = "luke.mru";
    public static final String P_MRU_SIZE = "luke.mru_size";
    public static final String P_FONT_NAME = "luke.fontname";
    public static final String P_FONT_SIZE = "luke.fontsize";
    public static final String P_THEME = "luke.theme";
    public static final String P_ANALYZER = "luke.analyzer";
    public static final String P_FIELD = "luke.field";
    private static Properties props = new Properties();
    private static String[][] defaults = new String[][]{{"luke.mru_size", "10"}, {"luke.fontname", "sansserif.plain"}, {"luke.fontsize", "12"}};
    private static List<String> mruList = new ArrayList<String>();
    private static int mruMaxSize = 10;
    private static String prefsFile = HOME_DIR + "/" + ".luke";

    public static void load() {
        Prefs.load(prefsFile);
    }

    public static void load(String string) {
        for (int i = 0; i < defaults.length; ++i) {
            props.setProperty(defaults[i][0], defaults[i][1]);
        }
        try {
            props.load(new FileInputStream(string));
            Prefs.initMruList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initMruList() {
        mruMaxSize = Prefs.getInteger(P_MRU_SIZE, 10);
        String[] stringArray = Prefs.getPropertyArray(P_MRU_ARRAY);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < Math.min(stringArray.length, mruMaxSize); ++i) {
                mruList.add(stringArray[i].intern());
            }
        }
    }

    public static void addToMruList(String string) {
        if (string == null || string.trim().equals("") || mruList.contains(string.intern())) {
            return;
        }
        if (mruList.size() >= mruMaxSize) {
            mruList.remove(mruList.size() - 1);
        }
        mruList.add(0, string);
    }

    public static List<String> getMruList() {
        return Collections.unmodifiableList(mruList);
    }

    public static void save() throws Exception {
        Prefs.setPropertyArray(P_MRU_ARRAY, mruList.toArray(new String[0]));
        props.store(new FileOutputStream(prefsFile), null);
    }

    public static int getInteger(String string, int n) {
        String string2 = props.getProperty(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = props.getProperty(string);
        boolean bl2 = bl;
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static String[] getPropertyArray(String string) {
        String[] stringArray;
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        do {
            if ((string2 = props.getProperty((String)(stringArray = string + "." + n))) != null) {
                arrayList.add(string2);
            }
            ++n;
        } while (string2 != null);
        if (arrayList.size() == 0) {
            return null;
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static void deletePropertyArray(String string) {
        String string2 = string + ".";
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            props.remove(string3);
        }
    }

    public static void setPropertyArray(String string, String[] stringArray) {
        Prefs.deletePropertyArray(string);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            props.setProperty(string + "." + i, stringArray[i]);
        }
    }

    public static String getProperty(String string) {
        return Prefs.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public static void setProperty(String string, String string2) {
        props.setProperty(string, string2);
    }
}

