/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.HashMap;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Field;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;

public class Util {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static HashMap<String, DateTools.Resolution> resolutionMap = new HashMap();

    public static String bytesToHex(byte[] byArray, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            if (i > n) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Integer.toHexString(256 + (byArray[i] & 0xFF)).substring(1));
            if (i <= 0 || (i + 1) % 16 != 0 || !bl) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBytes(String string) {
        if (string == null) {
            return EMPTY_BYTES;
        }
        if ((string = string.replaceAll("\\s+", "")).length() == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() / 2);
        for (int i = 0; i < string.length(); ++i) {
            int n = Util.charToNibble(string.charAt(i));
            int n2 = 0;
            if (i < string.length() - 1) {
                n2 = Util.charToNibble(string.charAt(++i));
            }
            byte by = (byte)(n << 4 | n2);
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static final int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new RuntimeException("Not a hex character: '" + c + "'");
    }

    public static String byteToHex(byte by) {
        return Util.bytesToHex(new byte[]{by}, 0, 1, false);
    }

    public static String escape(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(Util.escape(stringArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                }
                default: {
                    if (c >= ' ' && c <= '\u007f' || Character.isLetterOrDigit(c)) {
                        stringBuffer.append(c);
                        continue block5;
                    }
                    stringBuffer.append("&#" + c + ";");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String fieldFlags(Field field) {
        if (field == null) {
            return "-----------";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (field != null && field.isIndexed()) {
            stringBuffer.append("I");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isTokenized()) {
            stringBuffer.append("T");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isStored()) {
            stringBuffer.append("S");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isTermVectorStored()) {
            stringBuffer.append("V");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isStoreOffsetWithTermVector()) {
            stringBuffer.append("o");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isStorePositionWithTermVector()) {
            stringBuffer.append("p");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.getOmitTf()) {
            stringBuffer.append("f");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.getOmitNorms()) {
            stringBuffer.append("O");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isLazy()) {
            stringBuffer.append("L");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isBinary()) {
            stringBuffer.append("B");
        } else {
            stringBuffer.append("-");
        }
        if (field != null && field.isCompressed()) {
            stringBuffer.append("C");
        } else {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public static DateTools.Resolution getResolution(String string) {
        if (string == null || string.trim().length() == 0) {
            return DateTools.Resolution.MILLISECOND;
        }
        DateTools.Resolution resolution = resolutionMap.get(string);
        if (resolution != null) {
            return resolution;
        }
        return DateTools.Resolution.MILLISECOND;
    }

    public static long calcTotalFileSize(String string, Directory directory) {
        long l = 0L;
        String[] stringArray = null;
        if (directory instanceof FSDirectory) {
            stringArray = ((FSDirectory)directory).list();
        } else if (directory instanceof MMapDirectory) {
            stringArray = ((MMapDirectory)directory).list();
        }
        if (stringArray == null) {
            return l;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string.endsWith(File.separator) ? string : string + File.separator;
            File file = new File(string2 + stringArray[i]);
            l += file.length();
        }
        return l;
    }

    public static String normalizeUnit(long l) {
        if (l == 1L) {
            return " byte";
        }
        if (l < 1024L) {
            return " bytes";
        }
        if (l < 51200000L) {
            return " kB";
        }
        return " MB";
    }

    public static String normalizeSize(long l) {
        if (l < 1024L) {
            return String.valueOf(l);
        }
        if (l < 51200000L) {
            return String.valueOf(l / 1024L);
        }
        return String.valueOf(l / 0x100000L);
    }

    static {
        resolutionMap.put(DateTools.Resolution.MILLISECOND.toString(), DateTools.Resolution.MILLISECOND);
        resolutionMap.put(DateTools.Resolution.SECOND.toString(), DateTools.Resolution.SECOND);
        resolutionMap.put(DateTools.Resolution.MINUTE.toString(), DateTools.Resolution.MINUTE);
        resolutionMap.put(DateTools.Resolution.HOUR.toString(), DateTools.Resolution.HOUR);
        resolutionMap.put(DateTools.Resolution.DAY.toString(), DateTools.Resolution.DAY);
        resolutionMap.put(DateTools.Resolution.MONTH.toString(), DateTools.Resolution.MONTH);
        resolutionMap.put(DateTools.Resolution.YEAR.toString(), DateTools.Resolution.YEAR);
    }
}

