/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexGate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.getopt.luke.IndexInfo;
import org.getopt.luke.ProgressNotification;
import org.getopt.luke.Ranges;
import org.getopt.luke.TermInfo;
import org.getopt.luke.Util;

public class XMLExporter
extends Observable {
    private IndexReader reader;
    private String indexPath;
    private boolean abort = false;
    private boolean running = false;
    private ProgressNotification pn = new ProgressNotification();
    private List<String> fieldNames;

    public XMLExporter(IndexReader indexReader, String string) {
        this.reader = indexReader;
        this.indexPath = string;
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.addAll(indexReader.getFieldNames(IndexReader.FieldOption.ALL));
        Collections.sort(this.fieldNames);
    }

    public void abort() {
        this.abort = true;
    }

    public boolean isAborted() {
        return this.abort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(OutputStream outputStream, boolean bl, boolean bl2, String string, Ranges ranges) throws Exception {
        block21: {
            this.running = true;
            this.pn.message = "Export running ...";
            this.pn.minValue = 0;
            this.pn.maxValue = this.reader.maxDoc();
            this.pn.curValue = 0;
            this.setChanged();
            this.notifyObservers(this.pn);
            if (string == null) {
                string = "index";
            }
            boolean bl3 = false;
            int n = this.reader.maxDoc() / 100;
            if (n == 0) {
                n = 1;
            }
            int n2 = 0;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            try {
                if (bl) {
                    bufferedWriter.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                }
                bufferedWriter.write("<" + string + ">\n");
                bl3 = true;
                if (bl2) {
                    this.writeIndexInfo(bufferedWriter);
                }
                Document document = null;
                int n3 = -1;
                if (ranges == null) {
                    ranges = new Ranges();
                    ranges.set(0, this.reader.maxDoc());
                }
                if (ranges.cardinality() <= 0L) break block21;
                while (true) {
                    ++n3;
                    if ((n3 = ranges.nextSetBit(n3)) == -1) break;
                    if (n3 >= this.reader.maxDoc()) {
                        break;
                    }
                    if (this.abort) {
                        this.pn.message = "User requested abort.";
                        this.pn.aborted = true;
                        this.running = false;
                        this.setChanged();
                        this.notifyObservers(this.pn);
                        break;
                    }
                    if (this.reader.isDeleted(n3)) continue;
                    document = this.reader.document(n3);
                    this.writeDoc(bufferedWriter, n3, document);
                    this.pn.curValue = n3 + 1;
                    if (++n2 <= n) continue;
                    n2 = 0;
                    this.setChanged();
                    this.notifyObservers(this.pn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.pn.message = "ERROR creating output: " + exception.toString();
                this.pn.aborted = true;
                this.running = false;
                this.setChanged();
                this.notifyObservers(this.pn);
                boolean bl4 = false;
                return bl4;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        if (bl3) {
                            bufferedWriter.write("</" + string + ">");
                        }
                        bufferedWriter.flush();
                    }
                    catch (Exception exception) {
                        this.pn.message = "ERROR closing output: " + exception.toString();
                        this.pn.aborted = true;
                        this.running = false;
                        this.setChanged();
                        this.notifyObservers(this.pn);
                        return false;
                    }
                }
            }
        }
        this.pn.message = "Finished.";
        this.setChanged();
        this.notifyObservers(this.pn);
        this.running = false;
        return !this.pn.aborted;
    }

    private void writeDoc(BufferedWriter bufferedWriter, int n, Document document) throws Exception {
        bufferedWriter.write("<doc id='" + n + "'>\n");
        for (String string : this.fieldNames) {
            Field[] fieldArray = document.getFields(string);
            if (fieldArray == null || fieldArray.length == 0) continue;
            bufferedWriter.write("<field name='" + fieldArray[0].name());
            if (this.reader.hasNorms(fieldArray[0].name())) {
                bufferedWriter.write("' norm='" + Similarity.decodeNorm(this.reader.norms(fieldArray[0].name())[n]));
            }
            bufferedWriter.write("' flags='" + Util.fieldFlags(fieldArray[0]) + "'>\n");
            for (Field field : fieldArray) {
                if (field.isBinary()) {
                    bufferedWriter.write("<val>" + Util.bytesToHex(field.getBinaryValue(), field.getBinaryOffset(), field.getBinaryLength(), false) + "</val>\n");
                    continue;
                }
                bufferedWriter.write("<val>" + field.stringValue() + "</val>\n");
            }
            TermFreqVector object = this.reader.getTermFreqVector(n, string);
            if (object != null) {
                this.writeTermVector(bufferedWriter, object);
            }
            bufferedWriter.write("</field>\n");
        }
        bufferedWriter.write("</doc>\n");
    }

    private void writeTermVector(BufferedWriter bufferedWriter, TermFreqVector termFreqVector) throws Exception {
        bufferedWriter.write("<tv size='" + termFreqVector.size() + ">\n");
        String[] stringArray = termFreqVector.getTerms();
        int[] nArray = termFreqVector.getTermFrequencies();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int[] nArray2 = null;
            TermVectorOffsetInfo[] termVectorOffsetInfoArray = null;
            if (termFreqVector instanceof TermPositionVector) {
                nArray2 = ((TermPositionVector)termFreqVector).getTermPositions(i);
                termVectorOffsetInfoArray = ((TermPositionVector)termFreqVector).getOffsets(i);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (nArray2 != null) {
                stringBuilder.append(" positions='");
                for (n = 0; n < nArray2.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(String.valueOf(nArray2[n]));
                }
                stringBuilder.append("'");
            }
            if (termVectorOffsetInfoArray != null) {
                stringBuilder.append(" offsets='");
                for (n = 0; n < termVectorOffsetInfoArray.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(termVectorOffsetInfoArray[n].getStartOffset() + "-" + termVectorOffsetInfoArray[n].getEndOffset());
                }
                stringBuilder.append("'");
            }
            bufferedWriter.write("<t text='" + stringArray[i] + "' freq='" + nArray[i] + "'" + stringBuilder.toString() + "/>\n");
        }
        bufferedWriter.write("</tv>\n");
    }

    private void writeIndexInfo(BufferedWriter bufferedWriter) throws Exception {
        Directory directory = this.reader.directory();
        bufferedWriter.write("<info>\n");
        IndexInfo indexInfo = new IndexInfo(this.reader, this.indexPath);
        bufferedWriter.write(" <indexPath>" + this.indexPath + "</indexPath>\n");
        bufferedWriter.write(" <fields count='" + indexInfo.getFieldNames().size() + "'>\n");
        for (String object : indexInfo.getFieldNames()) {
            bufferedWriter.write("  <field name='" + object + "'/>\n");
        }
        bufferedWriter.write(" </fields>\n");
        bufferedWriter.write(" <numDocs>" + this.reader.numDocs() + "</numDocs>\n");
        bufferedWriter.write(" <maxDoc>" + this.reader.maxDoc() + "</maxDoc>\n");
        bufferedWriter.write(" <numDeletedDocs>" + this.reader.numDeletedDocs() + "</numDeletedDocs>\n");
        bufferedWriter.write(" <numTerms>" + indexInfo.getNumTerms() + "</numTerms>\n");
        bufferedWriter.write(" <hasDeletions>" + this.reader.hasDeletions() + "</hasDeletions>\n");
        bufferedWriter.write(" <optimized>" + this.reader.isOptimized() + "</optimized>\n");
        bufferedWriter.write(" <lastModified>" + indexInfo.getLastModified() + "</lastModified>\n");
        bufferedWriter.write(" <indexVersion>" + Long.toHexString(this.reader.getVersion()) + "</indexVersion>\n");
        bufferedWriter.write(" <indexFormat>\n");
        bufferedWriter.write("  <id>" + indexInfo.getIndexFormat() + "</id>\n");
        bufferedWriter.write("  <genericName>" + indexInfo.getFormatDetails().genericName + "</genericName>\n");
        bufferedWriter.write("  <capabilities>" + indexInfo.getFormatDetails().capabilities + "</capabilities>\n");
        bufferedWriter.write(" </indexFormat>\n");
        bufferedWriter.write(" <directoryImpl>" + this.reader.directory().getClass().getName() + "</directoryImpl>\n");
        bufferedWriter.write(" <files count='" + directory.list().length + "'>\n");
        Object[] objectArray = directory.list();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            bufferedWriter.write("  <file name='" + (String)object + "' size='" + directory.fileLength((String)object) + "' func='" + IndexGate.getFileFunction((String)object) + "'/>\n");
        }
        bufferedWriter.write(" </files>\n");
        bufferedWriter.write(" <commits count='" + IndexReader.listCommits(directory).size() + "'>\n");
        for (Object e : IndexReader.listCommits(directory)) {
            IndexCommit indexCommit = (IndexCommit)e;
            bufferedWriter.write("  <commit tstamp='" + new Date(indexCommit.getTimestamp()).toString() + "' segment='" + indexCommit.getSegmentsFileName() + "' optimized='" + indexCommit.isOptimized() + "' deleted='" + indexCommit.isDeleted() + "' files='" + indexCommit.getFileNames().size() + "'>\n");
            for (Object e2 : indexCommit.getFileNames()) {
                bufferedWriter.write("   <file name='" + e2.toString() + "'/>\n");
            }
            bufferedWriter.write("  </commit>\n");
        }
        bufferedWriter.write(" </commits>\n");
        bufferedWriter.write(" <topTerms count='" + indexInfo.getTopTerms().length + "'>\n");
        for (TermInfo termInfo : indexInfo.getTopTerms()) {
            bufferedWriter.write("  <term field='" + termInfo.term.field() + "' text='" + termInfo.term.text() + "' docFreq='" + termInfo.docFreq + "'/>\n");
        }
        bufferedWriter.write(" </topTerms>\n");
        bufferedWriter.write("</info>\n");
    }

    public boolean isRunning() {
        return this.running;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: XMLExporter <indexPath> <outputFile> [-gzip] [-onlyInfo] [-range ..expr..]");
            System.err.println("\tindexPath\tname of the directory containing the index");
            System.err.println("\toutputFile\toutput file, or '-' for System.out");
            System.err.println("\tgzip\tcompress output using gzip compression");
            System.err.println("\tonlyInfo\texport only the overall information about the index");
            System.err.println("\trange\tspecify ranges of documents to export. Expressions cannot contain whitespace!");
            System.err.println("\t\tExample: 0-5,15,32-100,101,103,105-500");
            System.exit(-1);
        }
        if (!IndexReader.indexExists(stringArray[0])) {
            throw new Exception("There is no valid Lucene index here: '" + stringArray[0] + "'");
        }
        File file = null;
        if (!stringArray[1].equals("-")) {
            file = new File(stringArray[1]);
        }
        if (file != null && file.exists()) {
            throw new Exception("Output file already exists: '" + file.getAbsolutePath() + "'");
        }
        boolean bl = false;
        Ranges ranges = null;
        boolean bl2 = false;
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-gzip")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-range")) {
                ranges = Ranges.parse(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-onlyInfo")) {
                bl2 = true;
                continue;
            }
            throw new Exception("Unknown argument: '" + stringArray[i] + "'");
        }
        IndexReader indexReader = IndexReader.open(stringArray[0]);
        XMLExporter xMLExporter = new XMLExporter(indexReader, stringArray[0]);
        OutputStream outputStream = file == null ? System.out : new FileOutputStream(file);
        if (bl) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        if (bl2) {
            ranges = new Ranges();
        }
        xMLExporter.export(outputStream, false, true, "index", ranges);
        outputStream.flush();
        outputStream.close();
        System.exit(0);
    }
}

