/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Searcher;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class CustomSimilarity
extends DefaultSimilarity {
    private static final int M_A_COORD = 0;
    private static final int M_A_IDF = 1;
    private static final int M_A_LENGTHNORM = 2;
    private static final int M_A_QUERYNORM = 3;
    private static final int M_A_SLOPPYFREQ = 4;
    private static final int M_A_TF = 5;
    private static final int M_A_MAX = 6;
    private static final int M_IDF_CS = 0;
    private static final int M_IDF_TS = 1;
    private static final int M_TF_I = 2;
    private static final int M_MAX = 3;
    private String[] abstractIds = new String[]{"coord", "idf", "lengthNorm", "queryNorm", "sloppyFreq", "tf"};
    private String[] otherIds = new String[]{"idf_cs", "idf_ts", "tf_i"};
    private Function[] abstractMethods = new Function[6];
    private Function[] otherMethods = new Function[3];
    private ScriptableObject scope = null;
    private Context cx = null;

    public CustomSimilarity(Context context, ScriptableObject scriptableObject, PrintStream printStream) throws Exception {
        Object object;
        int n;
        this.scope = scriptableObject;
        this.cx = context;
        for (n = 0; n < this.abstractIds.length; ++n) {
            block8: {
                block7: {
                    object = scriptableObject.get(this.abstractIds[n], (Scriptable)scriptableObject);
                    if (object == null) break block7;
                    if (object != context.getUndefinedValue() && object != Scriptable.NOT_FOUND) break block8;
                }
                throw new Exception("Required abstract method '" + this.abstractIds[n] + "' is missing.");
            }
            if (!(object instanceof Function)) {
                throw new Exception("Symbol '" + this.abstractIds[n] + "' is not a function.");
            }
            this.abstractMethods[n] = (Function)object;
        }
        for (n = 0; n < this.otherIds.length; ++n) {
            object = scriptableObject.get(this.otherIds[n], (Scriptable)scriptableObject);
            if (object == null) continue;
            if (object == context.getUndefinedValue() || object == Scriptable.NOT_FOUND) continue;
            if (!(object instanceof Function)) {
                throw new Exception("Symbol '" + this.otherIds[n] + "' is not a function, but'" + object + "'");
            }
            this.otherMethods[n] = (Function)object;
        }
        scriptableObject.defineFunctionProperties(new String[]{"print"}, CustomSimilarity.class, 2);
        ScriptableObject.putProperty((Scriptable)scriptableObject, "stdout", (Object)printStream);
    }

    public static void print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = scriptable.get("stdout", scriptable);
        if (object == null || !(object instanceof PrintStream)) {
            return;
        }
        PrintStream printStream = (PrintStream)object;
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                printStream.print(" ");
            }
            String string = Context.toString(objectArray[i]);
            printStream.print(string);
        }
        printStream.println();
    }

    public void destroy() {
        CustomSimilarity customSimilarity = this;
        customSimilarity.cx.exit();
    }

    public float coord(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        Object object = this.abstractMethods[0].call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public float idf(Collection collection, Searcher searcher) throws IOException {
        Function function = this.otherMethods[0];
        if (function == null) {
            return super.idf(collection, searcher);
        }
        Object[] objectArray = new Object[]{collection, searcher};
        Object object = function.call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public float idf(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        Object object = this.abstractMethods[1].call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public float idf(Term term, Searcher searcher) throws IOException {
        Function function = this.otherMethods[1];
        if (function == null) {
            return super.idf(term, searcher);
        }
        Object[] objectArray = new Object[]{term, searcher};
        Object object = function.call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public float lengthNorm(String string, int n) {
        Object[] objectArray = new Object[]{string, new Integer(n)};
        Object object = this.abstractMethods[2].call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public float queryNorm(float f) {
        Object[] objectArray = new Object[]{new Float(f)};
        Object object = this.abstractMethods[3].call(this.cx, this.scope, this.scope, objectArray);
        float f2 = 0.0f;
        try {
            f2 = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f2;
    }

    public float sloppyFreq(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        Object object = this.abstractMethods[4].call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public float tf(float f) {
        Object[] objectArray = new Object[]{new Float(f)};
        Object object = this.abstractMethods[5].call(this.cx, this.scope, this.scope, objectArray);
        float f2 = 0.0f;
        try {
            f2 = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f2;
    }

    public float tf(int n) {
        Function function = this.otherMethods[2];
        if (function == null) {
            return super.tf(n);
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        Object object = function.call(this.cx, this.scope, this.scope, objectArray);
        float f = 0.0f;
        try {
            f = Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }
}

