/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.plugins.Shell;
import org.getopt.luke.plugins.TAWriter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptingPlugin
extends LukePlugin {
    private Shell shell = null;
    private StringBuffer scroll = new StringBuffer();

    public void reset() {
        if (this.shell != null) {
            this.shell.destroy();
        }
        Object object = this.app.find(this.myUi, "console");
        this.app.setString(object, "text", "");
        this.scroll.setLength(0);
        StringWriter stringWriter = new StringWriter();
        TAWriter tAWriter = new TAWriter(this.app, object, this.scroll, stringWriter);
        try {
            this.shell = new Shell(tAWriter, tAWriter, System.in);
            ScriptableObject.putProperty((Scriptable)this.shell, "app", (Object)this.app);
            ScriptableObject.putProperty((Scriptable)this.shell, "ir", (Object)this.ir);
            ScriptableObject.putProperty((Scriptable)this.shell, "dir", (Object)this.dir);
            ScriptableObject.putProperty((Scriptable)this.shell, "myUi", this.myUi);
            this.shell.prompt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.app.errorMsg("Error initializing Shell:\n" + exception.getMessage());
        }
    }

    public void clear() {
        this.scroll.setLength(0);
        this.scroll.append("js> ");
        Object object = this.app.find(this.myUi, "console");
        this.app.setString(object, "text", this.scroll.toString());
        this.app.requestFocus(object);
        this.app.setInteger(object, "start", this.scroll.length());
        this.app.setInteger(object, "end", this.scroll.length());
    }

    public String getXULName() {
        return "/xml/scr-plugin.xml";
    }

    public String getPluginName() {
        return "Scripting Luke";
    }

    public String getPluginInfo() {
        return "Luke Scripting Plugin; by Andrzej Bialecki";
    }

    public String getPluginHome() {
        return "mailto:ab@getopt.org";
    }

    public boolean init() throws Exception {
        if (this.shell == null) {
            this.reset();
        }
        ScriptableObject.putProperty((Scriptable)this.shell, "app", (Object)this.app);
        ScriptableObject.putProperty((Scriptable)this.shell, "ir", (Object)this.ir);
        ScriptableObject.putProperty((Scriptable)this.shell, "dir", (Object)this.dir);
        ScriptableObject.putProperty((Scriptable)this.shell, "myUi", this.myUi);
        return true;
    }

    public void setWrap(Object object, Object object2) {
        this.app.setBoolean(object2, "wrap", this.app.getBoolean(object, "selected"));
    }

    public void execute(String string) {
        this.scroll.append(string);
        if (!string.endsWith("\n")) {
            this.scroll.append("\n");
        }
        this.shell.processSource(this.shell.getContext(), string.trim());
        Object object = this.app.find(this.myUi, "console");
        this.app.requestFocus(object);
        this.app.setInteger(object, "start", this.scroll.length());
        this.app.setInteger(object, "end", this.scroll.length());
    }

    public void ins(Object object) {
        String string = this.app.getString(object, "text");
        if (!string.substring(0, this.scroll.length()).equals(this.scroll.toString())) {
            string = this.scroll.toString() + string.substring(this.scroll.length() + 1);
            this.app.setString(object, "text", string);
            this.app.setInteger(object, "start", string.length());
            this.app.setInteger(object, "end", string.length());
        }
        String string2 = string.substring(this.scroll.length());
        int n = string2.indexOf(10);
        if (string2.endsWith("\n") && this.shell.getContext().stringIsCompilableUnit(string2)) {
            this.execute(string2);
        }
    }

    public void rem(Object object) {
        int n = this.app.getInteger(object, "start");
        if (n < this.scroll.length()) {
            this.app.setString(object, "text", this.scroll.toString());
            this.app.setInteger(object, "start", this.scroll.length());
            this.app.setInteger(object, "end", this.scroll.length());
        }
    }

    public void car(Object object) {
        int n = this.app.getInteger(object, "start");
        if (n < this.scroll.length()) {
            this.app.setInteger(object, "start", this.scroll.length());
            this.app.setInteger(object, "end", this.scroll.length());
        }
    }

    public void actionHelp(Object object) {
        String string = "help()\n";
        this.execute(string);
    }

    public void actionSample() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/xml/SampleScript.js");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
            this.execute(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.app.errorMsg("Loading failed: " + exception.getMessage());
            return;
        }
    }
}

