/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

public class Shell
extends ImporterTopLevel {
    private PrintWriter stdout = null;
    private PrintWriter stderr = null;
    private InputStream stdin = null;
    private boolean quitting;

    public Shell(PrintWriter printWriter, PrintWriter printWriter2, InputStream inputStream) {
        this.stdin = inputStream;
        this.stderr = printWriter2;
        this.stdout = printWriter;
        String[] stringArray = new String[]{"print", "quit", "version", "load", "help"};
        this.defineFunctionProperties(stringArray, Shell.class, 2);
        Shell.putProperty((Scriptable)this, "stdout", (Object)printWriter);
        Shell.putProperty((Scriptable)this, "stderr", (Object)printWriter2);
        Shell.putProperty((Scriptable)this, "stdin", (Object)inputStream);
        printWriter2.println(Context.enter().getImplementationVersion());
        Context.exit();
    }

    public void destroy() {
        Context.exit();
    }

    public String getClassName() {
        return "global";
    }

    public void help() {
        this.p("");
        this.p("Object                 Description");
        this.p("=======                ===========");
        this.p("app                    current Luke instance.");
        this.p("dir                    currently open Directory.");
        this.p("ir                     currently open IndexReader.");
        this.p("myUi                   this plugin's UI object.");
        this.p("");
        this.p("Command                Description");
        this.p("=======                ===========");
        this.p("defineClass(className) Define an extension using the Java class");
        this.p("                       named with the string argument. ");
        this.p("                       Uses ScriptableObject.defineClass(). ");
        this.p("load(['foo.js', ...])  Load JavaScript source files named by ");
        this.p("                       string arguments. ");
        this.p("loadClass(className)   Load a class named by a string argument.");
        this.p("                       The class must be a script compiled to a");
        this.p("                       class file. ");
        this.p("print([expr ...])      Evaluate and print expressions. ");
        this.p("version([number])      Get or set the JavaScript version number.");
    }

    public static void print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = scriptable.get("stdout", scriptable);
        if (object == null || object == Scriptable.NOT_FOUND) {
            return;
        }
        PrintWriter printWriter = (PrintWriter)object;
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                printWriter.print(" ");
            }
            String string = Context.toString(objectArray[i]);
            printWriter.print(string);
        }
        printWriter.println();
    }

    public void quit() {
        this.quitting = true;
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            double d2 = Context.toNumber(objectArray[0]);
            context.setLanguageVersion((int)d2);
        }
        return d;
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Shell shell = (Shell)Shell.getTopLevelScope(scriptable);
        for (int i = 0; i < objectArray.length; ++i) {
            shell.processSource(context, new File(Context.toString(objectArray[i])));
        }
    }

    public void prompt() {
        this.stderr.print("js> ");
        this.stderr.flush();
    }

    public Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            context = Context.enter();
            context.initStandardObjects(this);
            context.setLanguageVersion(120);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSource(Context context, File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.stderr.println("ERROR: Couldn't open file \"" + file + "\".");
            return;
        }
        try {
            context.evaluateReader(this, fileReader, file.toString(), 1, null);
        }
        catch (WrappedException wrappedException) {
            this.stderr.println(wrappedException.getWrappedException().toString());
            wrappedException.printStackTrace();
        }
        catch (EvaluatorException evaluatorException) {
            this.stderr.println("js: " + evaluatorException.getMessage());
        }
        catch (JavaScriptException javaScriptException) {
            this.stderr.println("js: " + javaScriptException.getMessage());
        }
        catch (IOException iOException) {
            this.stderr.println(iOException.toString());
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                this.stderr.println(iOException.toString());
            }
        }
        System.gc();
    }

    public void processSource(Context context, String string) {
        try {
            Object object = context.evaluateString(this, string, "<stdin>", 0, null);
            if (object != context.getUndefinedValue()) {
                this.stderr.println(Context.toString(object));
            }
        }
        catch (WrappedException wrappedException) {
            this.stderr.println(wrappedException.getWrappedException().toString());
            wrappedException.printStackTrace();
        }
        catch (EvaluatorException evaluatorException) {
            this.stderr.println("js: " + evaluatorException.getMessage());
        }
        catch (Exception exception) {
            this.stderr.println("js: " + exception.getMessage());
        }
        this.prompt();
        System.gc();
    }

    private void p(String string) {
        this.stdout.println(string);
    }
}

