/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.plugins.CustomSimilarity;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class SimilarityDesignerPlugin
extends LukePlugin {
    private CustomSimilarity similarity = null;
    private JFileChooser fd = new JFileChooser();

    public SimilarityDesignerPlugin() throws Exception {
        this.fd.setFileSelectionMode(0);
        this.fd.setFileHidingEnabled(false);
        this.fd.setCurrentDirectory(new File(System.getProperty("user.dir")));
    }

    public String getXULName() {
        return "/xml/sd-plugin.xml";
    }

    public String getPluginName() {
        return "Custom Similarity";
    }

    public String getPluginInfo() {
        return "Custom Similarity Designer; by Andrzej Bialecki";
    }

    public String getPluginHome() {
        return "mailto:ab@getopt.org";
    }

    public boolean init() throws Exception {
        if (this.similarity != null) {
            this.app.setCustomSimilarity(this.similarity);
        }
        return true;
    }

    public void actionLoadSample(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.app.getString(object, "text");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/xml/" + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            bufferedReader.close();
            Object object2 = this.app.find(this.myUi, "simText");
            this.app.setString(object2, "text", stringBuffer.toString());
            this.actionCompileSimilarity();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.app.errorMsg("Loading failed: " + exception.getMessage());
            return;
        }
    }

    public void actionNew() {
        Object object = this.app.find(this.myUi, "simText");
        this.app.setString(object, "text", "");
        this.invalidate();
    }

    public void invalidate() {
        this.app.setCustomSimilarity(null);
        Object object = this.app.find(this.myUi, "simStatus");
        this.app.setString(object, "text", "Needs Compile");
        this.app.setColor(object, "foreground", Color.red);
    }

    public void actionCompileSimilarity() {
        Object object = this.app.find(this.myUi, "simText");
        String string = this.app.getString(object, "text");
        Object object2 = this.app.find(this.myUi, "cbCompInt");
        int n = this.app.getBoolean(object2, "selected") ? -1 : 9;
        Context context = Context.enter();
        context.setOptimizationLevel(n);
        PrintStream printStream = null;
        Object object3 = this.app.find(this.myUi, "selOutput");
        String string2 = this.app.getString(object3, "text");
        if (string2.equals("System.out")) {
            printStream = System.out;
        } else if (string2.equals("System.err")) {
            printStream = System.err;
        }
        Object object4 = this.app.find(this.myUi, "simStatus");
        try {
            ScriptableObject scriptableObject = context.initStandardObjects();
            context.evaluateString(scriptableObject, string, "<cmd>", 1, null);
            if (this.similarity != null) {
                this.similarity.destroy();
            }
            this.similarity = new CustomSimilarity(context, scriptableObject, printStream);
            this.app.setCustomSimilarity(this.similarity);
            this.app.setString(object4, "text", "OK");
            this.app.setColor(object4, "foreground", Color.green);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.app.setCustomSimilarity(null);
            this.app.setString(object4, "text", "ERROR");
            this.app.setColor(object4, "foreground", Color.red);
            this.app.errorMsg("Compile failed:\n" + exception.getMessage());
        }
    }

    public void actionSaveFile() {
        this.fd.setDialogType(1);
        this.fd.setDialogTitle("Select Output File");
        int n = this.fd.showOpenDialog(this.app);
        File file = null;
        if (n == 0) {
            file = this.fd.getSelectedFile();
        }
        if (file == null || file.isDirectory()) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Object object = this.app.find(this.myUi, "simText");
            String string = this.app.getString(object, "text");
            fileOutputStream.write(string.getBytes("UTF-8"));
            fileOutputStream.flush();
            fileOutputStream.close();
            this.app.showStatus("Saved OK.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.app.errorMsg("Could not save '" + file.toString() + ": " + exception.getMessage());
            return;
        }
    }

    public void actionOpenFile() {
        this.fd.setDialogType(0);
        this.fd.setDialogTitle("Select Input File");
        int n = this.fd.showOpenDialog(this.app);
        File file = null;
        if (n == 0) {
            file = this.fd.getSelectedFile();
        }
        if (file == null || file.isDirectory()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
            Object object = this.app.find(this.myUi, "simText");
            this.app.setString(object, "text", stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.app.errorMsg("Could not open '" + file.toString() + ": " + exception.getMessage());
            return;
        }
    }
}

