/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.plugins.VocabChart;
import thinlet.Thinlet;

public class VocabAnalysisPlugin
extends LukePlugin {
    VocabChart chart = null;
    String selectedField;

    public String getXULName() {
        return "/xml/vocab-plugin.xml";
    }

    public String getPluginName() {
        return "Vocabulary Analysis Tool";
    }

    public String getPluginInfo() {
        return "Tool for showing index's vocabulary growth, by Mark Harwood";
    }

    public String getPluginHome() {
        return "mailto:mharwood@apache.org";
    }

    public void setMyUi(Object object) {
        super.setMyUi(object);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean init() throws Exception {
        Object object = this.app.find(this.myUi, "fields");
        this.app.removeAll(object);
        Object object2 = this.app.find(this.myUi, "maxdoc");
        this.app.setString(object2, "text", "");
        Object object3 = this.app.find(this.myUi, "middoc");
        this.app.setString(object3, "text", "");
        Object object4 = this.app.find(this.myUi, "vocabchart");
        Object object5 = this.app.getParent(object4);
        this.chart = new VocabChart(this.app, object5);
        IndexReader indexReader = this.getIndexReader();
        if (indexReader != null) {
            Collection collection = indexReader.getFieldNames(IndexReader.FieldOption.INDEXED);
            String string = null;
            for (String string2 : collection) {
                if (string == null) {
                    string = string2;
                }
                Object object6 = Thinlet.create("choice");
                this.app.setString(object6, "text", string2);
                this.app.add(object, object6);
            }
            this.app.setInteger(object, "selected", 0);
            this.app.setString(object, "text", string);
            this.app.setComponent(object4, "bean", this.chart);
            this.app.setString(object2, "text", indexReader.maxDoc() + "");
            this.app.setString(object3, "text", indexReader.maxDoc() / 2 + "");
        }
        return true;
    }

    public void cleanChart() {
        this.chart.setScores(null);
        this.chart.invalidate();
        this.app.repaint();
    }

    public void analyze() {
        Object object = this.app.find(this.myUi, "fields");
        String string = this.app.getString(object, "text");
        Object object2 = this.app.find(this.myUi, "cumul");
        boolean bl = this.app.getBoolean(object2, "selected");
        IndexReader indexReader = this.getIndexReader();
        if (indexReader == null) {
            this.app.showStatus("No index loaded");
            this.cleanChart();
            return;
        }
        try {
            int n;
            float f;
            int n2 = 100;
            float f2 = indexReader.maxDoc();
            if (f2 < (float)n2) {
                n2 = indexReader.maxDoc();
            }
            float[] fArray = new float[n2];
            String string2 = string.intern();
            TermEnum termEnum = indexReader.terms(new Term(string2, ""));
            Term term = termEnum.term();
            while (term != null && string2 == term.field()) {
                TermDocs termDocs = indexReader.termDocs(term);
                termDocs.next();
                f = termDocs.doc();
                int n3 = n = (int)(f / f2 * (float)n2);
                fArray[n3] = fArray[n3] + 1.0f;
                if (termEnum.next()) {
                    term = termEnum.term();
                    continue;
                }
                term = null;
            }
            float f3 = 0.0f;
            f = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                if (fArray[n] > f) {
                    f = fArray[n];
                }
                f3 += fArray[n];
                if (n <= 0 || !bl) continue;
                int n4 = n;
                fArray[n4] = fArray[n4] + fArray[n - 1];
            }
            Object object3 = this.app.find(this.myUi, "maxpct");
            if (bl) {
                this.app.setString(object3, "text", "100 %");
            } else {
                this.app.setString(object3, "text", (float)Math.round(f * 10000.0f / f3) / 100.0f + " %");
            }
            this.chart.setScores(fArray);
            this.chart.invalidate();
            this.app.repaint();
        }
        catch (Exception exception) {
            this.app.showStatus("ERROR: " + exception.getMessage());
        }
    }

    public String getSelectedField() {
        return this.selectedField;
    }

    public void setSelectedField(String string) {
        this.selectedField = string;
    }
}

