/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import org.getopt.luke.Luke;

public class VocabChart
extends Component {
    Image offScrImg = null;
    int offScrWidth;
    int offScrHeight;
    private float[] scores;
    private int xBorder = 2;
    private int yBorder = 2;
    private int minRowHeight = 20;
    float max = 0.0f;
    float total = 0.0f;
    Luke app = null;
    Object container = null;

    public VocabChart() {
    }

    public VocabChart(Luke luke, Object object) {
        this.app = luke;
        this.container = object;
    }

    public Dimension getPreferredSize() {
        if (this.app == null) {
            return new Dimension(500, 300);
        }
        return this.app.getSize(this.container, 2, 2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.offScrWidth = dimension.width;
        this.offScrHeight = dimension.height;
        int n = this.offScrWidth - this.xBorder * 2;
        int n2 = this.offScrHeight - this.yBorder * 2;
        Graphics graphics2 = graphics;
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.scores == null) {
            return;
        }
        int n3 = 1;
        while (this.scores.length > n * n3 && n3 * this.yBorder + n3 * this.minRowHeight < n2) {
            ++n3;
        }
        int n4 = n2 / n3 - this.yBorder;
        float f = this.xBorder;
        float f2 = this.yBorder + n4;
        float f3 = (float)(n3 * n) / (float)this.scores.length;
        int n5 = Math.max(1, (int)f3 - 1);
        f = this.xBorder;
        f2 = this.yBorder + n4;
        for (int i = 0; i < this.scores.length; ++i) {
            int n6;
            graphics2.setColor(Color.BLUE);
            if (this.scores[i] > 0.0f) {
                n6 = (int)((float)n4 * (this.scores[i] / this.max));
                graphics2.fillRect((int)f, (int)f2 - n6, n5, n6);
            }
            graphics2.setColor(Color.BLACK);
            n6 = 2;
            if (i % 5 == 0) {
                n6 = 4;
            }
            graphics2.drawLine((int)f, (int)f2, (int)f, (int)f2 + n6);
            f += f3;
            if (!(f > (float)n)) continue;
            f = this.xBorder;
            f2 += (float)(n4 + this.yBorder);
        }
    }

    public int getMinRowHeight() {
        return this.minRowHeight;
    }

    public void setMinRowHeight(int n) {
        this.minRowHeight = n;
    }

    public float[] getScores() {
        return this.scores;
    }

    public void setScores(float[] fArray) {
        this.scores = fArray;
        this.max = 0.0f;
        this.total = 0.0f;
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                this.max = Math.max(fArray[i], this.max);
                this.total += fArray[i];
            }
        }
    }

    public int getXBorder() {
        return this.xBorder;
    }

    public void setXBorder(int n) {
        this.xBorder = n;
    }

    public int getYBorder() {
        return this.yBorder;
    }

    public void setYBorder(int n) {
        this.yBorder = n;
    }
}

