/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.plugins.VocabChart;
import thinlet.Thinlet;

public class ZipfAnalysisPlugin
extends LukePlugin {
    VocabChart chart = null;
    String selectedField;

    public String getXULName() {
        return "/xml/zipf-plugin.xml";
    }

    public String getPluginName() {
        return "Zipf distributions";
    }

    public String getPluginInfo() {
        return "Tool for showing term popularity distributions, by Mark Harwood";
    }

    public String getPluginHome() {
        return "mailto:mharwood@apache.org";
    }

    public void setMyUi(Object object) {
        super.setMyUi(object);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean init() throws Exception {
        Object object = this.app.find(this.myUi, "fields");
        this.app.removeAll(object);
        Object object2 = this.app.find(this.myUi, "vocabchart");
        Object object3 = this.app.getParent(object2);
        this.chart = new VocabChart(this.app, object3);
        this.app.setComponent(object2, "bean", this.chart);
        IndexReader indexReader = this.getIndexReader();
        if (indexReader != null) {
            Collection collection = indexReader.getFieldNames(IndexReader.FieldOption.INDEXED);
            String string = null;
            for (String string2 : collection) {
                if (string == null) {
                    string = string2;
                }
                Object object4 = Thinlet.create("choice");
                this.app.setString(object4, "text", string2);
                this.app.add(object, object4);
            }
            this.app.setInteger(object, "selected", 0);
            this.app.setString(object, "text", string);
        }
        return true;
    }

    public void cleanChart() {
        this.chart.setScores(null);
        this.chart.invalidate();
        this.app.repaint();
    }

    public void analyze() {
        Object object = this.app.find(this.myUi, "fields");
        String string = this.app.getString(object, "text");
        IndexReader indexReader = this.getIndexReader();
        if (indexReader == null) {
            this.app.showStatus("No index loaded");
            this.cleanChart();
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            Object[] objectArray;
            Term term = new Term(string, "");
            int n5 = 100;
            TermEnum termEnum = indexReader.terms(term);
            ArrayList<TermCount> arrayList = new ArrayList<TermCount>();
            int n6 = 1;
            int n7 = 1000;
            int[] nArray = new int[n7 - n6 + 1];
            int n8 = 0;
            while (termEnum.next() && (objectArray = termEnum.term()).field() == term.field()) {
                ++n8;
                n4 = termEnum.docFreq();
                if (n4 <= n7) {
                    int n9;
                    int n10 = n9 = n4 - n6;
                    nArray[n10] = nArray[n10] + 1;
                    continue;
                }
                arrayList.add(new TermCount((Term)objectArray, n4));
            }
            objectArray = arrayList.toArray(new TermCount[arrayList.size()]);
            Arrays.sort(objectArray);
            if (n8 < 100) {
                n4 = 1;
                n5 = n8;
            } else {
                n4 = n8 / n5;
            }
            ArrayList<Bucket> arrayList2 = new ArrayList<Bucket>();
            Bucket bucket = new Bucket();
            arrayList2.add(bucket);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                bucket.addTermDf(((TermCount)objectArray[n3]).df);
                if (bucket.numTermsInThisBucket < n4) continue;
                bucket = new Bucket();
                arrayList2.add(bucket);
            }
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                int n11 = n3 + n6;
                n2 = nArray[n3];
                for (n = 0; n < n2; ++n) {
                    bucket.addTermDf(n11);
                    if (bucket.numTermsInThisBucket < n4) continue;
                    bucket = new Bucket();
                    arrayList2.add(bucket);
                }
            }
            if (bucket.numTermsInThisBucket == 0) {
                arrayList2.remove(bucket);
            }
            Bucket[] bucketArray = arrayList2.toArray(new Bucket[arrayList2.size()]);
            float[] fArray = new float[bucketArray.length];
            n2 = 0;
            for (n = 0; n < bucketArray.length; ++n) {
                fArray[n] = bucketArray[n].getAverageDf();
                n2 = (int)Math.max((float)n2, fArray[n]);
            }
            Object object2 = this.app.find(this.myUi, "maxdf");
            this.app.setString(object2, "text", "" + n2);
            Object object3 = this.app.find(this.myUi, "maxterm");
            Object object4 = this.app.find(this.myUi, "midterm");
            this.app.setString(object3, "text", n8 + "");
            this.app.setString(object4, "text", n8 / 2 + "");
            this.chart.setScores(fArray);
            this.chart.invalidate();
            this.app.repaint();
        }
        catch (Exception exception) {
            this.app.showStatus("ERROR: " + exception.getMessage());
        }
    }

    public String getSelectedField() {
        return this.selectedField;
    }

    public void setSelectedField(String string) {
        this.selectedField = string;
    }

    static class TermCount
    implements Comparable {
        int df = 0;
        int termCount = 0;
        private Term term;

        public TermCount(Term term, int n) {
            this.term = term;
            this.df = n;
        }

        public int compareTo(Object object) {
            TermCount termCount = (TermCount)object;
            if (this.df > termCount.df) {
                return -1;
            }
            if (this.df < termCount.df) {
                return 1;
            }
            return 0;
        }
    }

    static class Bucket {
        int maxDf;
        int minDf = Integer.MAX_VALUE;
        int totalDf;
        int numTermsInThisBucket;

        Bucket() {
        }

        public void addTermDf(int n) {
            this.totalDf += n;
            ++this.numTermsInThisBucket;
            this.maxDf = Math.max(n, this.maxDf);
            this.minDf = Math.min(n, this.minDf);
        }

        public int getAverageDf() {
            if (this.numTermsInThisBucket == 0) {
                return 0;
            }
            return this.totalDf / this.numTermsInThisBucket;
        }

        public String toString() {
            return this.maxDf + " maxDf in " + this.numTermsInThisBucket + " terms";
        }
    }
}

