/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter
implements Cloneable,
Callable {
    private Function function;
    private Class nonPrimitiveResultClass;
    private int[] argsToConvert;

    public static InterfaceAdapter create(Class clazz, Function function) {
        ClassCache classCache = ClassCache.get(function);
        InterfaceAdapter interfaceAdapter = (InterfaceAdapter)classCache.getInterfaceAdapter(clazz);
        if (interfaceAdapter == null) {
            Object[] objectArray;
            if (!clazz.isInterface()) {
                return null;
            }
            Method[] methodArray = clazz.getMethods();
            if (methodArray.length == 0) {
                return null;
            }
            Class<?> clazz2 = methodArray[0].getReturnType();
            Class[] classArray = methodArray[0].getParameterTypes();
            for (int i = 1; i != methodArray.length; ++i) {
                if (clazz2 != methodArray[i].getReturnType()) {
                    return null;
                }
                objectArray = methodArray[i].getParameterTypes();
                if (objectArray.length != classArray.length) {
                    return null;
                }
                for (int j = 0; j != classArray.length; ++j) {
                    if (objectArray[j] == classArray[j]) continue;
                    return null;
                }
            }
            String string = "iadapter" + classCache.newClassSerialNumber();
            objectArray = InterfaceAdapter.createCode(clazz, methodArray, clazz2, classArray, string);
            Class clazz3 = JavaAdapter.loadAdapterClass(string, objectArray);
            try {
                interfaceAdapter = (InterfaceAdapter)clazz3.newInstance();
            }
            catch (Exception exception) {
                throw Context.throwAsScriptRuntimeEx(exception);
            }
            interfaceAdapter.initMaster(clazz2, classArray);
            classCache.cacheInterfaceAdapter(clazz, interfaceAdapter);
        }
        return interfaceAdapter.wrap(function);
    }

    private static byte[] createCode(Class clazz, Method[] methodArray, Class clazz2, Class[] classArray, String string) {
        String string2 = "org.mozilla.javascript.InterfaceAdapter";
        ClassFileWriter classFileWriter = new ClassFileWriter(string, string2, "<ifglue>");
        classFileWriter.addInterface(clazz.getName());
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.add(42);
        classFileWriter.addInvoke(183, string2, "<init>", "()V");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
        for (int i = 0; i != methodArray.length; ++i) {
            Method method = methodArray[i];
            StringBuffer stringBuffer = new StringBuffer();
            int n = JavaAdapter.appendMethodSignature(classArray, clazz2, stringBuffer);
            String string3 = stringBuffer.toString();
            classFileWriter.startMethod(method.getName(), string3, (short)1);
            classFileWriter.addLoadThis();
            JavaAdapter.generatePushWrappedArgs(classFileWriter, classArray, classArray.length + 1);
            classFileWriter.add(89);
            classFileWriter.addPush(classArray.length);
            classFileWriter.addPush(method.getName());
            classFileWriter.add(83);
            classFileWriter.addInvoke(183, string2, "doCall", "([Ljava/lang/Object;)Ljava/lang/Object;");
            JavaAdapter.generateReturnResult(classFileWriter, clazz2, false);
            classFileWriter.stopMethod((short)n);
        }
        return classFileWriter.toByteArray();
    }

    private void initMaster(Class clazz, Class[] classArray) {
        if (this.function != null) {
            Kit.codeBug();
        }
        if (!clazz.isPrimitive()) {
            this.nonPrimitiveResultClass = clazz;
        }
        this.argsToConvert = JavaAdapter.getArgsToConvert(classArray);
    }

    private InterfaceAdapter wrap(Function function) {
        InterfaceAdapter interfaceAdapter;
        if (function == null) {
            Kit.codeBug();
        }
        if (this.function != null) {
            Kit.codeBug();
        }
        try {
            interfaceAdapter = (InterfaceAdapter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            interfaceAdapter = null;
        }
        interfaceAdapter.function = function;
        return interfaceAdapter;
    }

    protected final Object doCall(Object[] objectArray) {
        Scriptable scriptable;
        Scriptable scriptable2 = scriptable = this.function.getParentScope();
        Object object = Context.call(null, this, scriptable, scriptable2, objectArray);
        if (this.nonPrimitiveResultClass != null) {
            object = object == Undefined.instance ? null : NativeJavaObject.coerceType(this.nonPrimitiveResultClass, object, true);
        }
        return object;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (this.argsToConvert != null) {
            WrapFactory wrapFactory = context.getWrapFactory();
            int n = this.argsToConvert.length;
            for (int i = 0; i != n; ++i) {
                int n2 = this.argsToConvert[i];
                Object object = objectArray[n2];
                if (object == null || object instanceof Scriptable) continue;
                objectArray[n2] = wrapFactory.wrap(context, scriptable, object, null);
            }
        }
        return this.function.call(context, scriptable, scriptable2, objectArray);
    }
}

