/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int Icode_DUP = -1;
    private static final int Icode_DUP2 = -2;
    private static final int Icode_SWAP = -3;
    private static final int Icode_POP = -4;
    private static final int Icode_POP_RESULT = -5;
    private static final int Icode_IFEQ_POP = -6;
    private static final int Icode_VAR_INC_DEC = -7;
    private static final int Icode_NAME_INC_DEC = -8;
    private static final int Icode_PROP_INC_DEC = -9;
    private static final int Icode_ELEM_INC_DEC = -10;
    private static final int Icode_REF_INC_DEC = -11;
    private static final int Icode_SCOPE = -12;
    private static final int Icode_SCOPE_LOAD = -13;
    private static final int Icode_SCOPE_SAVE = -14;
    private static final int Icode_TYPEOFNAME = -15;
    private static final int Icode_NAME_AND_THIS = -16;
    private static final int Icode_PROP_AND_THIS = -17;
    private static final int Icode_ELEM_AND_THIS = -18;
    private static final int Icode_VALUE_AND_THIS = -19;
    private static final int Icode_CLOSURE_EXPR = -20;
    private static final int Icode_CLOSURE_STMT = -21;
    private static final int Icode_CALLSPECIAL = -22;
    private static final int Icode_RETUNDEF = -23;
    private static final int Icode_GOSUB = -24;
    private static final int Icode_STARTSUB = -25;
    private static final int Icode_RETSUB = -26;
    private static final int Icode_LINE = -27;
    private static final int Icode_SHORTNUMBER = -28;
    private static final int Icode_INTNUMBER = -29;
    private static final int Icode_LITERAL_NEW = -30;
    private static final int Icode_LITERAL_SET = -31;
    private static final int Icode_SPARE_ARRAYLIT = -32;
    private static final int Icode_REG_IND_C0 = -33;
    private static final int Icode_REG_IND_C1 = -34;
    private static final int Icode_REG_IND_C2 = -35;
    private static final int Icode_REG_IND_C3 = -36;
    private static final int Icode_REG_IND_C4 = -37;
    private static final int Icode_REG_IND_C5 = -38;
    private static final int Icode_REG_IND1 = -39;
    private static final int Icode_REG_IND2 = -40;
    private static final int Icode_REG_IND4 = -41;
    private static final int Icode_REG_STR_C0 = -42;
    private static final int Icode_REG_STR_C1 = -43;
    private static final int Icode_REG_STR_C2 = -44;
    private static final int Icode_REG_STR_C3 = -45;
    private static final int Icode_REG_STR1 = -46;
    private static final int Icode_REG_STR2 = -47;
    private static final int Icode_REG_STR4 = -48;
    private static final int Icode_GETVAR1 = -49;
    private static final int Icode_SETVAR1 = -50;
    private static final int Icode_UNDEF = -51;
    private static final int Icode_ZERO = -52;
    private static final int Icode_ONE = -53;
    private static final int Icode_ENTERDQ = -54;
    private static final int Icode_LEAVEDQ = -55;
    private static final int Icode_TAIL_CALL = -56;
    private static final int Icode_LOCAL_CLEAR = -57;
    private static final int MIN_ICODE = -57;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsICodeTop;
    private int itsStackDepth;
    private int itsLineNumber;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private ObjArray itsLiteralIds = new ObjArray();
    private int itsExceptionTableTop;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_HANDLER_SLOT = 2;
    private static final int EXCEPTION_TYPE_SLOT = 3;
    private static final int EXCEPTION_LOCAL_SLOT = 4;
    private static final int EXCEPTION_SCOPE_SLOT = 5;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int ECF_TAIL = 1;

    private static String bytecodeName(int n) {
        if (!Interpreter.validBytecode(n)) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return String.valueOf(n);
    }

    private static boolean validIcode(int n) {
        return -57 <= n && n <= -1;
    }

    private static boolean validTokenCode(int n) {
        return 2 <= n && n <= 76;
    }

    private static boolean validBytecode(int n) {
        return Interpreter.validIcode(n) || Interpreter.validTokenCode(n);
    }

    public Object compile(CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        new NodeTransformer().transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.scriptOrFn = scriptOrFnNode;
        this.itsData = new InterpreterData(compilerEnvirons.getLanguageVersion(), this.scriptOrFn.getSourceName(), string);
        this.itsData.topLevel = true;
        if (bl) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    public Script createScriptObject(Object object, Object object2) {
        InterpreterData interpreterData = (InterpreterData)object;
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        InterpreterData interpreterData = (InterpreterData)object;
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        this.itsData.itsName = functionNode.getFunctionName();
        if (!functionNode.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node node) {
        Object object;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.visitStatement(node);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(62);
        }
        if (this.itsData.itsICode.length != this.itsICodeTop) {
            object = new byte[this.itsICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, this.itsICodeTop);
            this.itsData.itsICode = object;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            object = this.itsStrings.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string = (String)((ObjToIntMap.Iterator)object).getKey();
                int n = ((ObjToIntMap.Iterator)object).getValue();
                if (this.itsData.itsStringTable[n] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n] = string;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            object = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = (double[])object;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            object = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.itsLiteralIds.size() != 0) {
            this.itsData.literalIds = this.itsLiteralIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(i);
            Interpreter interpreter = new Interpreter();
            interpreter.compilerEnv = this.compilerEnv;
            interpreter.scriptOrFn = functionNode;
            interpreter.itsData = new InterpreterData(this.itsData);
            interpreter.generateFunctionICode();
            interpreterDataArray[i] = interpreter.itsData;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String string2 = this.scriptOrFn.getRegexpFlags(i);
            objectArray[i] = regExpProxy.compileRegExp(context, string, string2);
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private void updateLineNumber(Node node) {
        int n = node.getLineno();
        if (n != this.itsLineNumber && n >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = n;
            }
            this.itsLineNumber = n;
            this.addIcode(-27);
            this.addUint16(n & 0xFFFF);
        }
    }

    private RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node) {
        int n = node.getType();
        switch (n) {
            case 105: {
                int n2 = node.getExistingIntProp(1);
                int n3 = this.scriptOrFn.getFunctionNode(n2).getFunctionType();
                if (n3 == 3) {
                    this.addIndexOp(-21, n2);
                    break;
                }
                if (n3 == 1) break;
                throw Kit.codeBug();
            }
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: {
                Node node2;
                this.updateLineNumber(node);
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.visitStatement(node2);
                }
                break;
            }
            case 2: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 137: {
                Node node2;
                int n4 = this.allocLocal();
                node.putIntProp(2, n4);
                this.updateLineNumber(node);
                while (node2 != null) {
                    this.visitStatement(node2);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-57, n4);
                this.releaseLocal(n4);
                break;
            }
            case 110: {
                Node node2;
                this.updateLineNumber(node);
                Node.Jump jump = (Node.Jump)node;
                this.visitExpression(node2, 0);
                for (Node.Jump jump2 = (Node.Jump)node2.getNext(); jump2 != null; jump2 = (Node.Jump)jump2.getNext()) {
                    if (jump2.getType() != 111) {
                        throw this.badTree(jump2);
                    }
                    Node node3 = jump2.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(node3, 0);
                    this.addToken(45);
                    this.stackChange(-1);
                    this.addGoto(jump2.target, -6);
                    this.stackChange(-1);
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 127: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node node2;
                Node node4 = ((Node.Jump)node).target;
                this.visitExpression(node2, 0);
                this.addGoto(node4, n);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node node5 = ((Node.Jump)node).target;
                this.addGoto(node5, n);
                break;
            }
            case 131: {
                Node node6 = ((Node.Jump)node).target;
                this.addGoto(node6, -24);
                break;
            }
            case 121: {
                Node node2;
                this.stackChange(1);
                int n5 = this.getLocalBlockRef(node);
                this.addIndexOp(-25, n5);
                this.stackChange(-1);
                while (node2 != null) {
                    this.visitStatement(node2);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-26, n5);
                break;
            }
            case 129: 
            case 130: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(n == 129 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 77: {
                Node node7;
                Node node2;
                Node.Jump jump = (Node.Jump)node;
                int n6 = this.getLocalBlockRef(jump);
                int n7 = this.allocLocal();
                this.addIndexOp(-14, n7);
                int n8 = this.itsICodeTop;
                while (node2 != null) {
                    this.visitStatement(node2);
                    node2 = node2.getNext();
                }
                Node node8 = jump.target;
                if (node8 != null) {
                    int n9 = this.itsLabelTable[this.getTargetLabel(node8)];
                    this.addExceptionHandler(n8, n9, n9, false, n6, n7);
                }
                if ((node7 = jump.getFinally()) != null) {
                    int n10 = this.itsLabelTable[this.getTargetLabel(node7)];
                    this.addExceptionHandler(n8, n10, n10, true, n6, n7);
                }
                this.addIndexOp(-57, n7);
                this.releaseLocal(n7);
                break;
            }
            case 56: {
                Node node2;
                int n11 = this.getLocalBlockRef(node);
                int n12 = node.getExistingIntProp(14);
                String string = node2.getString();
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringPrefix(string);
                this.addIndexPrefix(n11);
                this.addToken(56);
                this.addUint8(n12 != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 49: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addToken(49);
                this.addUint16(this.itsLineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 50: {
                this.updateLineNumber(node);
                this.addIndexOp(50, this.getLocalBlockRef(node));
                break;
            }
            case 4: {
                Node node2;
                this.updateLineNumber(node);
                if (node2 != null) {
                    this.visitExpression(node2, 1);
                    this.addToken(4);
                    this.stackChange(-1);
                    break;
                }
                this.addIcode(-23);
                break;
            }
            case 62: {
                this.updateLineNumber(node);
                this.addToken(62);
                break;
            }
            case 57: 
            case 58: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIndexOp(n, this.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (this.itsStackDepth != 0) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int n) {
        int n2 = node.getType();
        int n3 = this.itsStackDepth;
        int n4 = 1;
        switch (n2) {
            case 105: {
                int n5 = node.getExistingIntProp(1);
                FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n5);
                if (functionNode.getFunctionType() != 2) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-20, n5);
                this.stackChange(1);
                break;
            }
            case 53: {
                int n6 = this.getLocalBlockRef(node);
                this.addIndexOp(53, n6);
                this.stackChange(1);
                break;
            }
            case 85: {
                Node node2;
                Node node3 = node.getLastChild();
                for (node2 = node.getFirstChild(); node2 != node3; node2 = node2.getNext()) {
                    this.visitExpression(node2, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, n & 1);
                break;
            }
            case 134: {
                this.stackChange(1);
                break;
            }
            case 68: {
                n4 = 2;
            }
            case 30: 
            case 37: {
                Node node2;
                if (n2 == 30) {
                    this.visitExpression(node2, 0);
                } else {
                    this.generateCallFunAndThis(node2);
                }
                int n7 = 0;
                while ((node2 = node2.getNext()) != null) {
                    this.visitExpression(node2, 0);
                    ++n7;
                }
                int n8 = node.getIntProp(10, 0);
                if (n8 != 0) {
                    this.addIndexOp(-22, n7);
                    this.addUint8(n8);
                    this.addUint8(n2 == 30 ? 1 : 0);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                } else {
                    if (n2 == 37 && (n & 1) != 0) {
                        n2 = -56;
                    }
                    this.addIndexOp(n2, n7);
                }
                if (n2 == 30 || n2 == 68) {
                    this.stackChange(-n7);
                } else {
                    this.stackChange(-1 - n7);
                }
                if (n7 <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = n7;
                break;
            }
            case 100: 
            case 101: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int n9 = this.itsICodeTop;
                int n10 = n2 == 101 ? 7 : 6;
                this.addForwardGoto(n10);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                node2 = node2.getNext();
                this.visitExpression(node2, n & 1);
                this.resolveForwardGoto(n9);
                break;
            }
            case 98: {
                Node node2;
                Node node4 = node2.getNext();
                Node node5 = node4.getNext();
                this.visitExpression(node2, 0);
                int n11 = this.itsICodeTop;
                this.addForwardGoto(7);
                this.stackChange(-1);
                this.visitExpression(node4, n & 1);
                int n12 = this.itsICodeTop;
                this.addForwardGoto(5);
                this.resolveForwardGoto(n11);
                this.itsStackDepth = n3;
                this.visitExpression(node5, n & 1);
                this.resolveForwardGoto(n12);
                break;
            }
            case 33: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.addStringOp(33, node2.getString());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addToken(n2);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 122: {
                Node node2;
                this.visitExpression(node2, 0);
                if (n2 == 122) {
                    this.addIcode(-4);
                    this.addIcode(-51);
                    break;
                }
                this.addToken(n2);
                break;
            }
            case 65: 
            case 67: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                this.stackChange(-1);
                break;
            }
            case 34: 
            case 135: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                String string = node2.getString();
                node2 = node2.getNext();
                if (n2 == 135) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, string);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addStringOp(34, string);
                this.stackChange(-1);
                break;
            }
            case 36: 
            case 136: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 136) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(35);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(36);
                this.stackChange(-2);
                break;
            }
            case 66: 
            case 138: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 138) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(65);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(66);
                this.stackChange(-2);
                break;
            }
            case 8: {
                Node node2;
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(8, string);
                this.stackChange(-1);
                break;
            }
            case 133: {
                String string = node.getString();
                int n13 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n13 = this.scriptOrFn.getParamOrVarIndex(string);
                }
                if (n13 == -1) {
                    this.addStringOp(-15, string);
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(54, n13);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 38: 
            case 40: 
            case 48: {
                this.addStringOp(n2, node.getString());
                this.stackChange(1);
                break;
            }
            case 102: 
            case 103: {
                Node node2;
                this.visitIncDec(node, node2);
                break;
            }
            case 39: {
                double d = node.getDouble();
                int n14 = (int)d;
                if ((double)n14 == d) {
                    if (n14 == 0) {
                        this.addIcode(-52);
                        if (1.0 / d < 0.0) {
                            this.addToken(29);
                        }
                    } else if (n14 == 1) {
                        this.addIcode(-53);
                    } else if ((short)n14 == n14) {
                        this.addIcode(-28);
                        this.addUint16(n14 & 0xFFFF);
                    } else {
                        this.addIcode(-29);
                        this.addInt(n14);
                    }
                } else {
                    int n15 = this.getDoubleIndex(d);
                    this.addIndexOp(39, n15);
                }
                this.stackChange(1);
                break;
            }
            case 54: {
                String string = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    this.addIcode(-12);
                    this.stackChange(1);
                    this.addStringOp(33, string);
                    break;
                }
                int n16 = this.scriptOrFn.getParamOrVarIndex(string);
                this.addVarOp(54, n16);
                this.stackChange(1);
                break;
            }
            case 55: {
                Node node2;
                if (this.itsData.itsNeedsActivation) {
                    node2.setType(48);
                    node.setType(8);
                    this.visitExpression(node, 0);
                    break;
                }
                String string = node2.getString();
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                int n17 = this.scriptOrFn.getParamOrVarIndex(string);
                this.addVarOp(55, n17);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 61: {
                this.addToken(n2);
                this.stackChange(1);
                break;
            }
            case 59: 
            case 60: {
                this.addIndexOp(n2, this.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 47: {
                int n18 = node.getExistingIntProp(4);
                this.addIndexOp(47, n18);
                this.stackChange(1);
                break;
            }
            case 63: 
            case 64: {
                Node node2;
                this.visitLiteral(node, node2);
                break;
            }
            case 69: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addStringOp(n2, (String)node.getProp(17));
                this.stackChange(1);
                n4 = 2;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                Node node2;
                int n19 = node.getIntProp(16, 0);
                int n20 = 0;
                do {
                    this.visitExpression(node2, 0);
                    ++n20;
                } while ((node2 = node2.getNext()) != null);
                this.addIndexOp(n2, n19);
                this.stackChange(2 - n20);
                n4 = 2;
                break;
            }
            case 142: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(-54);
                this.stackChange(-1);
                int n21 = this.itsICodeTop;
                this.visitExpression(node2.getNext(), 0);
                this.addBackwardGoto(-55, n21);
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (n3 + n4 != this.itsStackDepth) {
            Kit.codeBug();
        }
    }

    private void generateCallFunAndThis(Node node) {
        int n = node.getType();
        switch (n) {
            case 38: {
                String string = node.getString();
                this.addStringOp(-16, string);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 35: {
                Node node2 = node.getFirstChild();
                this.visitExpression(node2, 0);
                Node node3 = node2.getNext();
                if (n == 33) {
                    String string = node3.getString();
                    this.addStringOp(-17, string);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(node3, 0);
                this.addIcode(-18);
                break;
            }
            default: {
                this.visitExpression(node, 0);
                this.addIcode(-19);
                this.stackChange(1);
            }
        }
    }

    private void visitIncDec(Node node, Node node2) {
        int n = node.getExistingIntProp(13);
        int n2 = node2.getType();
        switch (n2) {
            case 54: {
                String string = node2.getString();
                if (this.itsData.itsNeedsActivation) {
                    this.addIcode(-12);
                    this.stackChange(1);
                    this.addStringOp(-9, string);
                    this.addUint8(n);
                    break;
                }
                int n3 = this.scriptOrFn.getParamOrVarIndex(string);
                this.addVarOp(-7, n3);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 38: {
                String string = node2.getString();
                this.addStringOp(-8, string);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.visitExpression(node3, 0);
                String string = node3.getNext().getString();
                this.addStringOp(-9, string);
                this.addUint8(n);
                break;
            }
            case 35: {
                Node node4 = node2.getFirstChild();
                this.visitExpression(node4, 0);
                Node node5 = node4.getNext();
                this.visitExpression(node5, 0);
                this.addIcode(-10);
                this.addUint8(n);
                this.stackChange(-1);
                break;
            }
            case 65: {
                Node node6 = node2.getFirstChild();
                this.visitExpression(node6, 0);
                this.addIcode(-11);
                this.addUint8(n);
                this.stackChange(-1);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
    }

    private void visitLiteral(Node node, Node node2) {
        Object object;
        int n;
        int n2 = node.getType();
        Object[] objectArray = null;
        if (n2 == 63) {
            n = 0;
            for (object = node2; object != null; object = ((Node)object).getNext()) {
                ++n;
            }
        } else if (n2 == 64) {
            objectArray = (Object[])node.getProp(12);
            n = objectArray.length;
        } else {
            throw this.badTree(node);
        }
        this.addIndexOp(-30, n);
        this.stackChange(1);
        while (node2 != null) {
            this.visitExpression(node2, 0);
            this.addIcode(-31);
            this.stackChange(-1);
            node2 = node2.getNext();
        }
        if (n2 == 63) {
            object = (int[])node.getProp(11);
            if (object == null) {
                this.addToken(63);
            } else {
                int n3 = this.itsLiteralIds.size();
                this.itsLiteralIds.add(object);
                this.addIndexOp(-32, n3);
            }
        } else {
            int n4 = this.itsLiteralIds.size();
            this.itsLiteralIds.add(objectArray);
            this.addIndexOp(64, n4);
        }
    }

    private int getLocalBlockRef(Node node) {
        Node node2 = (Node)node.getProp(3);
        return node2.getExistingIntProp(2);
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n != -1) {
            return n;
        }
        n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        node.labelId(n);
        return n;
    }

    private void markTargetLabel(Node node) {
        int n = this.getTargetLabel(node);
        if (this.itsLabelTable[n] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[n] = this.itsICodeTop;
    }

    private void addGoto(Node node, int n) {
        int n2 = this.getTargetLabel(node);
        if (n2 >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        int n3 = this.itsLabelTable[n2];
        int n4 = this.itsICodeTop;
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
        if (n3 != -1) {
            this.recordJump(n4, n3);
            this.itsICodeTop += 2;
        } else {
            this.addUint16(0);
            int n5 = this.itsFixupTableTop;
            if (this.itsFixupTable == null || n5 == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] lArray = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, lArray, 0, n5);
                    this.itsFixupTable = lArray;
                }
            }
            this.itsFixupTableTop = n5 + 1;
            this.itsFixupTable[n5] = (long)n2 << 32 | (long)n4;
        }
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long l = this.itsFixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.itsLabelTable[n];
            if (n3 == -1) {
                throw Kit.codeBug();
            }
            this.recordJump(n2, n3);
        }
        this.itsFixupTableTop = 0;
    }

    private void addBackwardGoto(int n, int n2) {
        if (n2 >= this.itsICodeTop) {
            throw Kit.codeBug();
        }
        int n3 = this.itsICodeTop;
        this.addIcode(n);
        this.recordJump(n3, n2);
        this.itsICodeTop += 2;
    }

    private void addForwardGoto(int n) {
        this.addToken(n);
        this.addUint16(0);
    }

    private void resolveForwardGoto(int n) {
        if (n + 3 > this.itsICodeTop) {
            throw Kit.codeBug();
        }
        this.recordJump(n, this.itsICodeTop);
    }

    private void recordJump(int n, int n2) {
        if (n == n2) {
            throw Kit.codeBug();
        }
        int n3 = n + 1;
        int n4 = n2 - n;
        if (n4 != (short)n4) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(n3, n2);
            n4 = 0;
        }
        this.itsData.itsICode[n3] = (byte)(n4 >> 8);
        this.itsData.itsICode[n3 + 1] = (byte)n4;
    }

    private void addToken(int n) {
        if (!Interpreter.validTokenCode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n);
    }

    private void addIcode(int n) {
        if (!Interpreter.validIcode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n & 0xFF);
    }

    private void addUint8(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapasity(1);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1;
    }

    private void addUint16(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapasity(2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        this.itsICodeTop = n2 + 2;
    }

    private void addInt(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapasity(4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        this.itsICodeTop = n2 + 4;
    }

    private int getDoubleIndex(double d) {
        int n = this.itsDoubleTableTop;
        if (n == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n) {
            double[] dArray = new double[n * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n] = d;
        this.itsDoubleTableTop = n + 1;
        return n;
    }

    private void addVarOp(int n, int n2) {
        switch (n) {
            case 54: 
            case 55: {
                if (n2 < 128) {
                    this.addIcode(n == 54 ? -49 : -50);
                    this.addUint8(n2);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(n, n2);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int n, String string) {
        this.addStringPrefix(string);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addIndexOp(int n, int n2) {
        this.addIndexPrefix(n2);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addStringPrefix(String string) {
        int n = this.itsStrings.get(string, -1);
        if (n == -1) {
            n = this.itsStrings.size();
            this.itsStrings.put(string, n);
        }
        if (n < 4) {
            this.addIcode(-42 - n);
        } else if (n <= 255) {
            this.addIcode(-46);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-47);
            this.addUint16(n);
        } else {
            this.addIcode(-48);
            this.addInt(n);
        }
    }

    private void addIndexPrefix(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n < 6) {
            this.addIcode(-33 - n);
        } else if (n <= 255) {
            this.addIcode(-39);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-40);
            this.addUint16(n);
        } else {
            this.addIcode(-41);
            this.addInt(n);
        }
    }

    private void addExceptionHandler(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = this.itsExceptionTableTop;
        int[] nArray = this.itsData.itsExceptionTable;
        if (nArray == null) {
            if (n6 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else if (nArray.length == n6) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n6);
            this.itsData.itsExceptionTable = nArray;
        }
        nArray[n6 + 0] = n;
        nArray[n6 + 1] = n2;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = bl ? 1 : 0;
        nArray[n6 + 4] = n4;
        nArray[n6 + 5] = n5;
        this.itsExceptionTableTop = n6 + 6;
    }

    private byte[] increaseICodeCapasity(int n) {
        int n2 = this.itsICodeTop;
        int n3 = this.itsData.itsICode.length;
        if (n2 + n <= n3) {
            throw Kit.codeBug();
        }
        if (n2 + n > (n3 *= 2)) {
            n3 = n2 + n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n2);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private void stackChange(int n) {
        if (n <= 0) {
            this.itsStackDepth += n;
        } else {
            int n2 = this.itsStackDepth + n;
            if (n2 > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = n2;
            }
            this.itsStackDepth = n2;
        }
    }

    private int allocLocal() {
        int n = this.itsLocalTop++;
        if (this.itsLocalTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.itsLocalTop;
        }
        return n;
    }

    private void releaseLocal(int n) {
        --this.itsLocalTop;
        if (n != this.itsLocalTop) {
            Kit.codeBug();
        }
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame callFrame, boolean bl) {
        int[] nArray = callFrame.idata.itsExceptionTable;
        if (nArray == null) {
            return -1;
        }
        int n = callFrame.pc - 1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i != nArray.length; i += 6) {
            int n5 = nArray[i + 0];
            int n6 = nArray[i + 1];
            if (n5 > n || n >= n6 || bl && nArray[i + 3] != 1) continue;
            if (n2 >= 0) {
                if (n4 < n6) continue;
                if (n3 > n5) {
                    Kit.codeBug();
                }
                if (n4 == n6) {
                    Kit.codeBug();
                }
            }
            n2 = i;
            n3 = n5;
            n4 = n6;
        }
        return n2;
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static int bytecodeSpan(int n) {
        switch (n) {
            case 49: {
                return 3;
            }
            case -55: 
            case -24: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -22: {
                return 5;
            }
            case 56: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -28: {
                return 3;
            }
            case -29: {
                return 5;
            }
            case -39: {
                return 2;
            }
            case -40: {
                return 3;
            }
            case -41: {
                return 5;
            }
            case -46: {
                return 2;
            }
            case -47: {
                return 3;
            }
            case -48: {
                return 5;
            }
            case -50: 
            case -49: {
                return 2;
            }
            case -27: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(n)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        byte[] byArray = interpreterData.itsICode;
        int n2 = byArray.length;
        for (int i = 0; i != n2; i += n) {
            byte by = byArray[i];
            n = Interpreter.bytecodeSpan(by);
            if (by != -27) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            int n3 = Interpreter.getIndex(byArray, i + 1);
            uintMap.put(n3, 0);
        }
        return uintMap.getKeys();
    }

    static String getSourcePositionFromStack(Context context, int[] nArray) {
        CallFrame callFrame = (CallFrame)context.interpreterLineCounting;
        InterpreterData interpreterData = callFrame.idata;
        nArray[0] = callFrame.pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, callFrame.pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(InterpretedFunction interpretedFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(interpretedFunction, context, scriptable, scriptable2, objectArray);
        }
        if (context.interpreterSecurityDomain != interpretedFunction.securityDomain) {
            Object object2 = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpretedFunction.securityDomain;
            try {
                Object object3 = interpretedFunction.securityController.callWithDomain(interpretedFunction.securityDomain, context, interpretedFunction, scriptable, scriptable2, objectArray);
                return object3;
            }
            finally {
                context.interpreterSecurityDomain = object2;
            }
        }
        CallFrame callFrame = new CallFrame();
        Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, interpretedFunction, null, callFrame);
        try {
            object = Interpreter.interpret(context, callFrame, null);
        }
        finally {
            context.interpreterLineCounting = null;
        }
        return object;
    }

    public static Object restartContinuation(Continuation continuation, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(continuation, context, scriptable, null, objectArray);
        }
        Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        CallFrame callFrame = (CallFrame)continuation.getImplementation();
        if (callFrame == null) {
            return object;
        }
        ContinuationJump continuationJump = new ContinuationJump(continuation, null);
        continuationJump.result = object;
        return Interpreter.interpret(context, null, continuationJump);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Object interpret(Context var0, CallFrame var1_1, Object var2_2) {
        block261: {
            var3_3 = UniqueTag.DOUBLE_MARK;
            var4_4 = Undefined.instance;
            var5_5 = var0.instructionThreshold != 0;
            var8_6 = null;
            var9_7 = -1;
            if (var2_2 != null && !(var2_2 instanceof ContinuationJump)) {
                Kit.codeBug();
            }
            block142: while (true) {
                block260: {
                    block259: {
                        try {
                            block143: while (true) {
                                if (var2_2 != null) {
                                    if (var9_7 >= 0) {
                                        if (var1_1.frozen) {
                                            var1_1 = var1_1.cloneFrozen();
                                        }
                                        var10_8 = var1_1.idata.itsExceptionTable;
                                        var1_1.pc = (int)var10_8[var9_7 + 2];
                                        if (var5_5) {
                                            var1_1.pcPrevBranch = var1_1.pc;
                                        }
                                        var1_1.savedStackTop = var1_1.emptyStackTop;
                                        var11_11 = var1_1.localShift + var10_8[var9_7 + 5];
                                        var12_14 = var1_1.localShift + var10_8[var9_7 + 4];
                                        var1_1.scope = (Scriptable)var1_1.stack[var11_11];
                                        var1_1.stack[var12_14] = var2_2;
                                        var2_2 = null;
                                    } else {
                                        var10_8 = (Object[])var2_2;
                                        var2_2 = null;
                                        if (var10_8.branchFrame != var1_1) {
                                            Kit.codeBug();
                                        }
                                        if (var10_8.capturedFrame == null) {
                                            Kit.codeBug();
                                        }
                                        var11_12 = var10_8.capturedFrame.frameIndex + 1;
                                        if (var10_8.branchFrame != null) {
                                            var11_12 -= var10_8.branchFrame.frameIndex;
                                        }
                                        var12_15 = 0;
                                        var13_16 /* !! */  = null;
                                        var14_18 /* !! */  = (byte[])var10_8.capturedFrame;
                                        for (var15_19 = 0; var15_19 != var11_12; ++var15_19) {
                                            if (!var14_18 /* !! */ .frozen) {
                                                Kit.codeBug();
                                            }
                                            if (Interpreter.isFrameEnterExitRequired((CallFrame)var14_18 /* !! */ )) {
                                                if (var13_16 /* !! */  == null) {
                                                    var13_16 /* !! */  = (double[])new CallFrame[var11_12 - var15_19];
                                                }
                                                var13_16 /* !! */ [var12_15] = (double)var14_18 /* !! */ ;
                                                ++var12_15;
                                            }
                                            var14_18 /* !! */  = (byte[])var14_18 /* !! */ .parentFrame;
                                        }
                                        while (var12_15 != 0) {
                                            var14_18 /* !! */  = (byte[])var13_16 /* !! */ [--var12_15];
                                            Interpreter.enterFrame(var0, (CallFrame)var14_18 /* !! */ , ScriptRuntime.emptyArgs);
                                        }
                                        var1_1 = var10_8.capturedFrame.cloneFrozen();
                                        Interpreter.setCallResult(var1_1, var10_8.result, var10_8.resultDbl);
                                    }
                                } else if (var1_1.frozen) {
                                    Kit.codeBug();
                                }
                                var10_8 = var1_1.stack;
                                var11_10 = var1_1.sDbl;
                                var12_13 = var1_1.varSource.stack;
                                var13_16 /* !! */  = var1_1.varSource.sDbl;
                                var14_18 /* !! */  = var1_1.idata.itsICode;
                                var15_20 = var1_1.idata.itsStringTable;
                                var16_25 = var1_1.savedStackTop;
                                var0.interpreterLineCounting = var1_1;
                                block146: while (true) {
                                    var17_27 = var14_18 /* !! */ [var1_1.pc++];
                                    switch (var17_27) {
                                        case 49: {
                                            var18_29 = var10_8[var16_25];
                                            if (var18_29 == var3_3) {
                                                var18_29 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            --var16_25;
                                            var19_90 = Interpreter.getIndex(var14_18 /* !! */ , var1_1.pc);
                                            var2_2 = new JavaScriptException(var18_29, var1_1.idata.itsSourceFile, var19_90);
                                            break block259;
                                        }
                                        case 50: {
                                            var2_2 = var10_8[var9_7 += var1_1.localShift];
                                            break block259;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            var18_30 = var10_8[--var16_25 + 1];
                                            var19_91 = var10_8[var16_25];
                                            if (var18_30 != var3_3) ** GOTO lbl91
                                            var21_147 = var11_10[var16_25 + 1];
                                            var23_161 = Interpreter.stack_double(var1_1, var16_25);
                                            ** GOTO lbl94
lbl91:
                                            // 1 sources

                                            if (var19_91 != var3_3) ** GOTO lbl109
                                            var21_147 = ScriptRuntime.toNumber(var18_30);
                                            var23_161 = var11_10[var16_25];
lbl94:
                                            // 2 sources

                                            switch (var17_27) {
                                                case 17: {
                                                    var20_126 = var23_161 >= var21_147;
                                                    ** GOTO lbl124
                                                }
                                                case 15: {
                                                    var20_126 = var23_161 <= var21_147;
                                                    ** GOTO lbl124
                                                }
                                                case 16: {
                                                    var20_126 = var23_161 > var21_147;
                                                    ** GOTO lbl124
                                                }
                                                case 14: {
                                                    var20_126 = var23_161 < var21_147;
                                                    ** GOTO lbl124
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl109:
                                            // 1 sources

                                            switch (var17_27) {
                                                case 17: {
                                                    var20_126 = ScriptRuntime.cmp_LE(var18_30, var19_91);
                                                    break;
                                                }
                                                case 15: {
                                                    var20_126 = ScriptRuntime.cmp_LE(var19_91, var18_30);
                                                    break;
                                                }
                                                case 16: {
                                                    var20_126 = ScriptRuntime.cmp_LT(var18_30, var19_91);
                                                    break;
                                                }
                                                case 14: {
                                                    var20_126 = ScriptRuntime.cmp_LT(var19_91, var18_30);
                                                    break;
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl124:
                                            // 8 sources

                                            var10_8[var16_25] = ScriptRuntime.wrapBoolean(var20_126);
                                            continue block146;
                                        }
                                        case 51: {
                                            var18_31 = var10_8[var16_25];
                                            if (var18_31 == var3_3) {
                                                var18_31 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_92 = var10_8[--var16_25]) == var3_3) {
                                                var19_92 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var20_127 = ScriptRuntime.in(var19_92, var18_31, var0, var1_1.scope);
                                            var10_8[var16_25] = ScriptRuntime.wrapBoolean(var20_127);
                                            continue block146;
                                        }
                                        case 52: {
                                            var18_32 = var10_8[var16_25];
                                            if (var18_32 == var3_3) {
                                                var18_32 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_93 = var10_8[--var16_25]) == var3_3) {
                                                var19_93 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var20_128 = ScriptRuntime.instanceOf(var19_93, var18_32, var0, var1_1.scope);
                                            var10_8[var16_25] = ScriptRuntime.wrapBoolean(var20_128);
                                            continue block146;
                                        }
                                        case 12: 
                                        case 13: {
                                            var19_94 = var10_8[--var16_25 + 1];
                                            var20_129 = var10_8[var16_25];
                                            var18_33 = var19_94 == var3_3 ? (var20_129 == var3_3 ? var11_10[var16_25] == var11_10[var16_25 + 1] : ScriptRuntime.eqNumber(var11_10[var16_25 + 1], var20_129)) : (var20_129 == var3_3 ? ScriptRuntime.eqNumber(var11_10[var16_25], var19_94) : ScriptRuntime.eq(var20_129, var19_94));
                                            var10_8[var16_25] = ScriptRuntime.wrapBoolean(var18_33 ^= var17_27 == 13);
                                            continue block146;
                                        }
                                        case 45: 
                                        case 46: {
                                            var18_34 = var10_8[--var16_25 + 1];
                                            var19_95 = var10_8[var16_25];
                                            if (var18_34 != var3_3) ** GOTO lbl163
                                            var21_148 = var11_10[var16_25 + 1];
                                            if (var19_95 != var3_3) ** GOTO lbl158
                                            var23_162 = var11_10[var16_25];
                                            ** GOTO lbl175
lbl158:
                                            // 1 sources

                                            if (!(var19_95 instanceof Number)) ** GOTO lbl161
                                            var23_162 = ((Number)var19_95).doubleValue();
                                            ** GOTO lbl175
lbl161:
                                            // 1 sources

                                            var20_130 = false;
                                            ** GOTO lbl176
lbl163:
                                            // 1 sources

                                            if (var19_95 != var3_3) ** GOTO lbl173
                                            var23_162 = var11_10[var16_25];
                                            if (var18_34 != var3_3) ** GOTO lbl168
                                            var21_148 = var11_10[var16_25 + 1];
                                            ** GOTO lbl175
lbl168:
                                            // 1 sources

                                            if (!(var18_34 instanceof Number)) ** GOTO lbl171
                                            var21_148 = ((Number)var18_34).doubleValue();
                                            ** GOTO lbl175
lbl171:
                                            // 1 sources

                                            var20_130 = false;
                                            ** GOTO lbl176
lbl173:
                                            // 1 sources

                                            var20_130 = ScriptRuntime.shallowEq(var19_95, var18_34);
                                            ** GOTO lbl176
lbl175:
                                            // 4 sources

                                            var20_130 = var23_162 == var21_148;
lbl176:
                                            // 4 sources

                                            var10_8[var16_25] = ScriptRuntime.wrapBoolean(var20_130 ^= var17_27 == 46);
                                            continue block146;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean(var1_1, var16_25--)) break;
                                            var1_1.pc += 2;
                                            continue block146;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean(var1_1, var16_25--)) break;
                                            var1_1.pc += 2;
                                            continue block146;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean(var1_1, var16_25--)) {
                                                var1_1.pc += 2;
                                                continue block146;
                                            }
                                            var10_8[var16_25--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -24: {
                                            var10_8[++var16_25] = var3_3;
                                            var11_10[var16_25] = var1_1.pc + 2;
                                            break;
                                        }
                                        case -25: {
                                            if (var16_25 == var1_1.emptyStackTop + 1) {
                                                var10_8[var9_7 += var1_1.localShift] = var10_8[var16_25];
                                                var11_10[var9_7] = var11_10[var16_25];
                                                --var16_25;
                                                continue block146;
                                            }
                                            if (var16_25 == var1_1.emptyStackTop) continue block146;
                                            Kit.codeBug();
                                            continue block146;
                                        }
                                        case -26: {
                                            if (var5_5) {
                                                Interpreter.addInstructionCount(var0, var1_1, 0);
                                            }
                                            if ((var18_35 = var10_8[var9_7 += var1_1.localShift]) != var3_3) {
                                                var2_2 = var18_35;
                                                break block259;
                                            }
                                            var1_1.pc = (int)var11_10[var9_7];
                                            if (!var5_5) continue block146;
                                            var1_1.pcPrevBranch = var1_1.pc;
                                            continue block146;
                                        }
                                        case -4: {
                                            var10_8[var16_25] = null;
                                            --var16_25;
                                            continue block146;
                                        }
                                        case -5: {
                                            var1_1.result = var10_8[var16_25];
                                            var1_1.resultDbl = var11_10[var16_25];
                                            var10_8[var16_25] = null;
                                            --var16_25;
                                            continue block146;
                                        }
                                        case -1: {
                                            var10_8[var16_25 + 1] = var10_8[var16_25];
                                            var11_10[var16_25 + 1] = var11_10[var16_25];
                                            ++var16_25;
                                            continue block146;
                                        }
                                        case -2: {
                                            var10_8[var16_25 + 1] = var10_8[var16_25 - 1];
                                            var11_10[var16_25 + 1] = var11_10[var16_25 - 1];
                                            var10_8[var16_25 + 2] = var10_8[var16_25];
                                            var11_10[var16_25 + 2] = var11_10[var16_25];
                                            var16_25 += 2;
                                            continue block146;
                                        }
                                        case -3: {
                                            var18_36 = var10_8[var16_25];
                                            var10_8[var16_25] = var10_8[var16_25 - 1];
                                            var10_8[var16_25 - 1] = var18_36;
                                            var19_96 = var11_10[var16_25];
                                            var11_10[var16_25] = var11_10[var16_25 - 1];
                                            var11_10[var16_25 - 1] = var19_96;
                                            continue block146;
                                        }
                                        case 4: {
                                            var1_1.result = var10_8[var16_25];
                                            var1_1.resultDbl = var11_10[var16_25];
                                            --var16_25;
                                            break block146;
                                        }
                                        case 62: {
                                            break block146;
                                        }
                                        case -23: {
                                            var1_1.result = var4_4;
                                            break block146;
                                        }
                                        case 27: {
                                            var18_37 = Interpreter.stack_int32(var1_1, var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = ~var18_37;
                                            continue block146;
                                        }
                                        case 11: {
                                            var18_38 = Interpreter.stack_int32(var1_1, var16_25);
                                            var19_97 = Interpreter.stack_int32(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var19_97 & var18_38;
                                            continue block146;
                                        }
                                        case 9: {
                                            var18_39 = Interpreter.stack_int32(var1_1, var16_25);
                                            var19_98 = Interpreter.stack_int32(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var19_98 | var18_39;
                                            continue block146;
                                        }
                                        case 10: {
                                            var18_40 = Interpreter.stack_int32(var1_1, var16_25);
                                            var19_99 = Interpreter.stack_int32(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var19_99 ^ var18_40;
                                            continue block146;
                                        }
                                        case 18: {
                                            var18_41 = Interpreter.stack_int32(var1_1, var16_25);
                                            var19_100 = Interpreter.stack_int32(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var19_100 << var18_41;
                                            continue block146;
                                        }
                                        case 19: {
                                            var18_42 = Interpreter.stack_int32(var1_1, var16_25);
                                            var19_101 = Interpreter.stack_int32(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var19_101 >> var18_42;
                                            continue block146;
                                        }
                                        case 20: {
                                            var18_43 = Interpreter.stack_int32(var1_1, var16_25) & 31;
                                            var19_102 = Interpreter.stack_double(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = ScriptRuntime.toUint32(var19_102) >>> var18_43;
                                            continue block146;
                                        }
                                        case 29: {
                                            var18_44 = Interpreter.stack_double(var1_1, var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = -var18_44;
                                            continue block146;
                                        }
                                        case 28: {
                                            var18_45 = Interpreter.stack_double(var1_1, var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var18_45;
                                            continue block146;
                                        }
                                        case 21: {
                                            Interpreter.do_add(var10_8, var11_10, --var16_25, var0);
                                            continue block146;
                                        }
                                        case 22: {
                                            var18_46 = Interpreter.stack_double(var1_1, var16_25);
                                            var20_131 = Interpreter.stack_double(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var20_131 - var18_46;
                                            continue block146;
                                        }
                                        case 23: {
                                            var18_47 = Interpreter.stack_double(var1_1, var16_25);
                                            var20_132 = Interpreter.stack_double(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var20_132 * var18_47;
                                            continue block146;
                                        }
                                        case 24: {
                                            var18_48 = Interpreter.stack_double(var1_1, var16_25);
                                            var20_133 = Interpreter.stack_double(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var20_133 / var18_48;
                                            continue block146;
                                        }
                                        case 25: {
                                            var18_49 = Interpreter.stack_double(var1_1, var16_25);
                                            var20_134 = Interpreter.stack_double(var1_1, --var16_25);
                                            var10_8[var16_25] = var3_3;
                                            var11_10[var16_25] = var20_134 % var18_49;
                                            continue block146;
                                        }
                                        case 26: {
                                            var10_8[var16_25] = ScriptRuntime.wrapBoolean(Interpreter.stack_boolean(var1_1, var16_25) == false);
                                            continue block146;
                                        }
                                        case 48: {
                                            var10_8[++var16_25] = ScriptRuntime.bind(var0, var1_1.scope, var8_6);
                                            continue block146;
                                        }
                                        case 8: {
                                            var18_50 = var10_8[var16_25];
                                            if (var18_50 == var3_3) {
                                                var18_50 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var19_103 = (Scriptable)var10_8[--var16_25];
                                            var10_8[var16_25] = ScriptRuntime.setName(var19_103, var18_50, var0, var1_1.scope, var8_6);
                                            continue block146;
                                        }
                                        case 31: {
                                            var18_51 = var10_8[var16_25];
                                            if (var18_51 == var3_3) {
                                                var18_51 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_104 = var10_8[--var16_25]) == var3_3) {
                                                var19_104 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.delete(var19_104, var18_51, var0);
                                            continue block146;
                                        }
                                        case 33: {
                                            var18_52 = var10_8[var16_25];
                                            if (var18_52 == var3_3) {
                                                var18_52 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.getObjectProp(var18_52, var8_6, var0);
                                            continue block146;
                                        }
                                        case 34: {
                                            var18_53 = var10_8[var16_25];
                                            if (var18_53 == var3_3) {
                                                var18_53 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_105 = var10_8[--var16_25]) == var3_3) {
                                                var19_105 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.setObjectProp(var19_105, var8_6, var18_53, var0);
                                            continue block146;
                                        }
                                        case -9: {
                                            var18_54 = var10_8[var16_25];
                                            if (var18_54 == var3_3) {
                                                var18_54 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.propIncrDecr(var18_54, var8_6, var0, var14_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case 35: {
                                            var18_55 = var10_8[--var16_25];
                                            if (var18_55 == var3_3) {
                                                var18_55 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var20_135 = var10_8[var16_25 + 1]) != var3_3) {
                                                var19_106 = ScriptRuntime.getObjectElem(var18_55, var20_135, var0);
                                            } else {
                                                var21_149 = var11_10[var16_25 + 1];
                                                var19_106 = ScriptRuntime.getObjectIndex(var18_55, var21_149, var0);
                                            }
                                            var10_8[var16_25] = var19_106;
                                            continue block146;
                                        }
                                        case 36: {
                                            var18_56 = var10_8[(var16_25 -= 2) + 2];
                                            if (var18_56 == var3_3) {
                                                var18_56 = ScriptRuntime.wrapNumber(var11_10[var16_25 + 2]);
                                            }
                                            if ((var19_107 = var10_8[var16_25]) == var3_3) {
                                                var19_107 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var21_150 = var10_8[var16_25 + 1]) != var3_3) {
                                                var20_136 = ScriptRuntime.setObjectElem(var19_107, var21_150, var18_56, var0);
                                            } else {
                                                var22_158 = var11_10[var16_25 + 1];
                                                var20_136 = ScriptRuntime.setObjectIndex(var19_107, var22_158, var18_56, var0);
                                            }
                                            var10_8[var16_25] = var20_136;
                                            continue block146;
                                        }
                                        case -10: {
                                            var18_57 = var10_8[var16_25];
                                            if (var18_57 == var3_3) {
                                                var18_57 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_108 = var10_8[--var16_25]) == var3_3) {
                                                var19_108 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.elemIncrDecr(var19_108, var18_57, var0, var14_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case 65: {
                                            var18_58 = (Scriptable)var10_8[var16_25];
                                            var19_109 = (Ref)var10_8[--var16_25];
                                            var10_8[var16_25] = ScriptRuntime.refGet(var19_109, var18_58, var0);
                                            continue block146;
                                        }
                                        case 66: {
                                            var18_59 = var10_8[var16_25];
                                            if (var18_59 == var3_3) {
                                                var18_59 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var19_110 = (Scriptable)var10_8[--var16_25];
                                            var20_137 = (Ref)var10_8[--var16_25];
                                            var10_8[var16_25] = ScriptRuntime.refSet(var20_137, var19_110, var18_59, var0);
                                            continue block146;
                                        }
                                        case 67: {
                                            var18_60 = (Scriptable)var10_8[var16_25];
                                            var19_111 = (Ref)var10_8[--var16_25];
                                            var10_8[var16_25] = ScriptRuntime.refDel(var19_111, var18_60, var0);
                                            continue block146;
                                        }
                                        case -11: {
                                            var18_61 = (Scriptable)var10_8[var16_25];
                                            var19_112 = (Ref)var10_8[--var16_25];
                                            var10_8[var16_25] = ScriptRuntime.refIncrDecr(var19_112, var18_61, var0, var14_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case 53: {
                                            var10_8[++var16_25] = var10_8[var9_7 += var1_1.localShift];
                                            var11_10[var16_25] = var11_10[var9_7];
                                            continue block146;
                                        }
                                        case -57: {
                                            var10_8[var9_7 += var1_1.localShift] = null;
                                            continue block146;
                                        }
                                        case -16: {
                                            var10_8[++var16_25] = ScriptRuntime.getNameFunctionAndThis(var8_6, var0, var1_1.scope);
                                            var10_8[++var16_25] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block146;
                                        }
                                        case -17: {
                                            var18_62 = var10_8[var16_25];
                                            if (var18_62 == var3_3) {
                                                var18_62 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.getPropFunctionAndThis(var18_62, var8_6, var0);
                                            var10_8[++var16_25] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block146;
                                        }
                                        case -18: {
                                            var18_63 = var10_8[var16_25 - 1];
                                            if (var18_63 == var3_3) {
                                                var18_63 = ScriptRuntime.wrapNumber(var11_10[var16_25 - 1]);
                                            }
                                            if ((var19_113 = var10_8[var16_25]) == var3_3) {
                                                var19_113 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25 - 1] = ScriptRuntime.getElemFunctionAndThis(var18_63, var19_113, var0);
                                            var10_8[var16_25] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block146;
                                        }
                                        case -19: {
                                            var18_64 = var10_8[var16_25];
                                            if (var18_64 == var3_3) {
                                                var18_64 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.getValueFunctionAndThis(var18_64, var0);
                                            var10_8[++var16_25] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block146;
                                        }
                                        case -22: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var18_65 = var14_18 /* !! */ [var1_1.pc] & 255;
                                            var19_114 = var14_18 /* !! */ [var1_1.pc + 1] != 0;
                                            var20_138 = Interpreter.getIndex(var14_18 /* !! */ , var1_1.pc + 2);
                                            if (var19_114) {
                                                var21_151 = var10_8[var16_25 -= var9_7];
                                                if (var21_151 == var3_3) {
                                                    var21_151 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                                }
                                                var22_159 = Interpreter.getArgsArray(var10_8, var11_10, var16_25 + 1, var9_7);
                                                var10_8[var16_25] = ScriptRuntime.newSpecial(var0, var21_151, var22_159, var1_1.scope, var18_65);
                                            } else {
                                                var21_151 = (Scriptable)var10_8[(var16_25 -= 1 + var9_7) + 1];
                                                var22_159 = (Object[])var10_8[var16_25];
                                                var23_163 = Interpreter.getArgsArray(var10_8, var11_10, var16_25 + 2, var9_7);
                                                var10_8[var16_25] = ScriptRuntime.callSpecial(var0, (Function)var22_159, (Scriptable)var21_151, var23_163, var1_1.scope, var1_1.thisObj, var18_65, var1_1.idata.itsSourceFile, var20_138);
                                            }
                                            var1_1.pc += 4;
                                            continue block146;
                                        }
                                        case -56: 
                                        case 37: 
                                        case 68: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var18_66 = (Function)var10_8[var16_25 -= 1 + var9_7];
                                            var19_115 = (Scriptable)var10_8[var16_25 + 1];
                                            var20_139 = var1_1.scope;
                                            if (var1_1.useActivation) {
                                                var20_139 = ScriptableObject.getTopLevelScope(var1_1.scope);
                                            }
                                            if (var17_27 == 68) {
                                                var21_152 = Interpreter.getArgsArray(var10_8, var11_10, var16_25 + 2, var9_7);
                                                var10_8[var16_25] = ScriptRuntime.callRef(var18_66, var19_115, var21_152, var0, var20_139);
                                                var10_8[++var16_25] = Ref.popTarget(var0);
                                                continue block146;
                                            }
                                            if (var18_66 instanceof InterpretedFunction) {
                                                var21_153 = (InterpretedFunction)var18_66;
                                                if (var1_1.fnOrScript.securityDomain == var21_153.securityDomain) {
                                                    var22_160 = var1_1;
                                                    var23_164 = new CallFrame();
                                                    if (var17_27 == -56) {
                                                        var22_160 = var1_1.parentFrame;
                                                    }
                                                    Interpreter.initFrame(var0, var20_139, var19_115, var10_8, var11_10, var16_25 + 2, var9_7, var21_153, var22_160, var23_164);
                                                    if (var17_27 == -56) {
                                                        Interpreter.exitFrame(var0, var1_1, null);
                                                    } else {
                                                        var1_1.savedStackTop = var16_25;
                                                        var1_1.savedCallOp = var17_27;
                                                    }
                                                    var1_1 = var23_164;
                                                    continue block143;
                                                }
                                            }
                                            if (var18_66 instanceof Continuation) {
                                                var21_154 = new ContinuationJump((Continuation)var18_66, var1_1);
                                                if (var9_7 == 0) {
                                                    var21_154.result = var4_4;
                                                } else {
                                                    var21_154.result = var10_8[var16_25 + 2];
                                                    var21_154.resultDbl = var11_10[var16_25 + 2];
                                                }
                                                var2_2 = var21_154;
                                                break block259;
                                            }
                                            if (var18_66 instanceof IdFunctionObject && Continuation.isContinuationConstructor(var21_155 = (IdFunctionObject)var18_66)) {
                                                Interpreter.captureContinuation(var0, var1_1, var16_25);
                                                continue block146;
                                            }
                                            var21_156 = Interpreter.getArgsArray(var10_8, var11_10, var16_25 + 2, var9_7);
                                            var10_8[var16_25] = var18_66.call(var0, var20_139, var19_115, var21_156);
                                            continue block146;
                                        }
                                        case 30: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            if ((var18_67 = var10_8[var16_25 -= var9_7]) instanceof InterpretedFunction) {
                                                var19_116 = (InterpretedFunction)var18_67;
                                                if (var1_1.fnOrScript.securityDomain == var19_116.securityDomain) {
                                                    var20_140 = var19_116.createObject(var0, var1_1.scope);
                                                    var21_157 = new CallFrame();
                                                    Interpreter.initFrame(var0, var1_1.scope, var20_140, var10_8, var11_10, var16_25 + 1, var9_7, var19_116, var1_1, var21_157);
                                                    var10_8[var16_25] = var20_140;
                                                    var1_1.savedStackTop = var16_25;
                                                    var1_1.savedCallOp = var17_27;
                                                    var1_1 = var21_157;
                                                    continue block143;
                                                }
                                            }
                                            if (!(var18_67 instanceof Function)) {
                                                if (var18_67 == var3_3) {
                                                    var18_67 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                                }
                                                throw ScriptRuntime.notFunctionError(var18_67);
                                            }
                                            var19_117 = (Function)var18_67;
                                            if (var19_117 instanceof IdFunctionObject && Continuation.isContinuationConstructor(var20_141 = (IdFunctionObject)var19_117)) {
                                                Interpreter.captureContinuation(var0, var1_1, var16_25);
                                                continue block146;
                                            }
                                            var20_142 = Interpreter.getArgsArray(var10_8, var11_10, var16_25 + 1, var9_7);
                                            var10_8[var16_25] = var19_117.construct(var0, var1_1.scope, var20_142);
                                            continue block146;
                                        }
                                        case 32: {
                                            var18_68 = var10_8[var16_25];
                                            if (var18_68 == var3_3) {
                                                var18_68 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.typeof(var18_68);
                                            continue block146;
                                        }
                                        case -15: {
                                            var10_8[++var16_25] = ScriptRuntime.typeofName(var1_1.scope, var8_6);
                                            continue block146;
                                        }
                                        case 40: {
                                            var10_8[++var16_25] = var8_6;
                                            continue block146;
                                        }
                                        case -28: {
                                            var10_8[++var16_25] = var3_3;
                                            var11_10[var16_25] = Interpreter.getShort(var14_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block146;
                                        }
                                        case -29: {
                                            var10_8[++var16_25] = var3_3;
                                            var11_10[var16_25] = Interpreter.getInt(var14_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block146;
                                        }
                                        case 39: {
                                            var10_8[++var16_25] = var3_3;
                                            var11_10[var16_25] = var1_1.idata.itsDoubleTable[var9_7];
                                            continue block146;
                                        }
                                        case 38: {
                                            var10_8[++var16_25] = ScriptRuntime.name(var0, var1_1.scope, var8_6);
                                            continue block146;
                                        }
                                        case -8: {
                                            var10_8[++var16_25] = ScriptRuntime.nameIncrDecr(var1_1.scope, var8_6, var14_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case -50: {
                                            var9_7 = var14_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 55: {
                                            if (!var1_1.useActivation) {
                                                var12_13[var9_7] = var10_8[var16_25];
                                                var13_16 /* !! */ [var9_7] = var11_10[var16_25];
                                                continue block146;
                                            }
                                            var18_69 = var10_8[var16_25];
                                            if (var18_69 == var3_3) {
                                                var18_69 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var1_1.scope.put(var8_6, var1_1.scope, var18_69);
                                            continue block146;
                                        }
                                        case -49: {
                                            var9_7 = var14_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 54: {
                                            ++var16_25;
                                            if (!var1_1.useActivation) {
                                                var10_8[var16_25] = var12_13[var9_7];
                                                var11_10[var16_25] = var13_16 /* !! */ [var9_7];
                                                continue block146;
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var10_8[var16_25] = var1_1.scope.get(var8_6, var1_1.scope);
                                            continue block146;
                                        }
                                        case -7: {
                                            ++var16_25;
                                            var18_70 = var14_18 /* !! */ [var1_1.pc];
                                            if (!var1_1.useActivation) {
                                                var10_8[var16_25] = var3_3;
                                                var19_118 = var12_13[var9_7];
                                                if (var19_118 == var3_3) {
                                                    var20_143 = var13_16 /* !! */ [var9_7];
                                                } else {
                                                    var20_143 = ScriptRuntime.toNumber(var19_118);
                                                    var12_13[var9_7] = var3_3;
                                                }
                                                var13_16 /* !! */ [var9_7] = var22_158 = (var18_70 & 1) == 0 ? var20_143 + 1.0 : var20_143 - 1.0;
                                                var11_10[var16_25] = (var18_70 & 2) == 0 ? var22_158 : var20_143;
                                            } else {
                                                var19_118 = var1_1.idata.argNames[var9_7];
                                                var10_8[var16_25] = ScriptRuntime.nameIncrDecr(var1_1.scope, (String)var19_118, var18_70);
                                            }
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case -52: {
                                            var10_8[++var16_25] = var3_3;
                                            var11_10[var16_25] = 0.0;
                                            continue block146;
                                        }
                                        case -53: {
                                            var10_8[++var16_25] = var3_3;
                                            var11_10[var16_25] = 1.0;
                                            continue block146;
                                        }
                                        case 41: {
                                            var10_8[++var16_25] = null;
                                            continue block146;
                                        }
                                        case 42: {
                                            var10_8[++var16_25] = var1_1.thisObj;
                                            continue block146;
                                        }
                                        case 61: {
                                            var10_8[++var16_25] = var1_1.fnOrScript;
                                            continue block146;
                                        }
                                        case 43: {
                                            var10_8[++var16_25] = Boolean.FALSE;
                                            continue block146;
                                        }
                                        case 44: {
                                            var10_8[++var16_25] = Boolean.TRUE;
                                            continue block146;
                                        }
                                        case -51: {
                                            var10_8[++var16_25] = var4_4;
                                            continue block146;
                                        }
                                        case 2: {
                                            var18_71 = var10_8[var16_25];
                                            if (var18_71 == var3_3) {
                                                var18_71 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            --var16_25;
                                            var1_1.scope = ScriptRuntime.enterWith(var18_71, var0, var1_1.scope);
                                            continue block146;
                                        }
                                        case 3: {
                                            var1_1.scope = ScriptRuntime.leaveWith(var1_1.scope);
                                            continue block146;
                                        }
                                        case 56: {
                                            var18_72 = var1_1.idata.itsICode[var1_1.pc] != 0;
                                            var19_119 = (Throwable)var10_8[--var16_25 + 1];
                                            var20_144 = var18_72 == false ? null : (Scriptable)var10_8[var9_7 += var1_1.localShift];
                                            var10_8[var9_7] = ScriptRuntime.newCatchScope(var19_119, var20_144, var8_6, var0, var1_1.scope);
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case 57: 
                                        case 58: {
                                            var18_73 = var10_8[var16_25];
                                            if (var18_73 == var3_3) {
                                                var18_73 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            --var16_25;
                                            var10_8[var9_7 += var1_1.localShift] = ScriptRuntime.enumInit(var18_73, var0, var17_27 == 58);
                                            continue block146;
                                        }
                                        case 59: 
                                        case 60: {
                                            var18_74 = var10_8[var9_7 += var1_1.localShift];
                                            var10_8[++var16_25] = var17_27 == 59 ? ScriptRuntime.enumNext(var18_74) : ScriptRuntime.enumId(var18_74, var0);
                                            continue block146;
                                        }
                                        case 69: {
                                            var18_75 = var10_8[var16_25];
                                            if (var18_75 == var3_3) {
                                                var18_75 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.specialRef(var18_75, var8_6, var0);
                                            var10_8[++var16_25] = Ref.popTarget(var0);
                                            continue block146;
                                        }
                                        case 73: {
                                            var18_76 = var10_8[var16_25];
                                            if (var18_76 == var3_3) {
                                                var18_76 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_120 = var10_8[--var16_25]) == var3_3) {
                                                var19_120 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.memberRef(var19_120, var18_76, var0, var9_7);
                                            var10_8[++var16_25] = Ref.popTarget(var0);
                                            continue block146;
                                        }
                                        case 74: {
                                            var18_77 = var10_8[var16_25];
                                            if (var18_77 == var3_3) {
                                                var18_77 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_121 = var10_8[--var16_25]) == var3_3) {
                                                var19_121 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var20_145 = var10_8[--var16_25]) == var3_3) {
                                                var20_145 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.memberRef(var20_145, var19_121, var18_77, var0, var9_7);
                                            var10_8[++var16_25] = Ref.popTarget(var0);
                                            continue block146;
                                        }
                                        case 75: {
                                            var18_78 = var10_8[var16_25];
                                            if (var18_78 == var3_3) {
                                                var18_78 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.nameRef(var18_78, var0, var1_1.scope, var9_7);
                                            var10_8[++var16_25] = Ref.popTarget(var0);
                                            continue block146;
                                        }
                                        case 76: {
                                            var18_79 = var10_8[var16_25];
                                            if (var18_79 == var3_3) {
                                                var18_79 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            if ((var19_122 = var10_8[--var16_25]) == var3_3) {
                                                var19_122 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.nameRef(var19_122, var18_79, var0, var1_1.scope, var9_7);
                                            var10_8[++var16_25] = Ref.popTarget(var0);
                                            continue block146;
                                        }
                                        case -12: {
                                            var10_8[++var16_25] = var1_1.scope;
                                            continue block146;
                                        }
                                        case -13: {
                                            var1_1.scope = (Scriptable)var10_8[var9_7 += var1_1.localShift];
                                            continue block146;
                                        }
                                        case -14: {
                                            var10_8[var9_7 += var1_1.localShift] = var1_1.scope;
                                            continue block146;
                                        }
                                        case -20: {
                                            var10_8[++var16_25] = InterpretedFunction.createFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block146;
                                        }
                                        case -21: {
                                            Interpreter.initFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block146;
                                        }
                                        case 47: {
                                            var10_8[++var16_25] = var1_1.scriptRegExps[var9_7];
                                            continue block146;
                                        }
                                        case -30: {
                                            var10_8[++var16_25] = new Object[var9_7];
                                            var11_10[var16_25] = 0.0;
                                            continue block146;
                                        }
                                        case -31: {
                                            var18_80 = var10_8[var16_25];
                                            if (var18_80 == var3_3) {
                                                var18_80 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var19_123 = (int)var11_10[--var16_25];
                                            ((Object[])var10_8[var16_25])[var19_123] = var18_80;
                                            var11_10[var16_25] = var19_123 + 1;
                                            continue block146;
                                        }
                                        case -32: 
                                        case 63: 
                                        case 64: {
                                            var18_81 = (Object[])var10_8[var16_25];
                                            if (var17_27 == 64) {
                                                var20_146 /* !! */  = (Object[])var1_1.idata.literalIds[var9_7];
                                                var19_124 = ScriptRuntime.newObjectLiteral(var20_146 /* !! */ , var18_81, var0, var1_1.scope);
                                            } else {
                                                var20_146 /* !! */  = null;
                                                if (var17_27 == -32) {
                                                    var20_146 /* !! */  = (int[])var1_1.idata.literalIds[var9_7];
                                                }
                                                var19_124 = ScriptRuntime.newArrayLiteral(var18_81, (int[])var20_146 /* !! */ , var0, var1_1.scope);
                                            }
                                            var10_8[var16_25] = var19_124;
                                            continue block146;
                                        }
                                        case -54: {
                                            var18_82 = var10_8[var16_25];
                                            if (var18_82 == var3_3) {
                                                var18_82 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            --var16_25;
                                            var1_1.scope = ScriptRuntime.enterDotQuery(var18_82, var1_1.scope);
                                            continue block146;
                                        }
                                        case -55: {
                                            var18_83 = Interpreter.stack_boolean(var1_1, var16_25);
                                            var19_125 = ScriptRuntime.updateDotQuery(var18_83, var1_1.scope);
                                            if (var19_125 != null) {
                                                var10_8[var16_25] = var19_125;
                                                var1_1.scope = ScriptRuntime.leaveDotQuery(var1_1.scope);
                                                var1_1.pc += 2;
                                                continue block146;
                                            }
                                            --var16_25;
                                            break;
                                        }
                                        case 70: {
                                            var18_84 = var10_8[var16_25];
                                            if (var18_84 == var3_3) {
                                                var18_84 = ScriptRuntime.wrapNumber(var11_10[var16_25]);
                                            }
                                            var10_8[var16_25] = ScriptRuntime.setDefaultNamespace(var18_84, var0);
                                            continue block146;
                                        }
                                        case 71: {
                                            var18_85 = var10_8[var16_25];
                                            if (var18_85 == var3_3) continue block146;
                                            var10_8[var16_25] = ScriptRuntime.escapeAttributeValue(var18_85, var0);
                                            continue block146;
                                        }
                                        case 72: {
                                            var18_86 = var10_8[var16_25];
                                            if (var18_86 == var3_3) continue block146;
                                            var10_8[var16_25] = ScriptRuntime.escapeTextValue(var18_86, var0);
                                            continue block146;
                                        }
                                        case -27: {
                                            var1_1.pcSourceLineStart = var1_1.pc;
                                            if (var1_1.debuggerFrame != null) {
                                                var18_87 = Interpreter.getIndex(var14_18 /* !! */ , var1_1.pc);
                                                var1_1.debuggerFrame.onLineChange(var0, var18_87);
                                            }
                                            var1_1.pc += 2;
                                            continue block146;
                                        }
                                        case -33: {
                                            var9_7 = 0;
                                            continue block146;
                                        }
                                        case -34: {
                                            var9_7 = 1;
                                            continue block146;
                                        }
                                        case -35: {
                                            var9_7 = 2;
                                            continue block146;
                                        }
                                        case -36: {
                                            var9_7 = 3;
                                            continue block146;
                                        }
                                        case -37: {
                                            var9_7 = 4;
                                            continue block146;
                                        }
                                        case -38: {
                                            var9_7 = 5;
                                            continue block146;
                                        }
                                        case -39: {
                                            var9_7 = 255 & var14_18 /* !! */ [var1_1.pc];
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case -40: {
                                            var9_7 = Interpreter.getIndex(var14_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block146;
                                        }
                                        case -41: {
                                            var9_7 = Interpreter.getInt(var14_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block146;
                                        }
                                        case -42: {
                                            var8_6 = var15_20[0];
                                            continue block146;
                                        }
                                        case -43: {
                                            var8_6 = var15_20[1];
                                            continue block146;
                                        }
                                        case -44: {
                                            var8_6 = var15_20[2];
                                            continue block146;
                                        }
                                        case -45: {
                                            var8_6 = var15_20[3];
                                            continue block146;
                                        }
                                        case -46: {
                                            var8_6 = var15_20[255 & var14_18 /* !! */ [var1_1.pc]];
                                            ++var1_1.pc;
                                            continue block146;
                                        }
                                        case -47: {
                                            var8_6 = var15_20[Interpreter.getIndex(var14_18 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 2;
                                            continue block146;
                                        }
                                        case -48: {
                                            var8_6 = var15_20[Interpreter.getInt(var14_18 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 4;
                                            continue block146;
                                        }
                                        default: {
                                            Interpreter.dumpICode(var1_1.idata);
                                            throw new RuntimeException("Unknown icode : " + var17_27 + " @ pc : " + (var1_1.pc - 1));
                                        }
                                    }
                                    if (var5_5) {
                                        Interpreter.addInstructionCount(var0, var1_1, 2);
                                    }
                                    var1_1.pc = (var18_88 = Interpreter.getShort(var14_18 /* !! */ , var1_1.pc)) != 0 ? (var1_1.pc += var18_88 - 1) : var1_1.idata.longJumps.getExistingInt(var1_1.pc);
                                    if (!var5_5) continue;
                                    var1_1.pcPrevBranch = var1_1.pc;
                                }
                                Interpreter.exitFrame(var0, var1_1, null);
                                var17_28 = var1_1.result;
                                var18_89 = var1_1.resultDbl;
                                if (var1_1.parentFrame == null) break;
                                var1_1 = var1_1.parentFrame;
                                if (var1_1.frozen) {
                                    var1_1 = var1_1.cloneFrozen();
                                }
                                Interpreter.setCallResult(var1_1, var17_28, var18_89);
                            }
                            return var17_28 != var3_3 ? var17_28 : ScriptRuntime.wrapNumber(var18_89);
                        }
                        catch (Throwable var10_9) {
                            if (var2_2 != null) {
                                var10_9.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            var2_2 = var10_9;
                        }
                    }
                    if (var2_2 == null) {
                        Kit.codeBug();
                    }
                    var14_18 /* !! */  = null;
                    if (var2_2 instanceof JavaScriptException) {
                        var13_17 = 2;
                    } else if (var2_2 instanceof EcmaError) {
                        var13_17 = 2;
                    } else if (var2_2 instanceof EvaluatorException) {
                        var13_17 = 2;
                    } else if (var2_2 instanceof RuntimeException) {
                        var13_17 = 1;
                    } else if (var2_2 instanceof Error) {
                        var13_17 = 0;
                    } else {
                        var13_17 = 1;
                        var14_18 /* !! */  = (byte[])((ContinuationJump)var2_2);
                    }
                    if (var5_5) {
                        try {
                            Interpreter.addInstructionCount(var0, var1_1, 100);
                        }
                        catch (RuntimeException var15_21) {
                            var2_2 = var15_21;
                            var13_17 = 1;
                        }
                        catch (Error var15_22) {
                            var2_2 = var15_22;
                            var14_18 /* !! */  = null;
                            var13_17 = 0;
                        }
                    }
                    if (var1_1.debuggerFrame != null && var2_2 instanceof RuntimeException) {
                        var15_23 = (RuntimeException)var2_2;
                        try {
                            var1_1.debuggerFrame.onExceptionThrown(var0, var15_23);
                        }
                        catch (Throwable var16_26) {
                            var2_2 = var16_26;
                            var14_18 /* !! */  = null;
                            var13_17 = 0;
                        }
                    }
                    do {
                        if (var13_17 != 0 && (var9_7 = Interpreter.getExceptionHandler(var1_1, var15_24 = var13_17 != 2)) >= 0) continue block142;
                        Interpreter.exitFrame(var0, var1_1, var2_2);
                        var1_1 = var1_1.parentFrame;
                        if (var1_1 == null) break block260;
                    } while (var14_18 /* !! */  == null || var14_18 /* !! */ .branchFrame != var1_1);
                    var9_7 = -1;
                    continue;
                }
                if (var14_18 /* !! */  == null) break block261;
                if (var14_18 /* !! */ .branchFrame != null) {
                    Kit.codeBug();
                }
                if (var14_18 /* !! */ .capturedFrame == null) break;
                var9_7 = -1;
            }
            return var14_18 /* !! */ .result != var3_3 ? var14_18 /* !! */ .result : ScriptRuntime.wrapNumber(var14_18 /* !! */ .resultDbl);
        }
        if (var2_2 instanceof RuntimeException) {
            throw (RuntimeException)var2_2;
        }
        throw (Error)var2_2;
    }

    private static void initFrame(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame, CallFrame callFrame2) {
        int n3;
        double[] dArray2;
        Object[] objectArray2;
        boolean bl;
        int n4;
        int n5;
        Scriptable scriptable3;
        InterpreterData interpreterData = interpretedFunction.idata;
        boolean bl2 = interpreterData.itsNeedsActivation;
        DebugFrame debugFrame = null;
        if (context.debugger != null && (debugFrame = context.debugger.getFrame(context, interpreterData)) != null) {
            bl2 = true;
        }
        if (bl2) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            n = 0;
            dArray = null;
        }
        if (interpreterData.itsFunctionType != 0) {
            scriptable3 = !interpreterData.useDynamicScope ? interpretedFunction.getParentScope() : scriptable;
            if (bl2) {
                scriptable3 = ScriptRuntime.createFunctionActivation(interpretedFunction, scriptable3, objectArray);
            }
        } else {
            scriptable3 = scriptable;
            ScriptRuntime.initScript(interpretedFunction, scriptable2, context, scriptable3, interpretedFunction.idata.evalScriptFlag);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i = 0; i < interpreterData.itsNestedFunctions.length; ++i) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[i];
                if (interpreterData2.itsFunctionType != 1) continue;
                Interpreter.initFunction(context, scriptable3, interpretedFunction, i);
            }
        }
        Scriptable[] scriptableArray = null;
        if (interpreterData.itsRegExpLiterals != null) {
            scriptableArray = interpreterData.itsFunctionType != 0 ? interpretedFunction.functionRegExps : interpretedFunction.createRegExpWraps(context, scriptable3);
        }
        if ((n5 = interpreterData.itsMaxFrameArray) != (n4 = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1) + interpreterData.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (callFrame2.stack != null && n5 <= callFrame2.stack.length) {
            bl = true;
            objectArray2 = callFrame2.stack;
            dArray2 = callFrame2.sDbl;
        } else {
            bl = false;
            objectArray2 = new Object[n5];
            dArray2 = new double[n5];
        }
        int n6 = interpreterData.argCount;
        if (n6 > n2) {
            n6 = n2;
        }
        callFrame2.parentFrame = callFrame;
        callFrame2.frameIndex = callFrame == null ? 0 : callFrame.frameIndex + 1;
        callFrame2.frozen = false;
        callFrame2.fnOrScript = interpretedFunction;
        callFrame2.idata = interpreterData;
        callFrame2.stack = objectArray2;
        callFrame2.sDbl = dArray2;
        callFrame2.varSource = callFrame2;
        callFrame2.localShift = interpreterData.itsMaxVars;
        callFrame2.emptyStackTop = n4;
        callFrame2.debuggerFrame = debugFrame;
        callFrame2.useActivation = bl2;
        callFrame2.thisObj = scriptable2;
        callFrame2.scriptRegExps = scriptableArray;
        callFrame2.result = Undefined.instance;
        callFrame2.pc = 0;
        callFrame2.pcPrevBranch = 0;
        callFrame2.pcSourceLineStart = interpreterData.firstLinePC;
        callFrame2.scope = scriptable3;
        callFrame2.savedStackTop = n4;
        callFrame2.savedCallOp = 0;
        System.arraycopy(objectArray, n, objectArray2, 0, n6);
        if (dArray != null) {
            System.arraycopy(dArray, n, dArray2, 0, n6);
        }
        for (n3 = n6; n3 != interpreterData.itsMaxVars; ++n3) {
            objectArray2[n3] = Undefined.instance;
        }
        if (bl) {
            for (n3 = n4 + 1; n3 != objectArray2.length; ++n3) {
                objectArray2[n3] = null;
            }
        }
        Interpreter.enterFrame(context, callFrame2, objectArray);
    }

    private static boolean isFrameEnterExitRequired(CallFrame callFrame) {
        return callFrame.debuggerFrame != null || callFrame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray) {
        if (callFrame.debuggerFrame != null) {
            callFrame.debuggerFrame.onEnter(context, callFrame.scope, callFrame.thisObj, objectArray);
        }
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.enterActivationFunction(context, callFrame.scope);
        }
    }

    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame != null) {
            try {
                if (object instanceof Throwable) {
                    callFrame.debuggerFrame.onExit(context, true, (Throwable)object);
                } else {
                    ContinuationJump continuationJump = (ContinuationJump)object;
                    Object object2 = continuationJump == null ? callFrame.result : continuationJump.result;
                    if (object2 == UniqueTag.DOUBLE_MARK) {
                        double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                        object2 = ScriptRuntime.wrapNumber(d);
                    }
                    callFrame.debuggerFrame.onExit(context, false, object2);
                }
            }
            catch (Throwable throwable) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 37) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable && object != Undefined.instance) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    private static void captureContinuation(Context context, CallFrame callFrame, int n) {
        Continuation continuation = new Continuation();
        ScriptRuntime.setObjectProtoAndParent(continuation, ScriptRuntime.getTopCallScope(context));
        CallFrame callFrame2 = callFrame.parentFrame;
        while (callFrame2 != null && !callFrame2.frozen) {
            callFrame2.frozen = true;
            for (int i = callFrame2.savedStackTop + 1; i != callFrame2.stack.length; ++i) {
                callFrame2.stack[i] = null;
            }
            if (callFrame2.savedCallOp == 37) {
                callFrame2.stack[callFrame2.savedStackTop] = null;
            } else if (callFrame2.savedCallOp != 30) {
                Kit.codeBug();
            }
            callFrame2 = callFrame2.parentFrame;
        }
        continuation.initImplementation(callFrame.parentFrame);
        callFrame.stack[n] = continuation;
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        double d = object == UniqueTag.DOUBLE_MARK ? callFrame.sDbl[n] : ScriptRuntime.toNumber(object);
        return ScriptRuntime.toInt32(d);
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == Boolean.TRUE) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            return d == d && d != 0.0;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n, Context context) {
        boolean bl;
        double d;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            d = dArray[n + 1];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
                return;
            }
            bl = true;
        } else if (object2 == UniqueTag.DOUBLE_MARK) {
            d = dArray[n];
            object2 = object;
            bl = false;
        } else {
            if (object2 instanceof Scriptable || object instanceof Scriptable) {
                objectArray[n] = ScriptRuntime.add(object2, object, context);
            } else if (object2 instanceof String) {
                String string = (String)object2;
                String string2 = ScriptRuntime.toString(object);
                objectArray[n] = string.concat(string2);
            } else if (object instanceof String) {
                String string = ScriptRuntime.toString(object2);
                String string3 = (String)object;
                objectArray[n] = string.concat(string3);
            } else {
                double d2 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d3 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = d2 + d3;
            }
            return;
        }
        if (object2 instanceof Scriptable) {
            object = ScriptRuntime.wrapNumber(d);
            if (!bl) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            objectArray[n] = ScriptRuntime.add(object2, object, context);
        } else if (object2 instanceof String) {
            String string = (String)object2;
            String string4 = ScriptRuntime.toString(d);
            objectArray[n] = bl ? string.concat(string4) : string4.concat(string);
        } else {
            double d4 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
            objectArray[n] = UniqueTag.DOUBLE_MARK;
            dArray[n] = d4 + d;
        }
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(Continuation continuation, CallFrame callFrame) {
            this.capturedFrame = (CallFrame)continuation.getImplementation();
            if (this.capturedFrame == null || callFrame == null) {
                this.branchFrame = null;
            } else {
                CallFrame callFrame2 = this.capturedFrame;
                CallFrame callFrame3 = callFrame;
                int n = callFrame2.frameIndex - callFrame3.frameIndex;
                if (n != 0) {
                    if (n < 0) {
                        callFrame2 = callFrame;
                        callFrame3 = this.capturedFrame;
                        n = -n;
                    }
                    do {
                        callFrame2 = callFrame2.parentFrame;
                    } while (--n != 0);
                    if (callFrame2.frameIndex != callFrame3.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame2 != callFrame3 && callFrame2 != null) {
                    callFrame2 = callFrame2.parentFrame;
                    callFrame3 = callFrame3.parentFrame;
                }
                this.branchFrame = callFrame2;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        Scriptable thisObj;
        Scriptable[] scriptRegExps;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }
    }
}

