/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    MemberBox[] ctors;

    JavaMembers(Scriptable scriptable, Class clazz) {
        this.cl = clazz;
        this.reflect(scriptable);
    }

    boolean has(String string, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string);
        if (v != null) {
            return true;
        }
        return null != this.findExplicitFunction(string, bl);
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object3 = hashtable.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        Context context = Context.getContext();
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                object2 = beanProperty.getter.invoke(object, Context.emptyArgs);
                clazz = beanProperty.getter.method().getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrap(context, scriptable, object2, clazz);
    }

    void put(Scriptable scriptable, String string, Object object, Object object2, boolean bl) {
        Object object3;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object4 = hashtable.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)hashtable.get(string);
            object4 = ((FieldAndMethods)object3).field;
        }
        if (object4 instanceof BeanProperty) {
            object3 = (BeanProperty)object4;
            if (((BeanProperty)object3).setter == null) {
                throw this.reportMemberNotFound(string);
            }
            Class clazz = ((BeanProperty)object3).setter.argTypes[0];
            Object[] objectArray = new Object[]{NativeJavaObject.coerceType(clazz, object2, true)};
            try {
                ((BeanProperty)object3).setter.invoke(object, objectArray);
            }
            catch (Exception exception) {
                throw Context.throwAsScriptRuntimeEx(exception);
            }
        }
        if (!(object4 instanceof Field)) {
            object3 = object4 == null ? "msg.java.internal.private" : "msg.java.method.assign";
            throw Context.reportRuntimeError1((String)object3, string);
        }
        object3 = (Field)object4;
        Object object5 = NativeJavaObject.coerceType(((Field)object3).getType(), object2, true);
        try {
            ((Field)object3).set(object, object5);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Context.reportRuntimeError3("msg.java.internal.field.type", object2.getClass().getName(), object3, object.getClass().getName());
        }
    }

    Object[] getIds(boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        int n = hashtable.size();
        Object[] objectArray = new Object[n];
        Enumeration enumeration = hashtable.keys();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = enumeration.nextElement();
        }
        return objectArray;
    }

    static String javaSignature(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        String string = clazz.getName();
        String string2 = "[]";
        if (n == 1) {
            return string.concat(string2);
        }
        int n2 = string.length() + n * string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        while (n != 0) {
            --n;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String liveConnectSignature(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(JavaMembers.javaSignature(classArray[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private MemberBox findExplicitFunction(String string, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        int n = string.indexOf(40);
        if (n < 0) {
            return null;
        }
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        MemberBox[] memberBoxArray = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            memberBoxArray = this.ctors;
        } else {
            String string2 = string.substring(0, n);
            object2 = hashtable.get(string2);
            if (!bl && object2 == null) {
                object2 = this.staticMembers.get(string2);
            }
            if (object2 instanceof NativeJavaMethod) {
                object = (NativeJavaMethod)object2;
                memberBoxArray = ((NativeJavaMethod)object).methods;
            }
        }
        if (memberBoxArray != null) {
            for (int i = 0; i < memberBoxArray.length; ++i) {
                object2 = memberBoxArray[i].argTypes;
                object = JavaMembers.liveConnectSignature(object2);
                if (n + ((String)object).length() != string.length() || !string.regionMatches(n, (String)object, 0, ((String)object).length())) continue;
                return memberBoxArray[i];
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        BaseFunction baseFunction = null;
        MemberBox memberBox = this.findExplicitFunction(string, bl);
        if (memberBox != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (memberBox.isCtor()) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor(memberBox);
                nativeJavaConstructor.setPrototype(scriptable2);
                baseFunction = nativeJavaConstructor;
                hashtable.put(string, nativeJavaConstructor);
            } else {
                String string2 = memberBox.getName();
                baseFunction = (BaseFunction)hashtable.get(string2);
                if (baseFunction instanceof NativeJavaMethod && ((NativeJavaMethod)baseFunction).methods.length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod(memberBox, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    hashtable.put(string, nativeJavaMethod);
                    baseFunction = nativeJavaMethod;
                }
            }
        }
        return baseFunction;
    }

    private void reflect(Scriptable scriptable) {
        int n;
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        ClassCache classCache = ClassCache.get(scriptable);
        Method[] methodArray = this.cl.getMethods();
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            Method method = methodArray[n2];
            int n3 = method.getModifiers();
            if (!Modifier.isPublic(n3)) continue;
            boolean bl = Modifier.isStatic(n3);
            object4 = bl ? this.staticMembers : this.members;
            object2 = ((Hashtable)object4).get(object3 = method.getName());
            if (object2 == null) {
                ((Hashtable)object4).put(object3, method);
                continue;
            }
            if (object2 instanceof ObjArray) {
                serializable = (ObjArray)object2;
            } else {
                if (!(object2 instanceof Method)) {
                    Kit.codeBug();
                }
                serializable = new ObjArray();
                serializable.add(object2);
                ((Hashtable)object4).put(object3, serializable);
            }
            serializable.add(method);
        }
        for (n2 = 0; n2 != 2; ++n2) {
            boolean bl = n2 == 0;
            Hashtable hashtable = bl ? this.staticMembers : this.members;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object4 = (String)enumeration.nextElement();
                object2 = hashtable.get(object4);
                if (object2 instanceof Method) {
                    object3 = new MemberBox[]{new MemberBox((Method)object2, classCache)};
                } else {
                    serializable = (ObjArray)object2;
                    int n4 = serializable.size();
                    if (n4 < 2) {
                        Kit.codeBug();
                    }
                    object3 = new MemberBox[n4];
                    for (int i = 0; i != n4; ++i) {
                        object = (Method)serializable.get(i);
                        object3[i] = new MemberBox((Method)object, classCache);
                    }
                }
                serializable = new NativeJavaMethod((MemberBox[])object3);
                if (scriptable != null) {
                    ScriptRuntime.setFunctionProtoAndParent((BaseFunction)serializable, scriptable);
                }
                hashtable.put(object4, serializable);
            }
        }
        Field[] fieldArray = this.cl.getFields();
        for (n = 0; n < fieldArray.length; ++n) {
            Object object5;
            Field field = fieldArray[n];
            int n5 = field.getModifiers();
            if (!Modifier.isPublic(n5)) continue;
            boolean bl = Modifier.isStatic(n5);
            object3 = bl ? this.staticMembers : this.members;
            serializable = ((Hashtable)object3).get(object2 = field.getName());
            if (serializable == null) {
                ((Hashtable)object3).put(object2, field);
                continue;
            }
            if (serializable instanceof NativeJavaMethod) {
                object5 = (NativeJavaMethod)serializable;
                FieldAndMethods fieldAndMethods = new FieldAndMethods(scriptable, ((NativeJavaMethod)object5).methods, field);
                Object object6 = object = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
                if (object == null) {
                    object = new Hashtable<Object, FieldAndMethods>(4);
                    if (bl) {
                        this.staticFieldAndMethods = object;
                    } else {
                        this.fieldAndMethods = object;
                    }
                }
                ((Hashtable)object).put(object2, fieldAndMethods);
                ((Hashtable)object3).put(object2, fieldAndMethods);
                continue;
            }
            if (serializable instanceof Field) {
                object5 = (Field)((Object)serializable);
                if (!((Field)object5).getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                ((Hashtable)object3).put(object2, field);
                continue;
            }
            Kit.codeBug();
        }
        for (n = 0; n != 2; ++n) {
            boolean bl = n == 0;
            Hashtable hashtable = bl ? this.staticMembers : this.members;
            Hashtable<Object, BeanProperty> hashtable2 = new Hashtable<Object, BeanProperty>();
            object3 = hashtable.keys();
            while (object3.hasMoreElements()) {
                Object object7;
                Object v;
                String string;
                object2 = (String)object3.nextElement();
                boolean bl2 = ((String)object2).startsWith("get");
                boolean bl3 = ((String)object2).startsWith("is");
                if (!bl2 && !bl3 || (string = ((String)object2).substring(bl2 ? 3 : 2)).length() == 0) continue;
                object = string;
                char c = string.charAt(0);
                if (Character.isUpperCase(c)) {
                    if (string.length() == 1) {
                        object = string.toLowerCase();
                    } else {
                        char c2 = string.charAt(1);
                        if (!Character.isUpperCase(c2)) {
                            object = Character.toLowerCase(c) + string.substring(1);
                        }
                    }
                }
                if (hashtable.containsKey(object) || !((v = hashtable.get(object2)) instanceof NativeJavaMethod)) continue;
                NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)v;
                MemberBox memberBox = JavaMembers.extractGetMethod(nativeJavaMethod.methods, bl);
                if (memberBox == null) continue;
                NativeJavaMethod nativeJavaMethod2 = null;
                MemberBox memberBox2 = null;
                String string2 = "set".concat(string);
                if (hashtable.containsKey(string2) && (v = hashtable.get(string2)) instanceof NativeJavaMethod) {
                    nativeJavaMethod2 = (NativeJavaMethod)v;
                    object7 = memberBox.method().getReturnType();
                    memberBox2 = JavaMembers.extractSetMethod((Class)object7, nativeJavaMethod2.methods, bl);
                }
                object7 = new BeanProperty(memberBox, memberBox2);
                hashtable2.put(object, (BeanProperty)object7);
            }
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                Object v = hashtable2.get(object2);
                hashtable.put(object2, v);
            }
        }
        Constructor<?>[] constructorArray = this.cl.getConstructors();
        this.ctors = new MemberBox[constructorArray.length];
        for (int i = 0; i != constructorArray.length; ++i) {
            this.ctors[i] = new MemberBox(constructorArray[i], classCache);
        }
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 0; i < memberBoxArray.length; ++i) {
            MemberBox memberBox = memberBoxArray[i];
            if (memberBox.argTypes.length != 0 || bl && !memberBox.isStatic()) continue;
            Class<?> clazz = memberBox.method().getReturnType();
            if (clazz == Void.TYPE) break;
            return memberBox;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class clazz, MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 1; i <= 2; ++i) {
            for (int j = 0; j < memberBoxArray.length; ++j) {
                Class[] classArray;
                MemberBox memberBox = memberBoxArray[j];
                if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || (classArray = memberBox.argTypes).length != 1) continue;
                if (i == 1) {
                    if (classArray[0] != clazz) continue;
                    return memberBox;
                }
                if (i != 2) {
                    Kit.codeBug();
                }
                if (!classArray[0].isAssignableFrom(clazz)) continue;
                return memberBox;
            }
        }
        return null;
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            return null;
        }
        int n = hashtable.size();
        Hashtable<String, FieldAndMethods> hashtable3 = new Hashtable<String, FieldAndMethods>(n);
        Enumeration enumeration = hashtable.elements();
        while (n-- > 0) {
            FieldAndMethods fieldAndMethods = (FieldAndMethods)enumeration.nextElement();
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(scriptable, fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashtable3.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashtable3;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class clazz, Class clazz2) {
        JavaMembers javaMembers;
        ClassCache classCache = ClassCache.get(scriptable);
        Hashtable hashtable = classCache.classTable;
        Class clazz3 = clazz;
        while (true) {
            if ((javaMembers = (JavaMembers)hashtable.get(clazz3)) != null) {
                return javaMembers;
            }
            try {
                javaMembers = new JavaMembers(scriptable, clazz3);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    clazz3 = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    if (clazz3.isInterface()) {
                        clazz4 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                clazz3 = clazz4;
                continue;
            }
            break;
        }
        if (classCache.isCachingEnabled()) {
            hashtable.put(clazz3, javaMembers);
        }
        return javaMembers;
    }

    RuntimeException reportMemberNotFound(String string) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string);
    }
}

