/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    private Hashtable staticFieldAndMethods;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scriptable, Class clazz) {
        this.parent = scriptable;
        this.javaObject = clazz;
        this.initMembers();
    }

    protected void initMembers() {
        Class clazz = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(this.parent, clazz, clazz);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, clazz, true);
    }

    public String getClassName() {
        return "JavaClass";
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, true);
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("prototype")) {
            return null;
        }
        Object object = Scriptable.NOT_FOUND;
        if (this.staticFieldAndMethods != null && (object = this.staticFieldAndMethods.get(string)) != null) {
            return object;
        }
        if (this.members.has(string, true)) {
            object = this.members.get(this, string, this.javaObject, true);
        } else {
            Class clazz = NativeJavaClass.findNestedClass(this.getClassObject(), string);
            if (clazz == null) {
                throw this.members.reportMemberNotFound(string);
            }
            NativeJavaClass nativeJavaClass = new NativeJavaClass(ScriptableObject.getTopLevelScope(this), clazz);
            nativeJavaClass.setParentScope(this);
            object = nativeJavaClass;
        }
        return object;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        this.members.put(this, string, this.javaObject, object, true);
    }

    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof Scriptable) {
            Class clazz = this.getClassObject();
            Scriptable scriptable3 = (Scriptable)objectArray[0];
            do {
                Object object;
                if (!(scriptable3 instanceof Wrapper) || !clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) continue;
                return scriptable3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return this.construct(context, scriptable, objectArray);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        String string;
        Class clazz;
        block5: {
            clazz = this.getClassObject();
            int n = clazz.getModifiers();
            if (!Modifier.isInterface(n) && !Modifier.isAbstract(n)) {
                MemberBox[] memberBoxArray = this.members.ctors;
                int n2 = NativeJavaMethod.findFunction(context, memberBoxArray, objectArray);
                if (n2 < 0) {
                    String string2 = NativeJavaMethod.scriptSignature(objectArray);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", clazz.getName(), string2);
                }
                return NativeJavaClass.constructSpecific(context, scriptable, objectArray, memberBoxArray[n2]);
            }
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
            string = "";
            try {
                Object object = scriptable2.get("JavaAdapter", scriptable2);
                if (object != Scriptable.NOT_FOUND) {
                    Function function = (Function)object;
                    Object[] objectArray2 = new Object[]{this, objectArray[0]};
                    return function.construct(context, scriptable2, objectArray2);
                }
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) break block5;
                string = string3;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", string, clazz.getName());
    }

    static Scriptable constructSpecific(Context context, Scriptable scriptable, Object[] objectArray, MemberBox memberBox) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        Class clazz = memberBox.getDeclaringClass();
        Class[] classArray = memberBox.argTypes;
        Object[] objectArray2 = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = NativeJavaObject.coerceType(classArray[i], object, true);
            if (object2 == object) continue;
            if (objectArray == objectArray2) {
                objectArray = (Object[])objectArray2.clone();
            }
            objectArray[i] = object2;
        }
        Object object = memberBox.newInstance(objectArray);
        return context.getWrapFactory().wrapNewObject(context, scriptable2, object);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof Wrapper && !(scriptable instanceof NativeJavaClass)) {
            Object object = ((Wrapper)((Object)scriptable)).unwrap();
            return this.getClassObject().isInstance(object);
        }
        return false;
    }

    private static Class findNestedClass(Class clazz, String string) {
        String string2 = clazz.getName() + '$' + string;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return Kit.classOrNull(string2);
        }
        return Kit.classOrNull(classLoader, string2);
    }
}

