/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.TokenStream;

public class Parser {
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    private TokenStream ts;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    private String encodedSource;
    ScriptOrFnNode currentScriptOrFn;
    private int nestingOfWith;
    private Hashtable labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnvirons) {
        return new Decompiler();
    }

    void addWarning(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    void addError(String string) {
        ++this.syntaxErrorCount;
        String string2 = ScriptRuntime.getMessage0(string);
        this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    RuntimeException reportError(String string) {
        this.addError(string);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int n = this.currentFlaggedToken;
        if (n == 0) {
            n = this.ts.getToken();
            if (n == 1) {
                while ((n = this.ts.getToken()) == 1) {
                }
                n |= 0x10000;
            }
            this.currentFlaggedToken = n;
        }
        return n & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n) throws IOException {
        int n2 = this.peekToken();
        if (n2 != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 38) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int n, String string) throws IOException, ParserException {
        if (!this.matchToken(n)) {
            this.reportError(string);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    private Node enterLoop(Node node) {
        Node node2 = this.nf.createLoopNode(node, this.ts.getLineno());
        if (this.loopSet == null) {
            this.loopSet = new ObjArray();
            if (this.loopAndSwitchSet == null) {
                this.loopAndSwitchSet = new ObjArray();
            }
        }
        this.loopSet.push(node2);
        this.loopAndSwitchSet.push(node2);
        return node2;
    }

    private void exitLoop() {
        this.loopSet.pop();
        this.loopAndSwitchSet.pop();
    }

    private Node enterSwitch(Node node, int n, Node node2) {
        Node node3 = this.nf.createSwitch(node, n);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(node3);
        return node3;
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.pop();
    }

    public ScriptOrFnNode parse(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            return this.parse();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader reader, String string, int n) throws IOException {
        this.sourceURI = string;
        this.ts = new TokenStream(this, reader, null, n);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        int n;
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        int n2 = this.decompiler.getCurrentOffset();
        this.encodedSource = null;
        this.decompiler.addToken(132);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int n3 = this.ts.getLineno();
        Node node = this.nf.createLeaf(125);
        try {
            while ((n = this.peekToken()) > 0) {
                Node node2;
                block8: {
                    if (n == 105) {
                        this.consumeToken();
                        try {
                            node2 = this.function(1);
                            break block8;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    node2 = this.statement();
                }
                this.nf.addChildToBack(node, node2);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("mag.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            throw this.errorReporter.runtimeError(string, this.sourceURI, n3, null, 0);
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n3);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        this.nf.initScript(this.currentScriptOrFn, node);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node node;
        block10: {
            ++this.nestingOfFunction;
            node = this.nf.createBlock(this.ts.getLineno());
            try {
                while (true) {
                    Node node2;
                    int n = this.peekToken();
                    switch (n) {
                        case -1: 
                        case 0: 
                        case 82: {
                            break block10;
                        }
                        case 105: {
                            this.consumeToken();
                            node2 = this.function(1);
                            break;
                        }
                        default: {
                            node2 = this.statement();
                        }
                    }
                    this.nf.addChildToBack(node, node2);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int n) throws IOException, ParserException {
        int n2;
        Node node;
        String string;
        int n3 = n;
        int n4 = this.ts.getLineno();
        int n5 = this.decompiler.markFunctionStart(n);
        Node node2 = null;
        if (this.matchToken(38)) {
            string = this.ts.getString();
            this.decompiler.addName(string);
            if (!this.matchToken(83)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node node3 = this.nf.createName(string);
                    string = "";
                    node2 = this.memberExprTail(false, node3);
                }
                this.mustMatchToken(83, "msg.no.paren.parms");
            }
        } else if (this.matchToken(83)) {
            string = "";
        } else {
            string = "";
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                node2 = this.memberExpr(false);
            }
            this.mustMatchToken(83, "msg.no.paren.parms");
        }
        if (node2 != null) {
            n3 = 2;
        }
        boolean bl = this.insideFunction();
        FunctionNode functionNode = this.nf.createFunction(string);
        if (bl || this.nestingOfWith > 0) {
            functionNode.itsIgnoreDynamicScope = true;
        }
        int n6 = this.currentScriptOrFn.addFunction(functionNode);
        ScriptOrFnNode scriptOrFnNode = this.currentScriptOrFn;
        this.currentScriptOrFn = functionNode;
        int n7 = this.nestingOfWith;
        this.nestingOfWith = 0;
        Hashtable hashtable = this.labelSet;
        this.labelSet = null;
        ObjArray objArray = this.loopSet;
        this.loopSet = null;
        ObjArray objArray2 = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        try {
            int n8;
            this.decompiler.addToken(83);
            if (!this.matchToken(84)) {
                n8 = 1;
                do {
                    if (n8 == 0) {
                        this.decompiler.addToken(85);
                    }
                    n8 = 0;
                    this.mustMatchToken(38, "msg.no.parm");
                    String string2 = this.ts.getString();
                    if (functionNode.hasParamOrVar(string2)) {
                        this.addWarning("msg.dup.parms", string2);
                    }
                    functionNode.addParam(string2);
                    this.decompiler.addName(string2);
                } while (this.matchToken(85));
                this.mustMatchToken(84, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(84);
            this.mustMatchToken(81, "msg.no.brace.body");
            this.decompiler.addEOL(81);
            node = this.parseFunctionBody();
            this.mustMatchToken(82, "msg.no.brace.after.body");
            this.decompiler.addToken(82);
            n2 = this.decompiler.markFunctionEnd(n5);
            if (n != 2) {
                if (this.compilerEnv.getLanguageVersion() >= 120 && (n8 = this.peekTokenOrEOL()) == 105) {
                    this.reportError("msg.no.semi.stmt");
                }
                this.decompiler.addToken(1);
            }
            Object var21_21 = null;
            this.loopAndSwitchSet = objArray2;
            this.loopSet = objArray;
            this.labelSet = hashtable;
            this.nestingOfWith = n7;
            this.currentScriptOrFn = scriptOrFnNode;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            this.loopAndSwitchSet = objArray2;
            this.loopSet = objArray;
            this.labelSet = hashtable;
            this.nestingOfWith = n7;
            this.currentScriptOrFn = scriptOrFnNode;
            throw throwable;
        }
        functionNode.setEncodedSourceBounds(n5, n2);
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n4);
        functionNode.setEndLineno(this.ts.getLineno());
        Node node4 = this.nf.initFunction(functionNode, n6, node, n3);
        if (node2 != null) {
            node4 = this.nf.initFunction(functionNode, n6, node, n3);
            node4 = this.nf.createAssignment(86, node2, node4);
            if (n != 2) {
                node4 = this.nf.createExprStatementNoReturn(node4, n4);
            }
        }
        return node4;
    }

    private Node statements() throws IOException {
        int n;
        Node node = this.nf.createBlock(this.ts.getLineno());
        while ((n = this.peekToken()) > 0 && n != 82) {
            this.nf.addChildToBack(node, this.statement());
        }
        return node;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(83, "msg.no.paren.cond");
        this.decompiler.addToken(83);
        Node node = this.expr(false);
        this.mustMatchToken(84, "msg.no.paren.after.cond");
        this.decompiler.addToken(84);
        return node;
    }

    private Node matchJumpLabelName() throws IOException, ParserException {
        Node node = null;
        int n = this.peekTokenOrEOL();
        if (n == 38) {
            this.consumeToken();
            String string = this.ts.getString();
            this.decompiler.addName(string);
            if (this.labelSet != null) {
                node = (Node)this.labelSet.get(string);
            }
            if (node == null) {
                this.reportError("msg.undef.label");
            }
        }
        return node;
    }

    private Node statement() throws IOException {
        try {
            Node node = this.statementHelper(null);
            if (node != null) {
                return node;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        int n = this.ts.getLineno();
        block5: while (true) {
            int n2 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 78: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.nf.createExprStatement(this.nf.createName("error"), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node statementHelper(Node node) throws IOException, ParserException {
        int n;
        Node node2 = null;
        int n2 = this.peekToken();
        switch (n2) {
            case 108: {
                this.consumeToken();
                this.decompiler.addToken(108);
                int n3 = this.ts.getLineno();
                Node node3 = this.condition();
                this.decompiler.addEOL(81);
                Node node4 = this.statement();
                Node node5 = null;
                if (this.matchToken(109)) {
                    this.decompiler.addToken(82);
                    this.decompiler.addToken(109);
                    this.decompiler.addEOL(81);
                    node5 = this.statement();
                }
                this.decompiler.addEOL(82);
                node2 = this.nf.createIf(node3, node4, node5, n3);
                return node2;
            }
            case 110: {
                this.consumeToken();
                this.decompiler.addToken(110);
                int n4 = this.ts.getLineno();
                this.mustMatchToken(83, "msg.no.paren.switch");
                this.decompiler.addToken(83);
                node2 = this.enterSwitch(this.expr(false), n4, node);
                try {
                    this.mustMatchToken(84, "msg.no.paren.after.switch");
                    this.decompiler.addToken(84);
                    this.mustMatchToken(81, "msg.no.brace.switch");
                    this.decompiler.addEOL(81);
                    boolean bl = false;
                    block49: while (true) {
                        Node node6;
                        n2 = this.nextToken();
                        switch (n2) {
                            case 82: {
                                break block49;
                            }
                            case 111: {
                                this.decompiler.addToken(111);
                                node6 = this.expr(false);
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            case 112: {
                                if (bl) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(112);
                                bl = true;
                                node6 = null;
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block49;
                            }
                        }
                        Node node7 = this.nf.createLeaf(125);
                        while ((n2 = this.peekToken()) != 82 && n2 != 111 && n2 != 112 && n2 != 0) {
                            this.nf.addChildToBack(node7, this.statement());
                        }
                        this.nf.addSwitchCase(node2, node6, node7);
                    }
                    this.decompiler.addEOL(82);
                    this.nf.closeSwitch(node2);
                }
                finally {
                    this.exitSwitch();
                }
                return node2;
            }
            case 113: {
                this.consumeToken();
                this.decompiler.addToken(113);
                Node node8 = this.enterLoop(node);
                try {
                    Node node9 = this.condition();
                    this.decompiler.addEOL(81);
                    Node node10 = this.statement();
                    this.decompiler.addEOL(82);
                    node2 = this.nf.createWhile(node8, node9, node10);
                }
                finally {
                    this.exitLoop();
                }
                return node2;
            }
            case 114: {
                this.consumeToken();
                this.decompiler.addToken(114);
                this.decompiler.addEOL(81);
                Node node11 = this.enterLoop(node);
                try {
                    Node node12 = this.statement();
                    this.decompiler.addToken(82);
                    this.mustMatchToken(113, "msg.no.while.do");
                    this.decompiler.addToken(113);
                    Node node13 = this.condition();
                    node2 = this.nf.createDoWhile(node11, node12, node13);
                }
                finally {
                    this.exitLoop();
                }
                this.matchToken(78);
                this.decompiler.addEOL(78);
                return node2;
            }
            case 115: {
                this.consumeToken();
                boolean bl = false;
                this.decompiler.addToken(115);
                Node node14 = this.enterLoop(node);
                try {
                    Node node15;
                    Node node16;
                    Node node17 = null;
                    if (this.matchToken(38)) {
                        this.decompiler.addName(this.ts.getString());
                        if (this.ts.getString().equals("each")) {
                            bl = true;
                        } else {
                            this.reportError("msg.no.paren.for");
                        }
                    }
                    this.mustMatchToken(83, "msg.no.paren.for");
                    this.decompiler.addToken(83);
                    n2 = this.peekToken();
                    if (n2 == 78) {
                        node16 = this.nf.createLeaf(124);
                    } else if (n2 == 118) {
                        this.consumeToken();
                        node16 = this.variables(true);
                    } else {
                        node16 = this.expr(true);
                    }
                    if (this.matchToken(51)) {
                        this.decompiler.addToken(51);
                        node15 = this.expr(false);
                    } else {
                        this.mustMatchToken(78, "msg.no.semi.for");
                        this.decompiler.addToken(78);
                        node15 = this.peekToken() == 78 ? this.nf.createLeaf(124) : this.expr(false);
                        this.mustMatchToken(78, "msg.no.semi.for.cond");
                        this.decompiler.addToken(78);
                        node17 = this.peekToken() == 84 ? this.nf.createLeaf(124) : this.expr(false);
                    }
                    this.mustMatchToken(84, "msg.no.paren.for.ctrl");
                    this.decompiler.addToken(84);
                    this.decompiler.addEOL(81);
                    Node node18 = this.statement();
                    this.decompiler.addEOL(82);
                    node2 = node17 == null ? this.nf.createForIn(node14, node16, node15, node18, bl) : this.nf.createFor(node14, node16, node15, node17, node18);
                }
                finally {
                    this.exitLoop();
                }
                return node2;
            }
            case 77: {
                this.consumeToken();
                int n5 = this.ts.getLineno();
                Node node19 = null;
                Node node20 = null;
                this.decompiler.addToken(77);
                this.decompiler.addEOL(81);
                Node node21 = this.statement();
                this.decompiler.addEOL(82);
                node19 = this.nf.createLeaf(125);
                boolean bl = false;
                int n6 = this.peekToken();
                if (n6 == 120) {
                    while (this.matchToken(120)) {
                        if (bl) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(120);
                        this.mustMatchToken(83, "msg.no.paren.catch");
                        this.decompiler.addToken(83);
                        this.mustMatchToken(38, "msg.bad.catchcond");
                        String string = this.ts.getString();
                        this.decompiler.addName(string);
                        Node node22 = null;
                        if (this.matchToken(108)) {
                            this.decompiler.addToken(108);
                            node22 = this.expr(false);
                        } else {
                            bl = true;
                        }
                        this.mustMatchToken(84, "msg.bad.catchcond");
                        this.decompiler.addToken(84);
                        this.mustMatchToken(81, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(81);
                        this.nf.addChildToBack(node19, this.nf.createCatch(string, node22, this.statements(), this.ts.getLineno()));
                        this.mustMatchToken(82, "msg.no.brace.after.body");
                        this.decompiler.addEOL(82);
                    }
                } else if (n6 != 121) {
                    this.mustMatchToken(121, "msg.try.no.catchfinally");
                }
                if (this.matchToken(121)) {
                    this.decompiler.addToken(121);
                    this.decompiler.addEOL(81);
                    node20 = this.statement();
                    this.decompiler.addEOL(82);
                }
                node2 = this.nf.createTryCatchFinally(node21, node19, node20, n5);
                return node2;
            }
            case 49: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                n = this.ts.getLineno();
                this.decompiler.addToken(49);
                node2 = this.nf.createThrow(this.expr(false), n);
                break;
            }
            case 116: {
                this.consumeToken();
                n = this.ts.getLineno();
                this.decompiler.addToken(116);
                Node node23 = this.matchJumpLabelName();
                if (node23 == null) {
                    if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                        this.reportError("msg.bad.break");
                        return null;
                    }
                    node23 = (Node)this.loopAndSwitchSet.peek();
                }
                node2 = this.nf.createBreak(node23, n);
                break;
            }
            case 117: {
                Node node24;
                this.consumeToken();
                n = this.ts.getLineno();
                this.decompiler.addToken(117);
                Node node25 = this.matchJumpLabelName();
                if (node25 == null) {
                    if (this.loopSet == null || this.loopSet.size() == 0) {
                        this.reportError("msg.continue.outside");
                        return null;
                    }
                    node24 = (Node)this.loopSet.peek();
                } else {
                    node24 = this.nf.getLabelLoop(node25);
                    if (node24 == null) {
                        this.reportError("msg.continue.nonloop");
                        return null;
                    }
                }
                node2 = this.nf.createContinue(node24, n);
                break;
            }
            case 119: {
                Node node26;
                this.consumeToken();
                this.decompiler.addToken(119);
                int n7 = this.ts.getLineno();
                this.mustMatchToken(83, "msg.no.paren.with");
                this.decompiler.addToken(83);
                Node node27 = this.expr(false);
                this.mustMatchToken(84, "msg.no.paren.after.with");
                this.decompiler.addToken(84);
                this.decompiler.addEOL(81);
                ++this.nestingOfWith;
                try {
                    node26 = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(82);
                node2 = this.nf.createWith(node27, node26, n7);
                return node2;
            }
            case 118: {
                this.consumeToken();
                node2 = this.variables(false);
                break;
            }
            case 4: {
                Node node28;
                if (!this.insideFunction()) {
                    this.reportError("msg.bad.return");
                }
                this.consumeToken();
                this.decompiler.addToken(4);
                n = this.ts.getLineno();
                n2 = this.peekTokenOrEOL();
                switch (n2) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 78: 
                    case 82: {
                        node28 = null;
                        break;
                    }
                    default: {
                        node28 = this.expr(false);
                    }
                }
                node2 = this.nf.createReturn(node28, n);
                break;
            }
            case 81: {
                this.consumeToken();
                if (node != null) {
                    this.decompiler.addToken(81);
                }
                node2 = this.statements();
                this.mustMatchToken(82, "msg.no.brace.block");
                if (node != null) {
                    this.decompiler.addEOL(82);
                }
                return node2;
            }
            case -1: 
            case 78: {
                this.consumeToken();
                node2 = this.nf.createLeaf(124);
                return node2;
            }
            case 105: {
                this.consumeToken();
                node2 = this.function(3);
                return node2;
            }
            case 112: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(112);
                n = this.ts.getLineno();
                if (!this.matchToken(38) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(this.ts.getString());
                if (!this.matchToken(38) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(this.ts.getString());
                if (!this.matchToken(86)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(86);
                Node node29 = this.expr(false);
                node2 = this.nf.createDefaultNamespace(node29, n);
                break;
            }
            case 38: {
                boolean bl;
                int n8 = this.ts.getLineno();
                String string = this.ts.getString();
                this.setCheckForLabel();
                node2 = this.expr(false);
                if (node2.getType() != 126) {
                    node2 = this.nf.createExprStatement(node2, n8);
                    break;
                }
                if (this.peekToken() != 99) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(string);
                this.decompiler.addEOL(99);
                if (this.labelSet == null) {
                    this.labelSet = new Hashtable();
                } else if (this.labelSet.containsKey(string)) {
                    this.reportError("msg.dup.label");
                }
                if (node == null) {
                    bl = true;
                    node = node2;
                } else {
                    bl = false;
                }
                this.labelSet.put(string, node);
                try {
                    node2 = this.statementHelper(node);
                }
                finally {
                    this.labelSet.remove(string);
                }
                if (bl) {
                    node2 = this.nf.createLabeledStatement(node, node2);
                }
                return node2;
            }
            default: {
                int n9 = this.ts.getLineno();
                node2 = this.expr(false);
                node2 = this.nf.createExprStatement(node2, n9);
            }
        }
        n = this.peekFlaggedToken();
        switch (n & 0xFFFF) {
            case 78: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 82: {
                break;
            }
            default: {
                if ((n & 0x10000) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(78);
        return node2;
    }

    private Node variables(boolean bl) throws IOException, ParserException {
        Node node = this.nf.createVariables(this.ts.getLineno());
        boolean bl2 = true;
        this.decompiler.addToken(118);
        do {
            this.mustMatchToken(38, "msg.bad.var");
            String string = this.ts.getString();
            if (!bl2) {
                this.decompiler.addToken(85);
            }
            bl2 = false;
            this.decompiler.addName(string);
            this.currentScriptOrFn.addVar(string);
            Node node2 = this.nf.createName(string);
            if (this.matchToken(86)) {
                this.decompiler.addToken(86);
                Node node3 = this.assignExpr(bl);
                this.nf.addChildToBack(node2, node3);
            }
            this.nf.addChildToBack(node, node2);
        } while (this.matchToken(85));
        return node;
    }

    private Node expr(boolean bl) throws IOException, ParserException {
        Node node = this.assignExpr(bl);
        while (this.matchToken(85)) {
            this.decompiler.addToken(85);
            node = this.nf.createBinary(85, node, this.assignExpr(bl));
        }
        return node;
    }

    private Node assignExpr(boolean bl) throws IOException, ParserException {
        Node node = this.condExpr(bl);
        int n = this.peekToken();
        if (86 <= n && n <= 97) {
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createAssignment(n, node, this.assignExpr(bl));
        }
        return node;
    }

    private Node condExpr(boolean bl) throws IOException, ParserException {
        Node node = this.orExpr(bl);
        if (this.matchToken(98)) {
            this.decompiler.addToken(98);
            Node node2 = this.assignExpr(false);
            this.mustMatchToken(99, "msg.no.colon.cond");
            this.decompiler.addToken(99);
            Node node3 = this.assignExpr(bl);
            return this.nf.createCondExpr(node, node2, node3);
        }
        return node;
    }

    private Node orExpr(boolean bl) throws IOException, ParserException {
        Node node = this.andExpr(bl);
        if (this.matchToken(100)) {
            this.decompiler.addToken(100);
            node = this.nf.createBinary(100, node, this.orExpr(bl));
        }
        return node;
    }

    private Node andExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitOrExpr(bl);
        if (this.matchToken(101)) {
            this.decompiler.addToken(101);
            node = this.nf.createBinary(101, node, this.andExpr(bl));
        }
        return node;
    }

    private Node bitOrExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitXorExpr(bl);
        while (this.matchToken(9)) {
            this.decompiler.addToken(9);
            node = this.nf.createBinary(9, node, this.bitXorExpr(bl));
        }
        return node;
    }

    private Node bitXorExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitAndExpr(bl);
        while (this.matchToken(10)) {
            this.decompiler.addToken(10);
            node = this.nf.createBinary(10, node, this.bitAndExpr(bl));
        }
        return node;
    }

    private Node bitAndExpr(boolean bl) throws IOException, ParserException {
        Node node = this.eqExpr(bl);
        while (this.matchToken(11)) {
            this.decompiler.addToken(11);
            node = this.nf.createBinary(11, node, this.eqExpr(bl));
        }
        return node;
    }

    private Node eqExpr(boolean bl) throws IOException, ParserException {
        Node node = this.relExpr(bl);
        block9: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 12: 
                case 13: 
                case 45: 
                case 46: {
                    this.consumeToken();
                    int n2 = n;
                    int n3 = n;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (n) {
                            case 12: {
                                n3 = 45;
                                break;
                            }
                            case 13: {
                                n3 = 46;
                                break;
                            }
                            case 45: {
                                n2 = 12;
                                break;
                            }
                            case 46: {
                                n2 = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n3, node, this.relExpr(bl));
                    continue block9;
                }
            }
            break;
        }
        return node;
    }

    private Node relExpr(boolean bl) throws IOException, ParserException {
        Node node = this.shiftExpr();
        block4: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 51: {
                    if (bl) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 52: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        return node;
    }

    private Node shiftExpr() throws IOException, ParserException {
        Node node = this.addExpr();
        block3: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        return node;
    }

    private Node addExpr() throws IOException, ParserException {
        int n;
        Node node = this.mulExpr();
        while ((n = this.peekToken()) == 21 || n == 22) {
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createBinary(n, node, this.mulExpr());
        }
        return node;
    }

    private Node mulExpr() throws IOException, ParserException {
        Node node = this.unaryExpr();
        block3: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        return node;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int n = this.peekToken();
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 122: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.nf.createUnary(n, this.unaryExpr());
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.nf.createUnary(28, this.unaryExpr());
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr());
            }
            case 102: 
            case 103: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.nf.createIncDec(n, false, this.memberExpr(true));
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.nf.createUnary(31, this.unaryExpr());
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node node = this.xmlInitializer();
                    return this.memberExprTail(true, node);
                }
            }
            default: {
                Node node = this.memberExpr(true);
                n = this.peekTokenOrEOL();
                if (n == 102 || n == 103) {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    return this.nf.createIncDec(n, true, node);
                }
                return node;
            }
        }
        return this.nf.createName("err");
    }

    private Node xmlInitializer() throws IOException {
        int n = this.ts.getFirstXMLToken();
        if (n != 141 && n != 144) {
            this.reportError("msg.syntax");
            return null;
        }
        Node node = this.nf.createLeaf(30);
        this.decompiler.addToken(30);
        this.decompiler.addToken(104);
        String string = this.ts.getString();
        boolean bl = string.trim().startsWith("<>");
        this.decompiler.addName(bl ? "XMLList" : "XML");
        Node node2 = this.nf.createName(bl ? "XMLList" : "XML");
        this.nf.addChildToBack(node, node2);
        node2 = null;
        while (true) {
            switch (n) {
                case 141: {
                    string = this.ts.getString();
                    this.decompiler.addString(string);
                    this.mustMatchToken(81, "msg.syntax");
                    this.decompiler.addToken(81);
                    Node node3 = this.peekToken() == 82 ? this.nf.createString("") : this.expr(false);
                    this.mustMatchToken(82, "msg.syntax");
                    this.decompiler.addToken(82);
                    node2 = node2 == null ? this.nf.createString(string) : this.nf.createBinary(21, node2, this.nf.createString(string));
                    int n2 = this.ts.isXMLAttribute() ? 71 : 72;
                    node3 = this.nf.createUnary(n2, node3);
                    node2 = this.nf.createBinary(21, node2, node3);
                    break;
                }
                case 144: {
                    string = this.ts.getString();
                    this.decompiler.addString(string);
                    node2 = node2 == null ? this.nf.createString(string) : this.nf.createBinary(21, node2, this.nf.createString(string));
                    this.nf.addChildToBack(node, node2);
                    return node;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            n = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node node) throws IOException, ParserException {
        boolean bl = this.matchToken(84);
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    this.decompiler.addToken(85);
                }
                bl2 = false;
                this.nf.addChildToBack(node, this.assignExpr(false));
            } while (this.matchToken(85));
            this.mustMatchToken(84, "msg.no.paren.arg");
        }
        this.decompiler.addToken(84);
    }

    private Node memberExpr(boolean bl) throws IOException, ParserException {
        Node node;
        int n = this.peekToken();
        if (n == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            node = this.nf.createCallOrNew(30, this.memberExpr(false));
            if (this.matchToken(83)) {
                this.decompiler.addToken(83);
                this.argumentList(node);
            }
            if ((n = this.peekToken()) == 81) {
                this.nf.addChildToBack(node, this.primaryExpr());
            }
        } else {
            node = this.primaryExpr();
        }
        return this.memberExprTail(bl, node);
    }

    private Node memberExprTail(boolean bl, Node node) throws IOException, ParserException {
        block11: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 104: 
                case 139: {
                    String string;
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    int n2 = 0;
                    if (n == 139) {
                        this.mustHaveXML();
                        n2 = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(38, "msg.no.name.after.dot");
                        string = this.ts.getString();
                        this.decompiler.addName(string);
                        node = this.nf.createPropertyGet(node, null, string, n2);
                        continue block11;
                    }
                    n = this.nextToken();
                    switch (n) {
                        case 38: {
                            string = this.ts.getString();
                            this.decompiler.addName(string);
                            node = this.propertyName(node, string, n2);
                            continue block11;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            node = this.propertyName(node, "*", n2);
                            continue block11;
                        }
                        case 143: {
                            this.decompiler.addToken(143);
                            node = this.attributeAccess(node, n2);
                            continue block11;
                        }
                    }
                    this.reportError("msg.no.name.after.dot");
                    continue block11;
                }
                case 142: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(142);
                    node = this.nf.createDotQuery(node, this.expr(false), this.ts.getLineno());
                    this.mustMatchToken(84, "msg.no.paren");
                    continue block11;
                }
                case 79: {
                    this.consumeToken();
                    this.decompiler.addToken(79);
                    node = this.nf.createElementGet(node, null, this.expr(false), 0);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    continue block11;
                }
                case 83: {
                    if (!bl) break block11;
                    this.consumeToken();
                    this.decompiler.addToken(83);
                    node = this.nf.createCallOrNew(37, node);
                    this.argumentList(node);
                    continue block11;
                }
            }
            break;
        }
        return node;
    }

    private Node attributeAccess(Node node, int n) throws IOException {
        n |= 2;
        int n2 = this.nextToken();
        switch (n2) {
            case 38: {
                String string = this.ts.getString();
                this.decompiler.addName(string);
                node = this.propertyName(node, string, n);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                node = this.propertyName(node, "*", n);
                break;
            }
            case 79: {
                this.decompiler.addToken(79);
                node = this.nf.createElementGet(node, null, this.expr(false), n);
                this.mustMatchToken(80, "msg.no.bracket.index");
                this.decompiler.addToken(80);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                node = this.nf.createPropertyGet(node, null, "?", n);
            }
        }
        return node;
    }

    private Node propertyName(Node node, String string, int n) throws IOException, ParserException {
        String string2 = null;
        if (this.matchToken(140)) {
            this.decompiler.addToken(140);
            string2 = string;
            int n2 = this.nextToken();
            switch (n2) {
                case 38: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    string = "*";
                    break;
                }
                case 79: {
                    this.decompiler.addToken(79);
                    node = this.nf.createElementGet(node, string2, this.expr(false), n);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    return node;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    string = "?";
                }
            }
        }
        node = this.nf.createPropertyGet(node, string2, string, n);
        return node;
    }

    private Node primaryExpr() throws IOException, ParserException {
        int n = this.nextFlaggedToken();
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 105: {
                return this.function(2);
            }
            case 79: {
                ObjArray objArray = new ObjArray();
                int n3 = 0;
                this.decompiler.addToken(79);
                boolean bl = true;
                while (true) {
                    if ((n2 = this.peekToken()) == 85) {
                        this.consumeToken();
                        this.decompiler.addToken(85);
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        objArray.add(null);
                        ++n3;
                        continue;
                    }
                    if (n2 == 80) break;
                    if (!bl) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    objArray.add(this.assignExpr(false));
                    bl = false;
                }
                this.consumeToken();
                this.decompiler.addToken(80);
                return this.nf.createArrayLiteral(objArray, n3);
            }
            case 81: {
                ObjArray objArray = new ObjArray();
                this.decompiler.addToken(81);
                if (!this.matchToken(82)) {
                    boolean bl = true;
                    block21: do {
                        Object object;
                        if (!bl) {
                            this.decompiler.addToken(85);
                        } else {
                            bl = false;
                        }
                        n2 = this.peekToken();
                        switch (n2) {
                            case 38: 
                            case 40: {
                                this.consumeToken();
                                String string = this.ts.getString();
                                if (n2 == 38) {
                                    this.decompiler.addName(string);
                                } else {
                                    this.decompiler.addString(string);
                                }
                                object = ScriptRuntime.getIndexObject(string);
                                break;
                            }
                            case 39: {
                                this.consumeToken();
                                double d = this.ts.getNumber();
                                this.decompiler.addNumber(d);
                                object = ScriptRuntime.getIndexObject(d);
                                break;
                            }
                            case 82: {
                                break block21;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block21;
                            }
                        }
                        this.mustMatchToken(99, "msg.no.colon.prop");
                        this.decompiler.addToken(64);
                        objArray.add(object);
                        objArray.add(this.assignExpr(false));
                    } while (this.matchToken(85));
                    this.mustMatchToken(82, "msg.no.brace.prop");
                }
                this.decompiler.addToken(82);
                return this.nf.createObjectLiteral(objArray);
            }
            case 83: {
                this.decompiler.addToken(83);
                Node node = this.expr(false);
                this.decompiler.addToken(84);
                this.mustMatchToken(84, "msg.no.paren");
                return node;
            }
            case 143: {
                this.mustHaveXML();
                this.decompiler.addToken(143);
                Node node = this.attributeAccess(null, 0);
                return node;
            }
            case 38: {
                String string = this.ts.getString();
                if ((n & 0x20000) != 0 && this.peekToken() == 99) {
                    return this.nf.createLabel(this.ts.getLineno());
                }
                this.decompiler.addName(string);
                Node node = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, string, 0) : this.nf.createName(string);
                return node;
            }
            case 39: {
                double d = this.ts.getNumber();
                this.decompiler.addNumber(d);
                return this.nf.createNumber(d);
            }
            case 40: {
                String string = this.ts.getString();
                this.decompiler.addString(string);
                return this.nf.createString(string);
            }
            case 24: 
            case 96: {
                this.ts.readRegExp(n2);
                String string = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String string2 = this.ts.getString();
                this.decompiler.addRegexp(string2, string);
                int n4 = this.currentScriptOrFn.addRegexp(string2, string);
                return this.nf.createRegExp(n4);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.decompiler.addToken(n2);
                return this.nf.createLeaf(n2);
            }
            case 123: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    private static class ParserException
    extends RuntimeException {
        private ParserException() {
        }
    }
}

