/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;

public class ScriptOrFnNode
extends Node {
    private int encodedSourceStart;
    private int encodedSourceEnd;
    private String sourceName;
    private int baseLineno = -1;
    private int endLineno = -1;
    private ObjArray functions;
    private ObjArray regexps;
    private ObjArray itsVariables = new ObjArray();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    private int varStart;
    private Object compilerData;

    public ScriptOrFnNode(int n) {
        super(n);
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final void setSourceName(String string) {
        this.sourceName = string;
    }

    public final int getEncodedSourceStart() {
        return this.encodedSourceStart;
    }

    public final int getEncodedSourceEnd() {
        return this.encodedSourceEnd;
    }

    public final void setEncodedSourceBounds(int n, int n2) {
        this.encodedSourceStart = n;
        this.encodedSourceEnd = n2;
    }

    public final int getBaseLineno() {
        return this.baseLineno;
    }

    public final void setBaseLineno(int n) {
        if (n < 0 || this.baseLineno >= 0) {
            Kit.codeBug();
        }
        this.baseLineno = n;
    }

    public final int getEndLineno() {
        return this.baseLineno;
    }

    public final void setEndLineno(int n) {
        if (n < 0 || this.endLineno >= 0) {
            Kit.codeBug();
        }
        this.endLineno = n;
    }

    public final int getFunctionCount() {
        if (this.functions == null) {
            return 0;
        }
        return this.functions.size();
    }

    public final FunctionNode getFunctionNode(int n) {
        return (FunctionNode)this.functions.get(n);
    }

    public final int addFunction(FunctionNode functionNode) {
        if (functionNode == null) {
            Kit.codeBug();
        }
        if (this.functions == null) {
            this.functions = new ObjArray();
        }
        this.functions.add(functionNode);
        return this.functions.size() - 1;
    }

    public final int getRegexpCount() {
        if (this.regexps == null) {
            return 0;
        }
        return this.regexps.size() / 2;
    }

    public final String getRegexpString(int n) {
        return (String)this.regexps.get(n * 2);
    }

    public final String getRegexpFlags(int n) {
        return (String)this.regexps.get(n * 2 + 1);
    }

    public final int addRegexp(String string, String string2) {
        if (string == null) {
            Kit.codeBug();
        }
        if (this.regexps == null) {
            this.regexps = new ObjArray();
        }
        this.regexps.add(string);
        this.regexps.add(string2);
        return this.regexps.size() / 2 - 1;
    }

    public final boolean hasParamOrVar(String string) {
        return this.itsVariableNames.has(string);
    }

    public final int getParamOrVarIndex(String string) {
        return this.itsVariableNames.get(string, -1);
    }

    public final String getParamOrVarName(int n) {
        return (String)this.itsVariables.get(n);
    }

    public final int getParamCount() {
        return this.varStart;
    }

    public final int getParamAndVarCount() {
        return this.itsVariables.size();
    }

    public final String[] getParamAndVarNames() {
        int n = this.itsVariables.size();
        if (n == 0) {
            return ScriptRuntime.emptyStrings;
        }
        Object[] objectArray = new String[n];
        this.itsVariables.toArray(objectArray);
        return objectArray;
    }

    public final void addParam(String string) {
        if (this.varStart != this.itsVariables.size()) {
            Kit.codeBug();
        }
        int n = this.varStart++;
        this.itsVariables.add(string);
        this.itsVariableNames.put(string, n);
    }

    public final void addVar(String string) {
        int n = this.itsVariableNames.get(string, -1);
        if (n != -1) {
            return;
        }
        int n2 = this.itsVariables.size();
        this.itsVariables.add(string);
        this.itsVariableNames.put(string, n2);
    }

    public final void removeParamOrVar(String string) {
        int n = this.itsVariableNames.get(string, -1);
        if (n != -1) {
            this.itsVariables.remove(n);
            this.itsVariableNames.remove(string);
            ObjToIntMap.Iterator iterator = this.itsVariableNames.newIterator();
            iterator.start();
            while (!iterator.done()) {
                int n2 = iterator.getValue();
                if (n2 > n) {
                    iterator.setValue(n2 - 1);
                }
                iterator.next();
            }
        }
    }

    public final Object getCompilerData() {
        return this.compilerData;
    }

    public final void setCompilerData(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerData != null) {
            throw new IllegalStateException();
        }
        this.compilerData = object;
    }
}

