/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.continuations;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Scriptable;

public final class Continuation
extends IdScriptableObject
implements Function {
    private static final Object FTAG = new Object();
    private Object implementation;
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        Continuation continuation = new Continuation();
        continuation.exportAsJSClass(1, scriptable, bl);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public void initImplementation(Object object) {
        this.implementation = object;
    }

    public String getClassName() {
        return "Continuation";
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw Context.reportRuntimeError("Direct call is not supported");
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return Interpreter.restartContinuation(this, context, scriptable, objectArray);
    }

    public static boolean isContinuationConstructor(IdFunctionObject idFunctionObject) {
        return idFunctionObject.hasTag(FTAG) && idFunctionObject.methodId() == 1;
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(FTAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(FTAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                throw Context.reportRuntimeError("Direct call is not supported");
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        if (string.length() == 11) {
            string2 = "constructor";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

