/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.optimizer.DataFlowBitSet;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class Block {
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;
    static final boolean DEBUG = false;
    private static int debug_blockCount;

    Block(int n, int n2) {
        this.itsStartNodeIndex = n;
        this.itsEndNodeIndex = n2;
    }

    static void runFlowAnalyzes(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n;
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = optFunctionNode.fnode.getParamAndVarCount();
        int[] nArray = new int[n3];
        for (n = 0; n != n2; ++n) {
            nArray[n] = 3;
        }
        for (n = n2; n != n3; ++n) {
            nArray[n] = 0;
        }
        Block[] blockArray = Block.buildBlocks(nodeArray);
        Block.reachingDefDataFlow(optFunctionNode, nodeArray, blockArray, nArray);
        Block.typeFlow(optFunctionNode, nodeArray, blockArray, nArray);
        for (int i = n2; i != n3; ++i) {
            if (nArray[i] != 1) continue;
            optFunctionNode.setIsNumberVar(i);
        }
    }

    private static Block[] buildBlocks(Node[] nodeArray) {
        Object object;
        FatBlock fatBlock;
        int n;
        Hashtable<Node, FatBlock> hashtable = new Hashtable<Node, FatBlock>();
        ObjArray objArray = new ObjArray();
        int n2 = 0;
        block4: for (n = 0; n < nodeArray.length; ++n) {
            switch (nodeArray[n].getType()) {
                case 127: {
                    if (n == n2) continue block4;
                    fatBlock = Block.newFatBlock(n2, n - 1);
                    if (nodeArray[n2].getType() == 127) {
                        hashtable.put(nodeArray[n2], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n2 = n;
                    continue block4;
                }
                case 5: 
                case 6: 
                case 7: {
                    fatBlock = Block.newFatBlock(n2, n);
                    if (nodeArray[n2].getType() == 127) {
                        hashtable.put(nodeArray[n2], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n2 = n + 1;
                }
            }
        }
        if (n2 != nodeArray.length) {
            FatBlock fatBlock2 = Block.newFatBlock(n2, nodeArray.length - 1);
            if (nodeArray[n2].getType() == 127) {
                hashtable.put(nodeArray[n2], fatBlock2);
            }
            objArray.add(fatBlock2);
        }
        for (n = 0; n < objArray.size(); ++n) {
            Object object2;
            fatBlock = (FatBlock)objArray.get(n);
            object = nodeArray[fatBlock.realBlock.itsEndNodeIndex];
            int n3 = ((Node)object).getType();
            if (n3 != 5 && n < objArray.size() - 1) {
                object2 = (FatBlock)objArray.get(n + 1);
                fatBlock.addSuccessor((FatBlock)object2);
                ((FatBlock)object2).addPredecessor(fatBlock);
            }
            if (n3 != 7 && n3 != 6 && n3 != 5) continue;
            object2 = ((Node.Jump)object).target;
            FatBlock fatBlock3 = (FatBlock)hashtable.get(object2);
            ((Node)object2).putProp(6, fatBlock3.realBlock);
            fatBlock.addSuccessor(fatBlock3);
            fatBlock3.addPredecessor(fatBlock);
        }
        Block[] blockArray = new Block[objArray.size()];
        for (int i = 0; i < objArray.size(); ++i) {
            object = (FatBlock)objArray.get(i);
            Block block = ((FatBlock)object).realBlock;
            block.itsSuccessors = ((FatBlock)object).getSuccessors();
            block.itsPredecessors = ((FatBlock)object).getPredecessors();
            block.itsBlockID = i;
            blockArray[i] = block;
        }
        return blockArray;
    }

    private static FatBlock newFatBlock(int n, int n2) {
        FatBlock fatBlock = new FatBlock();
        fatBlock.realBlock = new Block(n, n2);
        return fatBlock;
    }

    private static String toString(Block[] blockArray, Node[] nodeArray) {
        return null;
    }

    private static void reachingDefDataFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        for (int i = 0; i < blockArray.length; ++i) {
            blockArray[i].initLiveOnEntrySets(optFunctionNode, nodeArray);
        }
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = blockArray.length - 1;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doReachedUseDataFlow() && (blockArray2 = blockArray[n].itsPredecessors) != null) {
                    for (int i = 0; i < blockArray2.length; ++i) {
                        int n2 = blockArray2[i].itsBlockID;
                        blArray[n2] = true;
                        bl |= n2 > n;
                    }
                }
            }
            if (n == 0) {
                if (!bl) break;
                n = blockArray.length - 1;
                bl = false;
                continue;
            }
            --n;
        }
        blockArray[0].markAnyTypeVariables(nArray);
    }

    private static void typeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = 0;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doTypeFlow(optFunctionNode, nodeArray, nArray) && (blockArray2 = blockArray[n].itsSuccessors) != null) {
                    for (int i = 0; i < blockArray2.length; ++i) {
                        int n2 = blockArray2[i].itsBlockID;
                        blArray[n2] = true;
                        bl |= n2 < n;
                    }
                }
            }
            if (n == blockArray.length - 1) {
                if (!bl) break;
                n = 0;
                bl = false;
                continue;
            }
            ++n;
        }
    }

    private static boolean assignType(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = nArray[n3] | n2;
        nArray[n3] = n4;
        return n2 != n4;
    }

    private void markAnyTypeVariables(int[] nArray) {
        for (int i = 0; i != nArray.length; ++i) {
            if (!this.itsLiveOnEntrySet.test(i)) continue;
            Block.assignType(nArray, i, 3);
        }
    }

    private void lookForVariableAccess(OptFunctionNode optFunctionNode, Node node) {
        switch (node.getType()) {
            case 102: 
            case 103: {
                Node node2 = node.getFirstChild();
                if (node2.getType() != 54) break;
                int n = optFunctionNode.getVarIndex(node2);
                if (!this.itsNotDefSet.test(n)) {
                    this.itsUseBeforeDefSet.set(n);
                }
                this.itsNotDefSet.set(n);
                break;
            }
            case 55: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                this.lookForVariableAccess(optFunctionNode, node4);
                this.itsNotDefSet.set(optFunctionNode.getVarIndex(node));
                break;
            }
            case 54: {
                int n = optFunctionNode.getVarIndex(node);
                if (this.itsNotDefSet.test(n)) break;
                this.itsUseBeforeDefSet.set(n);
                break;
            }
            default: {
                for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNext()) {
                    this.lookForVariableAccess(optFunctionNode, node5);
                }
            }
        }
    }

    private void initLiveOnEntrySets(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n = optFunctionNode.getVarCount();
        this.itsUseBeforeDefSet = new DataFlowBitSet(n);
        this.itsNotDefSet = new DataFlowBitSet(n);
        this.itsLiveOnEntrySet = new DataFlowBitSet(n);
        this.itsLiveOnExitSet = new DataFlowBitSet(n);
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = nodeArray[i];
            this.lookForVariableAccess(optFunctionNode, node);
        }
        this.itsNotDefSet.not();
    }

    private boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            for (int i = 0; i < this.itsSuccessors.length; ++i) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[i].itsLiveOnEntrySet);
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    private static int findExpressionType(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        Node node2;
        switch (node.getType()) {
            case 39: {
                return 1;
            }
            case 30: 
            case 37: 
            case 68: {
                return 0;
            }
            case 35: {
                return 3;
            }
            case 54: {
                return nArray[optFunctionNode.getVarIndex(node)];
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 102: 
            case 103: {
                return 1;
            }
            case 21: {
                Node node3 = node.getFirstChild();
                int n = Block.findExpressionType(optFunctionNode, node3, nArray);
                int n2 = Block.findExpressionType(optFunctionNode, node3.getNext(), nArray);
                return n | n2;
            }
        }
        if (node2 == null) {
            return 3;
        }
        int n = 0;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            n |= Block.findExpressionType(optFunctionNode, node2, nArray);
        }
        return n;
    }

    private static boolean findDefPoints(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        boolean bl = false;
        switch (node.getType()) {
            default: {
                Node node2;
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    bl |= Block.findDefPoints(optFunctionNode, node2, nArray);
                }
                break;
            }
            case 102: 
            case 103: {
                Node node2;
                if (node2.getType() != 54) break;
                int n = optFunctionNode.getVarIndex(node2);
                bl |= Block.assignType(nArray, n, 1);
                break;
            }
            case 34: 
            case 135: {
                Node node2;
                if (node2.getType() == 54) {
                    int n = optFunctionNode.getVarIndex(node2);
                    Block.assignType(nArray, n, 3);
                }
                while (node2 != null) {
                    bl |= Block.findDefPoints(optFunctionNode, node2, nArray);
                    node2 = node2.getNext();
                }
                break;
            }
            case 55: {
                Node node2;
                Node node3 = node2.getNext();
                int n = Block.findExpressionType(optFunctionNode, node3, nArray);
                int n2 = optFunctionNode.getVarIndex(node);
                bl |= Block.assignType(nArray, n2, n);
            }
        }
        return bl;
    }

    private boolean doTypeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, int[] nArray) {
        boolean bl = false;
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = nodeArray[i];
            if (node == null) continue;
            bl |= Block.findDefPoints(optFunctionNode, node, nArray);
        }
        return bl;
    }

    private boolean isLiveOnEntry(int n) {
        return this.itsLiveOnEntrySet != null && this.itsLiveOnEntrySet.test(n);
    }

    private void printLiveOnEntrySet(OptFunctionNode optFunctionNode) {
    }

    private static class FatBlock {
        private ObjToIntMap successors = new ObjToIntMap();
        private ObjToIntMap predecessors = new ObjToIntMap();
        Block realBlock;

        private FatBlock() {
        }

        private static Block[] reduceToArray(ObjToIntMap objToIntMap) {
            Block[] blockArray = null;
            if (!objToIntMap.isEmpty()) {
                blockArray = new Block[objToIntMap.size()];
                int n = 0;
                ObjToIntMap.Iterator iterator = objToIntMap.newIterator();
                iterator.start();
                while (!iterator.done()) {
                    FatBlock fatBlock = (FatBlock)iterator.getKey();
                    blockArray[n++] = fatBlock.realBlock;
                    iterator.next();
                }
            }
            return blockArray;
        }

        void addSuccessor(FatBlock fatBlock) {
            this.successors.put(fatBlock, 0);
        }

        void addPredecessor(FatBlock fatBlock) {
            this.predecessors.put(fatBlock, 0);
        }

        Block[] getSuccessors() {
            return FatBlock.reduceToArray(this.successors);
        }

        Block[] getPredecessors() {
            return FatBlock.reduceToArray(this.predecessors);
        }
    }
}

